pro ww_plotorbit
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plots orbit positions from interferometric or speckle data.
;
common WwPlotOrbit,plotorbit_wid,plotorbit_shown
common PlotOrbit,plotorbit_options
;
; Check status of currently displayed widgets
if n_elements(plotorbit_shown) eq 0 then plotorbit_shown=0
if plotorbit_shown then return
;
; Initialize options
if init_plotorbit() ne 0 then return
;
; Check data
list_poscomps,components
if strlen(components[0]) eq 0 then return
;
; Create the widget
plotorbit_wid=widget_base(kill_notify='ww_plotorbitdestroyed', $
	resource_name='oyster', $
	/column,title='PlotAstrometry',xoffset=!dxsize-471,yoffset=!dysize-293)
;
; Component selection
opmenu_wid=widget_droplist(plotorbit_wid,title='Component: ', $
	event_pro='ww_plotorbitcomp',value=components,uvalue=components)
plotorbit_options.component=components[0]
;
; Window size selection
wsizes=['400x400','600x600','800x800','1000x1000']
opmenusz_wid=widget_droplist(plotorbit_wid,title='Window:    ', $
	event_pro='ww_setwsize',value=wsizes,uvalue=wsizes)
!xsize=400
!ysize=400
;
; Menu selection
panel=widget_base(plotorbit_wid,/row)
utils=widget_base(panel,/column)
plot_menu=['1\Plot\ww_plotorbitok', $
	   '0\Screen', $
	   '0\File']
plot_menu_wid=cw_pdmenu(utils,plot_menu)
util_menu=['1\Util\ww_plotorbitutil', $
	   '0\Identify', $
	   '0\Window', $
	   '0\Range', $
	   '0\Ellipse', $
	   '0\Thiele', $
	   '0\Innes', $
	   '0\Date', $
	   '2\Edit']
util_menu_wid=cw_pdmenu(utils,util_menu)
clear_button_wid=widget_button(utils,value='Clear',event_pro='ww_plotorbithelp')
help_button_wid=widget_button(utils,value='HELP',event_pro='ww_plotorbithelp')
;
options=['Errors', $
	 'Flagged', $
	 'Ellipse', $
	 'Orbit', $
	 'Lines', $
	 'J2000', $
	 'Color']
option_wid=cw_bgroup(panel,column=2,options,/nonexclusive, $
 			event_funct='ww_plotorbitoptions')
;
; Display orbit widget
widget_control,plotorbit_wid,/realize
xmanager,'ww_plotorbit',plotorbit_wid,/no_block
plotorbit_shown=plotorbit_shown+1
;
; Reset plot ranges
!x.range=0
!y.range=0
!z.range=0
;
end
