pro ww_plotorbitutil,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common PlotOrbitDataInfo,plotscans,plotdata_x,plotdata_y
common PlotOrbit,plotorbit_options
common ScanData,scans,bgscans,bufferinfo,positions,velocities
common FitAstrometry,ellipse_options,orbit_options,e_parms,o_parms
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
widget_control,event.id,get_value=command
case command of
'Identify':begin
           if !d.window eq -1 then begin
		marquardtdata,y,ysig,ymod
		chisq=((y-ymod)/ysig)^2
		if n_elements(chisq) eq n_elements(positions) then begin
		   i=where(chisq gt -3,count)
		   for j=0,count-1 do print,positions[i[j]].date,chisq[i[j]]
		endif
		return
	   endif
	   index=where(binary_model.component eq plotorbit_options.component)
	   epoch=binary_model[index].epoch+2440000.d0
	   period=binary_model[index].period
           repeat begin
		icom=set_points(plotdata_x,plotdata_y,index)
		phase=(jy2jd(plotscans[index].jy)-epoch)/period mod 1
		if phase lt 0 then phase=phase+1
                print,'_____________________________'
                print,'NPOI Date : ',jd2date(2440000.d0+plotscans[index].jd $
			+double(system_config('NPOI','MIDNIGHT'))/24)
                print,'UT Date is: ',plotscans[index].date
		print,'Julian Year: ',plotscans[index].jy
		print,'Orbital phase: ',string(phase,format='(f14.4)')
                print,'____________***______________'
           endrep until icom eq 4
           end
'Window'  :begin
           if !d.window eq -1 then begin
                print,'***Error(WW_PLOTORBITUTIL): no plot window open!'
                return
           endif
           icom=set_boxes(box_x,box_y)
           if icom eq 4 then begin
                icom=set_boxes(box_x,box_y,/clear)
                !x.range=0
                !y.range=0
		print,'Window reset.'
           endif else begin
                !x.range=[box_x[0],box_x[1]]
                !y.range=[box_y[3],box_y[4]]
		print,'Window set.'
           endelse
           end
'Range'   :begin
	   read,ymin,ymax,prompt='Enter Y min,max (auto=0,0): '
           !y.range=[ymin,ymax]
	   read,xmin,xmax,prompt='Enter X min,max (auto=0,0): '
           !x.range=[xmin,xmax]
           print,'Range set.'
           end
'Ellipse' :begin
	   if !d.window eq -1 then begin
                print,'***Error(WW_PLOTORBITUTIL): no plot window currently open
                return
           endif
	   e_parms=set_ellipse()
	   end
'Thiele'  :o_parms=thiele()
'Innes'   :o_parms=innes()
'Date'	  :begin
           if !d.window eq -1 then begin
               print,'***Error(WW_PLOTORBITUTIL): no plot window open!'
               return
           endif
 	   date=''
	   read,date,prompt='Enter date (YYYY-MM-DD.f): '
	   parsedate,date,y,m,d,h
	   RAD=180/pi_circle
	   rt=binarypos(julian(y,m,d)+h/24,plotorbit_options.component)
	   oplot,[0,rt[0]*sin(rt[1]/RAD)],[0,rt[0]*cos(rt[1]/RAD)],psym=-3
	   end
'Edit'    :begin
	   repeat begin
        	icom=set_points(plotdata_x,plotdata_y,i)
        	positions[i].rho=-positions[i].rho
        	if positions[i].rho gt 0 then !p.color=tci(1) else !p.color=tci(2)
        	if plotorbit_options.e then begin
                	r=ellipse(positions[i].emajor,positions[i].eminor, $
                        	p+positions[i].pa)
                	x=r*cos(p)+ra[i]+positions[i].ex
                	y=r*sin(p)+dec[i]+positions[i].ey
                	oplot,x,y,psym=3
        	endif else begin
                	x=l*sin(p)
                	y=l*cos(p)
                	usersym,x,y,/fill
                	oplot,[ra[i],ra[i]],[dec[i],dec[i]],psym=8
        	endelse
 	    endrep until icom eq 4
	    end
;
endcase
;
end
