pro ww_plotutil,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Callback procedure for tasks working with data in PlotDataInfo.
; These are the buttons listed as utilities in the plot widget.
;
common ChameleonWids,plot_wid,td_wid,cal_wid,astrom_wid,pivot_wid,triple_wid
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common PlotDataInfo,plotscans,plotdata_x,plotdata_y,plotdata_y_bck
common FitPlotData,x_mid,x_scl,s
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
common PlotUtilWids,base_wid,list_wids
;
widget_control,event.id,get_value=command
;
if ps_options.d then begin
	print,'***Error(WW_PLOTUTIL): action not available for 3D plots!'
	return
endif
if ps_options.g then begin
	print,'***Error(WW_PLOTUTIL): action not available for Image plots!'
	return
endif
;
case command of
;
'Identify':begin
	   if !p.multi[1]*!p.multi[2] gt 1 then begin
	   	print,'***Error(WW_PLOTUTIL): more than one plot in window!'
	   	return
	   endif
	   if class eq 'uv' or class eq 'ncal' then begin
		print,'***Error(WW_PLOTUTIL): action not available!'
		return
	   endif
	   if !d.window eq -1 then begin
		print,'***Error(WW_PLOTUTIL): no plot window open!'
		return
	   endif
	   if !p.multi[1]*!p.multi[2] gt 1 then begin
	   	print,'***Error(WW_PLOTUTIL): more than one plot in window!'
	   	return
	   endif
 	   print,'___________________________'
	   print,'Click left button on point.'
	   print,'Click right button to exit!'
	   print,'___________***_____________'
	   repeat begin
		icom=set_points(plotdata_x,plotdata_y,index)
		t=plotscans.time[index]/3600
		print,'_______________________________________'
		print,'Star is: ',plotscans.star[index]
		print,'Time is:',hms(t),' (',t,')',format='(a,a,a,f10.7,a)'
		print,'IB=',plotscans.ib[index]+1, $
		    ', OB=',plotscans.ob[index]+1, $
		    ', TR=',plotscans.tr[index]+1, $
		    ', CH=',plotscans.ch[index]+1, $
		    ', BL=',plotscans.bl[index]+1, $
		    ', PT=',plotscans.pt[index]+1, $
		    format='(a,i1,a,i1,a,i1,a,i3,a,i1,a,i4)'
		print,'__________________***__________________'
	   endrep until icom eq 4
	   end
'H-Line'  :begin
	   if !d.window eq -1 then begin
		print,'***Error(WW_PLOTUTIL): no plot window open!'
		return
	   endif
	   print,'___________________________________________'
	   print,'Click left mouse button on plot window.'
	   print,'Click middle or right mouse button to exit!'
	   print,'__________________***______________________'
	   cursor,x,y,/down & icom=!err
	   device,set_graphics_function=6
	   x1=!x.crange[0] & x2=!x.crange[1]
	   xrange=x2-x1
	   x1=x1-0.1*xrange & x2=x2+0.1*xrange
	   oplot,[x1,x2],[y,y],psym=0
	   repeat begin
		cursor,x,yn,/change & icom=!err
		oplot,[x1,x2],[y,y],psym=0
		oplot,[x1,x2],[yn,yn],psym=0
		y=yn
	   endrep until (icom eq 4) or (icom eq 2)
	   if icom eq 4 then oplot,[x1,x2],[y,y],psym=0
	   device,set_graphics_function=3
	   end
'V-Line'  :begin
	   if !d.window eq -1 then begin
		print,'***Error(WW_PLOTUTIL): no plot window open!'
		return
	   endif
	   print,'___________________________________________'
	   print,'Click left mouse button on plot window.'
	   print,'Click middle or right mouse button to exit!'
	   print,'__________________***______________________'
	   cursor,x,y,/down & icom=!err
	   device,set_graphics_function=6
	   y1=!y.crange[0] & y2=!y.crange[1]
	   yrange=y2-y1
	   y1=y1-0.1*yrange & y2=y2+0.1*yrange
	   oplot,[x,x],[y1,y2],psym=0
	   repeat begin
		cursor,xn,y,/change & icom=!err
		oplot,[x,x],[y1,y2],psym=0
		oplot,[xn,xn],[y1,y2],psym=0
	   	print,string(13b),'x='+string(xn),format='(a,a,$)'
		x=xn
	   endrep until (icom eq 4) or (icom eq 2)
	   print,''
	   if icom eq 4 then oplot,[x,x],[y1,y2],psym=0
	   device,set_graphics_function=3
	   end
'FIT'     :begin
	   if class eq 'uv' or class eq 'ncal' then begin
		print,'***Error(WW_PLOTUTIL): action not available!'
		return
	   endif
	   if !d.window eq -1 then begin
		print,'***Error(WW_PLOTUTIL): no plot window open!'
		return
	   endif
	   if !p.multi[1]*!p.multi[2] gt 1 then begin
	   	print,'***Error(WW_PLOTUTIL): more than one plot in window!'
	   	return
	   endif
	   if n_elements(base_wid) eq 0 then base_wid=0L
	   if base_wid ne 0 then widget_control,base_wid,/destroy
; 	   Save original plotdata
	   plotdata_y_bck=plotscans.y
	   base_wid=ww_base('Base functions',[1,2,3,4],'ww_fitplotdata', $
				list_wids,group_leader=plot_wid)
           end
'Window'  :begin
	   if !d.window eq -1 then begin
		print,'***Error(WW_PLOTUTIL): no plot window open!'
		return
	   endif
	   if !p.multi[1]*!p.multi[2] gt 1 then begin
	   	print,'***Error(WW_PLOTUTIL): more than one plot in window!'
	   	return
	   endif
	   icom=set_boxes(box_x,box_y)
	   if icom eq 4 then begin
		icom=set_boxes(box_x,box_y,/clear)
  		!x.range=0 & !x.style=0
		!y.range=0 & !y.style=0
		print,'Window reset.'
	   endif else begin
		!x.range=[box_x[0],box_x[1]]
		!y.range=[box_y[3],box_y[4]]
		!x.style=1
		!y.style=1
		print,'Window set.'
	   endelse
	   end
'Range'	  :begin
	   read,ymin,ymax,prompt='Enter Y min,max (auto=0,0): '
	   !y.range=[ymin,ymax]
	   if total(abs(!y.range)) ne 0 then !y.style=1 else !y.style=0
	   read,xmin,xmax,prompt='Enter X min,max (auto=0,0): '
           !x.range=[xmin,xmax]
	   if total(abs(!x.range)) ne 0 then !x.style=1 else !x.style=0
	   print,'Range set.'
           end
'Mean':	   begin
	   if !d.window eq -1 then begin
                print,'***Error(WW_PLOTUTIL): no plot window open!'
                return
           endif
           if !p.multi[1]*!p.multi[2] gt 1 then begin
                print,'***Error(WW_PLOTUTIL): more than one plot in window!'
                return
           endif
	   if set_boxes(box_x,box_y) ne 4 then begin
	   	x=plotscans.x
	   	y=plotscans.y
	   	x_err=plotscans.xe
	   	y_err=plotscans.ye
	   	index=where((x gt box_x[0]) and (x lt box_x[1]) and $
		       	    (y gt box_y[2]) and (y lt box_y[1]),count)
	   	if count gt 0 then begin
	   		jndex=where(x_err[index] gt 0 $
			        and y_err[index] gt 0,count)
	   		if count gt 0 then begin
				x=x[index[jndex]]
				y=y[index[jndex]]
				e=y_err[index[jndex]]
				if ps_options.e then begin
					ym=total(y/e^2)/total(1/e^2)
					ye=sqrt(1/total(1/e^2))
					estring=' +/- '
				endif else begin
					ym=avg(y)
					ye=stddev(y)
					estring=' RMS='
				endelse
				print,'Average(y) = ',ym,estring,ye
				print,'Average(x) = ',avg(x)
			endif
	   	endif
	   endif else icom=set_boxes(box_x,box_y,/clear)
	   end
'Edit':    begin
	   if class eq 'uv' or class eq 'ncal' then begin
		print,'***Error(WW_PLOTUTIL): action not available!'
		return
	   endif
	   if !d.window eq -1 then begin
		print,'***Error(WW_PLOTUTIL): no plot window open!'
		return
	   endif
	   if !p.multi[1]*!p.multi[2] gt 1 then begin
		print,'***Error(WW_PLOTUTIL): more than one plot in window!'
		return
	   endif
	   if ps_options.m and ps_options.v then begin
		print,'***Error(WW_PLOTUTIL): please deselect Custom option!'
		return
	   endif
	   case class of
	   'point':begin
		if n_elements(pointflagtable) eq 0 then create_pointflagtable
		index=where(pointflagtable.time ge 0,count)
		end
	   'delay':begin
		if n_elements(pointflagtable) eq 0 then create_pointflagtable
		index=where(pointflagtable.time ge 0,count)
		end
	   'metro':begin
		if n_elements(inchflagtable) eq 0 then create_inchflagtable
		index=where(inchflagtable.time ge 0,count)
		end
	   'scan':begin
		if n_elements(scanflagtable) eq 0 then create_scanflagtable
		index=where(scanflagtable.time ge 0,count)
		end
	   'amoeba':begin
		if n_elements(scanflagtable) eq 0 then create_scanflagtable
		index=where(scanflagtable.time ge 0,count)
		end
	   'astrom':begin
		if n_elements(scanflagtable) eq 0 then create_scanflagtable
		index=where(scanflagtable.time ge 0,count)
		end
	   'bg':begin
		if n_elements(bgflagtable) eq 0 then create_bgflagtable
		index=where(bgflagtable.time ge 0,count)
		end
	   else:begin
		print,'***Error(WW_PLOTUTIL): no editing allowed in this class!'
		return
		end
	   endcase
	   id0=count
	   id=id0
	   timestamp=strmid(systime(),0,24)
	   ax_items=set_axitems(item_ids,units,abbrs)
	   reason=timestamp+' '+'MANUAL'+'_'+abbrs[plotscans.item[0]-1]
	   print,'Begin editing, REASON='+reason
	   icom=set_boxes(box_x,box_y,nbox)
	   icom=cw_form('0,LIST,Delete inside boxes|Delete outside boxes|Cancel,set_val
;
	   if icom.tag0 ne 2 then begin
;
;	   Start editing
	   t=plotscans.time
	   x=plotscans.x
	   y=plotscans.y
	   x_err=plotscans.xe
	   y_err=plotscans.ye
;
;	   Loop over boxes
	   for i=0,nbox-1 do begin
	   case icom.tag0 of
	      0:index=where((x gt box_x[0,i]) and (x lt box_x[1,i]) and $
		 (y gt box_y[2,i]) and (y lt box_y[1,i]),count)
	      1:index=where((x lt box_x[0,i]) or (x gt box_x[1,i]) or $
		 (y gt box_y[1,i]) or (y lt box_y[2,i]),count)
	   endcase
	   if count gt 0 then begin
	   	jndex=where(x_err[index] gt 0 and y_err[index] gt 0,count)
	   	if count gt 0 then index=index[jndex]
	   endif
	   if count gt 0 then begin
		n=id+count-1
		if count eq 1 then index=index[0]
		case class of
		'point':begin
                        set_pointflagtable,reason,plotscans.item[index], $
                          plotscans.ib[index],plotscans.ob[index], $
			  plotscans.tr[index],plotscans.ch[index], $
			  plotscans.bl[index],abs(plotscans.time[index])
			end
		'delay':begin
                        set_pointflagtable,reason,plotscans.item[index], $
                          plotscans.ib[index],plotscans.ob[index], $
			  plotscans.tr[index],plotscans.ch[index], $
			  plotscans.bl[index],abs(plotscans.time[index])
			end
		'metro':begin
                        set_inchflagtable,reason,plotscans.item[index], $
                          plotscans.ib[index],abs(plotscans.time[index])
			end
		'scan' :begin
			scanflagtable[id:n].reason=reason
			scanflagtable[id:n].item=plotscans.item[index]
			scanflagtable[id:n].baseline=plotscans.bl[index]
			scanflagtable[id:n].triple=plotscans.tr[index]
			scanflagtable[id:n].channel=plotscans.ch[index]
			scanflagtable[id:n].inbeam=plotscans.ib[index]
			scanflagtable[id:n].outbeam=plotscans.ob[index]
			scanflagtable[id:n].time=abs(plotscans.time[index])
			end
		'amoeba' :begin
			scanflagtable[id:n].reason=reason
			scanflagtable[id:n].item=plotscans.item[index]
			scanflagtable[id:n].baseline=plotscans.bl[index]
			scanflagtable[id:n].triple=plotscans.tr[index]
			scanflagtable[id:n].channel=plotscans.ch[index]
			scanflagtable[id:n].inbeam=plotscans.ib[index]
			scanflagtable[id:n].outbeam=plotscans.ob[index]
			scanflagtable[id:n].time=abs(plotscans.time[index])
			end
	       'astrom':begin
			scanflagtable[id:n].reason=reason
			scanflagtable[id:n].item=plotscans.item[index]
			scanflagtable[id:n].baseline=plotscans.bl[index]
			scanflagtable[id:n].triple=plotscans.tr[index]
			scanflagtable[id:n].channel=plotscans.ch[index]
			scanflagtable[id:n].inbeam=plotscans.ib[index]
			scanflagtable[id:n].outbeam=plotscans.ob[index]
			scanflagtable[id:n].time=abs(plotscans.time[index])
			end
		'bg'   :begin
			bgflagtable[id:n].reason=reason
			bgflagtable[id:n].item=plotscans.item[index]
			bgflagtable[id:n].channel=plotscans.ch[index]
			bgflagtable[id:n].outbeam=plotscans.ob[index]
			bgflagtable[id:n].time=abs(plotscans.time[index])
			end
		endcase
		id=n+1
		pcolor=!p.color
		!p.color=tci(2)
		oplot,x[index[0:count-1]],y[index[0:count-1]]
		if ps_options.e then begin
			if count gt 1 then $
				oploterr,x[index],y[index],y_err[index],3 $
			else begin
				x1=x[index[0]]
				y1=y[index[0]]
				e1=abs(y_err[index[0]])
				oploterr,[x1,x1],[y1,y1],[e1,e1],3
			endelse
		endif
		!p.color=pcolor
	   endif else icom=set_boxes(box_x,box_y,nbox,/clear)
	   endfor
;
	   endif
	   if id gt id0 then begin
		case class of
			'point' :flagpointdata,pointflagtable[id0:id-1],flag=1
			'delay' :flagpointdata,pointflagtable[id0:id-1],flag=1
			'metro' :flaginchdata,inchflagtable[id0:id-1],flag=1
			'scan'  :flagscandata,scanflagtable[id0:id-1],flag=1
			'amoeba':flagscandata,scanflagtable[id0:id-1],flag=1
			'astrom':flagscandata,scanflagtable[id0:id-1],flag=1
			'bg'    :flagbgdata,bgflagtable[id0:id-1],flag=1
		endcase
	   endif
	   end
;
endcase
;
end
