pro ww_plotvel
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plots radial velocities from spectroscopy.
;
common WwPlotVel,plotvel_wid,plotvel_shown
common PlotVel,plotvel_options
;
; Check status of currently displayed widgets
if n_elements(plotvel_shown) eq 0 then plotvel_shown=0
if plotvel_shown then return
;
; Initialize options
if init_plotvel() ne 0 then return
;
; Check data
list_velcomps,components
if strlen(components[0]) eq 0 then return
;
; Create the widget
plotvel_wid=widget_base(kill_notify='ww_plotveldestroyed', $
	resource_name='oyster', $
	/column,title='PlotSpectroscopy',xoffset=!dxsize-236,yoffset=!dysize-293)
;
; Component selection
opmenu_wid=widget_droplist(plotvel_wid,title='Component: ', $
	event_pro='ww_plotvelcomp',value=components,uvalue=components)
plotvel_options.component=components[0]
;
; Window size selection
wsizes=['400x400','600x600','800x800','1000x1000']
opmenusz_wid=widget_droplist(plotvel_wid,title='Window:    ', $
	event_pro='ww_setwsize',value=wsizes,uvalue=wsizes)
!xsize=400
!ysize=400
;
; Menu selection
panel=widget_base(plotvel_wid,/row)
utils=widget_base(panel,/column)
plot_menu=['1\Plot\ww_plotvelok', $
	   '0\Screen', $
	   '0\File']
plot_menu_wid=cw_pdmenu(utils,plot_menu)
util_menu=['1\Util\ww_plotvelutil', $
	   '0\Identify', $
	   '0\Window', $
	   '0\Range', $
	   '0\Date', $
	   '2\Edit']
util_menu_wid=cw_pdmenu(utils,util_menu)
clear_button_wid=widget_button(utils,value='Clear',event_pro='ww_plotvelhelp')
help_button_wid=widget_button(utils,value='HELP',event_pro='ww_plotvelhelp')
;
options=['Errors', $
	 'Flagged', $
	 'Phase', $
	 'Orbit', $
	 'Color', $
	 'Paper', $
	 'All in 1', $
	 'Residuals']
option_wid=cw_bgroup(panel,column=2,options,/nonexclusive, $
 			event_funct='ww_plotveloptions')
;
; Display vel widget
widget_control,plotvel_wid,/realize
xmanager,'ww_plotorbit',plotvel_wid,/no_block
plotvel_shown=plotvel_shown+1
;
; Reset plot ranges
!x.range=0
!y.range=0
!z.range=0
;
end
