pro ww_plotvelutil,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common PlotVel,plotvel_options
common PlotVelDataInfo,plotscans,plotdata_x,plotdata_y
common ScanData,scans,bgscans,bufferinfo,positions,velocities
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common FitAstrometry,ellipse_options,vel_options,e_parms,o_parms
;
widget_control,event.id,get_value=command
;
case command of
'Identify':begin
           repeat begin
		icom=set_points(plotdata_x,plotdata_y,index)
                print,'_____________________________'
                print,'Date is: ',plotscans[index].date
		print,'JD: ',plotscans[index].jd+2440000l,format='(a,f12.4)'
                print,'____________***______________'
           endrep until icom eq 4
           end
'Window'  :begin
           icom=set_boxes(box_x,box_y)
           if icom eq 4 then begin
                icom=set_boxes(box_x,box_y,/clear)
                !x.range=0
                !y.range=0
           endif else begin
                !x.range=[box_x[0],box_x[1]]
                !y.range=[box_y[3],box_y[4]]
           endelse
           end
'Date'	  :begin
           if !d.window eq -1 then begin
                print,'***Error(WW_PLOTVELITUTIL): no plot window open!'
                return
           endif
	   if plotvel_options.p then begin
 	   date=''
	   read,date,prompt='Enter date (YYYY-MM-DD): '
	   parsedate,date,y,m,d
           ci=strpos(binary_model.component,plotvel_options.component)
           i=where(ci ge 0)
           components=binary_model[i].component
           periods=binary_model[i].period
           si=sort(strlen(components))
           components=components[si]
           periods=periods[si]
           j=where(periods ne 0) & j=j[0]
           i=where(binary_model.component eq components[j]) & i=i[0]
           x=(julian(y,m,d)-binary_model[i].epoch-2440000.d0)/binary_model[i].pe
                   mod 1
	   oplot,[x,x],[-200,200],psym=-1,color=tci(3)
	   endif
	   end
'Range'   :begin
	   read,ymin,ymax,prompt='Enter Y min,max (auto=0,0): '
           !y.range=[ymin,ymax]
	   read,xmin,xmax,prompt='Enter X min,max (auto=0,0): '
           !x.range=[xmin,xmax]
           print,'Range set.'
           end
else	  :print,'Choice not available!'
;
endcase
;
end
