pro ww_reducebg,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Dispatch for REDUCE BG Data button
;
common Hds,path,hds_file_stub
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
;
; Set the class
class='bg'
widget_control,event.id,get_value=command
case command of
       'PLOT'  :begin
		if init_plot(class,'pt') ne 0 then return
		ww_plot
		end
       'Expand BG':begin
		expandbg
		end
       'Process BG':begin
		processbg
		end
       'Median BG':begin
		medianbg
		end
       'Default BG':begin
		defaultbg
		end
       'Load'  :begin
		if n_elements(hds_file_stub) eq 0 then return
		filename=hds_file_stub+'.flg'
		result=findfile(filename,count=fcount)
		if fcount ne 0 then restore,filename else begin
		      print,'***Error(WW_REDUCEBG):',filename,' does not exist!'
		      return
		endelse
		result=size(bg_table) & n=n_elements(result)
		if result[n-2] ne 8 then begin
			print,'***Error(WW_REDUCEBG): ',filename, $
				' does not contain table!'
			return
		endif
		create_bgflagtable
		for i=0,n_elements(bgflagtable)-1 do begin
			t=bgflagtable[i]
			struct_assign,bg_table[i],t
			bgflagtable[i]=t
		endfor
;		bgflagtable=bg_table
		print,'Restored bgflagtable.'
		end
       'Apply' :begin
		if checkdata([18]) ne 0 then return
		index=where(bgflagtable.time ge 0,count)
		if count ne 0 then flagbgdata,bgflagtable[index],flag=1 $
			else print,'Flagtable empty!'
		end
       'UNFLAG':begin
		ww_listflagreasons,class
		end
       'Save'  :begin
		if checkdata([18]) ne 0 then return
		filename=hds_file_stub+'.flg'
		result=findfile(filename,count=fcount)
		if fcount ne 0 then restore,filename
		if n_elements(point_table) eq 0 then point_table=0
		if n_elements(inch_table) eq 0 then inch_table=0
		if n_elements(scan_table) eq 0 then scan_table=0
		bg_table=bgflagtable
		save,filename=filename,point_table,inch_table,bg_table,scan_table
		print,'Saved bgflagtable.'
		end
       'Clear' :begin
		if checkdata([18]) ne 0 then return
		bgflagtable[*].time=-1
		print,'Cleared bgflagtable.'
		end
       'Reset' :begin
		resetflag,'bg'
		print,'Flags removed.'
		end
endcase
;
end
