pro ww_reducemt,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Dispatch for METROLOGY button.
;
common Hds,path,hds_file_stub
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
;
; Set the class
class='metro'
;
widget_control,event.id,get_value=command
case command of
       'PLOT'  :begin
		if checkdata([16]) ne 0 then return
	 	if init_plot(class,'pt') ne 0 then return
	 	ww_plot
	 	end
       'MetroCorr':begin
		if checkdata([16]) ne 0 then return
		metrocorr
		end
       'AstroCorr':begin
		if checkdata([16]) ne 0 then return
		astrocorr
		end
       'Init'  :metroinit
       'Load'  :begin
		if n_elements(hds_file_stub) eq 0 then return
		filename=file+'.flg'
		result=findfile(filename,count=fcount)
		if fcount ne 0 then restore,filename else begin
     		      print,'***Error(WW_REDUCEMT):',filename,' does not exist!'
     		      return
		endelse
		result=size(inch_table) & n=n_elements(result)
		if result[n-2] ne 8 then begin
		      print,'***Error(WW_REDUCEMT): ',filename, $
		      ' does not contain table!'
	      	      return
		endif
		inchflagtable=inch_table
		print,'Restored inchflagtable.'
		end
       'Apply' :begin
		if checkdata([16,20]) ne 0 then return
		index=where(inchflagtable.time ge 0,count)
		if count ne 0 then flaginchdata,inchflagtable[index],flag=1 $
     			else print,'Warning(WW_REDUCEMT): Flagtable empty!'
		end
       'UNFLAG':begin
		ww_listflagreasons,class
		end
       'Save'  :begin
		if checkdata([20]) ne 0 then return
		filename=hds_file_stub+'.flg'
		result=findfile(filename,count=fcount)
		if fcount ne 0 then restore,filename
		if n_elements(point_table) eq 0 then point_table=0
		if n_elements(bg_table) eq 0 then bg_table=0
		if n_elements(scan_table) eq 0 then scan_table=0
		inch_table=inchflagtable
		save,filename=filename,point_table,inch_table,bg_table,scan_table
		print,'Saved inchflagtable.'
		end
       'Clear' :begin
		if checkdata([20]) ne 0 then return
		inchflagtable[*].time=-1
		print,'Cleared inchflagtable.'
		end
       'Reset' :begin
		resetflag,'metro'
		print,'Flags removed.'
		end
endcase
;
end
