pro ww_reducept,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Dispatch for REDUCE PointData button.
;
common Hds,path,hds_file_stub
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
;
; Set the class
class='point'
;
widget_control,event.id,get_value=command
case command of
       'PLOT'  :begin
		if init_plot(class,'pt') ne 0 then return
		ww_plot
		end
       'A/R triple':begin
		ww_triplesel
		end
       'Unwrap triple':begin
		unwraptriple
		end
       'Clear data':begin
		clearpointdata
		end
       'Clear bias':begin
		clearbiasdata
		end
       'Load'  :begin
		filename=hds_file_stub+'.flg'
		result=findfile(filename,count=fcount)
		if fcount ne 0 then restore,filename else begin
     		      print,'***Error(WW_REDUCEPT):',filename,' does not exist!'
     		      return
		endelse
		result=size(point_table) & n=n_elements(result)
		if result[n-2] ne 8 then begin
		      print,'***Error(WW_REDUCEPT): ',filename, $
		      ' does not contain table!'
	      	      return
		endif
		create_pointflagtable,n_elements(point_table)
		for i=0,n_elements(pointflagtable)-1 do begin
			t=pointflagtable[i]
			struct_assign,point_table[i],t
			pointflagtable[i]=t
		endfor
;		pointflagtable=point_table
		print,'Restored pointflagtable.'
		end
       'Apply' :begin
		if checkdata([17]) ne 0 then return
		index=where(pointflagtable.time ge 0,count)
		if count ne 0 then flagpointdata,pointflagtable[index],flag=1 $
     			else print,'Warning(WW_REDUCEPT): Flagtable empty!'
		end
       'UNFLAG':begin
		ww_listflagreasons,class
		end
       'Save'  :begin
		if checkdata([17]) ne 0 then return
		filename=hds_file_stub+'.flg'
		result=findfile(filename,count=fcount)
		if fcount ne 0 then restore,filename
		if n_elements(inch_table) eq 0 then inch_table=0
		if n_elements(bg_table) eq 0 then bg_table=0
		if n_elements(scan_table) eq 0 then scan_table=0
		point_table=pointflagtable
		save,filename=filename,point_table,inch_table,bg_table,scan_table
		print,'Saved pointflagtable.'
		end
       'Clear' :begin
		if checkdata([17]) ne 0 then return
		pointflagtable[*].time=-1
		print,'Cleared pointflagtable.'
		end
       'Reset' :begin
		resetflag,'point'
		print,'Flags removed.'
		end
endcase
;
end
