pro ww_scans,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Dispatch for scan calibration.
;
common Hds,path,hds_file_stub
common Tables,ScanTable,BGTable,StationTable
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
;
if checkdata([1,3,5,6,7,8,9]) ne 0 then return
;
; Set the class
class='scan'
;
widget_control,event.id,get_value=command
case command of
	'PLOT'		   :begin
			    if init_plot(class,'pt') ne 0 then return
			    ww_plot
			    end
	'CALIBRATE'        :ww_cal
	'RewrapTriple'	   :rewraptriple
	'DewrapTriple'	   :dewraptriple
	'ManualUnwrap'	   :manualunwrap
	'FlagIncoh'	   :begin
			    print,'Flagging incoherent scans...'
			    index=where(scantable.code eq 0,count)
			    if count gt 0 then flagscandata,sc=index+1,item=24,reason='incoh'
			    end
	'SetErrors'	   :set_viserrors
	'SetComplex'	   :set_complexvis
	'Load'             :begin
			    if n_elements(hds_file_stub) eq 0 then return
			    filename=file+'.flg'
			    result=findfile(filename,count=fcount)
			    if fcount ne 0 then restore,filename else begin
			      print,'***Error(WW_CALIBRATE):',filename, $
					' does not exist!'
			      return
			    endelse
			    result=size(scan_table) & n=n_elements(result)
			    if result[n-2] ne 8 then begin
			      print,'***Error(WW_CALIBRATE): ',filename, $
					' does not contain table!'
			      return
			    endif
			    create_scanflagtable
			    for i=0,n_elements(scanflagtable)-1 do begin
				t=scanflagtable[i]
				struct_assign,scan_table[i],t
				scanflagtable[i]=t
			    endfor
;			    scanflagtable=scan_table
			    print,'Restored scanflagtable.'
			    end
	'Apply'            :begin
			    if n_elements(scanflagtable) ne 0 then begin
			    	index=where(scanflagtable.time ge 0,count)
			    	if count ne 0 then $
					flagscandata,scanflagtable[index],flag=1 $
					else print,'Flagtable empty!'
			    endif else print,'***Error(WW_CALIBRATE): '+ $
						'table does not exist!'
			    end
        'UNFLAG'           :ww_listflagreasons,class
	'Save'             :begin
			    if n_elements(scanflagtable) eq 0 then begin
				print,'***Error(WW_CALIBRATE): '+ $
						'table does not exist!'
				return
			    endif
			    filename=hds_file_stub+'.flg'
			    result=findfile(filename,count=fcount)
			    if fcount ne 0 then restore,filename
			    if n_elements(point_table) eq 0 then point_table=0
			    if n_elements(inch_table) eq 0 then inch_table=0
			    if n_elements(bg_table) eq 0 then bg_table=0
			    scan_table=scanflagtable
			    save,filename=filename, $
				point_table,inch_table,bg_table,scan_table
			    print,'Saved scanflagtable.'
			    end
	'Clear'            :begin
			    if n_elements(scanflagtable) eq 0 then begin
				print,'***Error(WW_CALIBRATE): '+ $
						'table does not exist!'
				return
			    endif
			    scanflagtable[*].time=-1
			    print,'Cleared scanflagtable.'
			    end
	'Reset'		   :begin
			    resetflag,class
			    print,'Flags removed.'
			    end
endcase
;
end
