pro ww_setpreset,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common ChameleonWids,plot_wid,td_wid,cal_wid,astrom_wid,pivot_wid,triple_wid
common PlotWids1,dropy_wid,dropx_wid,dropsl_wid
common PlotWids2,dropst_wid,listst_wid,dropnt_wid,option_wid
common IndexSelDropWids,dropch_wid,dropbl_wid,droptr_wid,droppt_wid
common IndexSelTextWids,textch_wid,textbl_wid,textpt_wid
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SelDirs,nt_dir,nt_sel,st_dir,st_sel,x_dir,y_dir,z_dir,x_sel,y_sel,z_sel
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common StarBase,StarTable,Notes
;
widget_control,event.id,get_uvalue=presets
preset=presets[event.index]
;
; Using preset, the user can create plot widgets with pre-defined settings
case preset of
'Preset':begin
	print,'Select a pre-defined'
	print,'plot selection.'
	end
'V_cal':begin
	widget_control,dropx_wid,set_droplist_select=0
	ww_setxaxis,{index:0,top:plot_wid}
	widget_control,dropy_wid,set_droplist_select=11
	ww_setyaxis,{index:11,top:plot_wid}
	if class eq 'amoeba' then begin
		widget_control,dropy_wid,set_droplist_select=6
		ww_setyaxis,{index:6,top:plot_wid}
	endif
	widget_control,dropsl_wid,set_droplist_select=5 & slice='pt'
	widget_control,dropst_wid,set_droplist_select=1 & st_dir='Cal'
	widget_control,dropch_wid,set_droplist_select=1
	y_dir.ch='Selected'
	y_sel.ch=0
	y_sel.ch[0]=1
	widget_control,textch_wid,set_value='1'
	mch=n_elements(y_sel.ch)/2 ; choose middle channel
	y_sel.ch[0]=mch
	widget_control,textch_wid,set_value=strtrim(string(mch),1)
	widget_control,dropbl_wid,set_droplist_select=0
	y_dir.bl='All'
	widget_control,droppt_wid,set_droplist_select=0
	y_dir.pt='All'
	!y.range=[0,1.2]
	widget_control,option_wid,set_value=[1,0,1,0,0,0,0,0,0,0,0,0]
	ps_options.e=1	; Errors
	ps_options.l=1	; Lines
	ps_options.a=0	; All-in-one
	ps_options.m=0	; Model (#11)
	end
'V_pt':	begin
	widget_control,dropx_wid,set_droplist_select=0
	ww_setxaxis,{index:0,top:plot_wid}
	widget_control,dropy_wid,set_droplist_select=9
	ww_setyaxis,{index:9,top:plot_wid}
	if class eq 'amoeba' then begin
		widget_control,dropy_wid,set_droplist_select=6
		ww_setyaxis,{index:6,top:plot_wid}
	endif
	widget_control,dropsl_wid,set_droplist_select=5 & slice='pt'
	widget_control,dropst_wid,set_droplist_select=3 & st_dir='Sel'
 	if class eq 'amoeba' then stars=startable.starid $
			     else list_stars,stars
	if n_elements(gen_model) ne 0 then star=gen_model.starid $
				      else star=stars[0]
	st_sel=star
	index=where(stars eq star)
	widget_control,listst_wid,set_list_sel=index[0]
	widget_control,dropch_wid,set_droplist_select=1
	y_dir.ch='Selected'
	y_sel.ch=0
	y_sel.ch[0]=1
	widget_control,textch_wid,set_value='1'
	widget_control,dropbl_wid,set_droplist_select=0
	y_dir.bl='All'
	widget_control,droppt_wid,set_droplist_select=0
	y_dir.pt='All'
	!y.range=[0,1.2]
	widget_control,option_wid,set_value=[1,0,1,0,0,0,0,0,0,0,0,0]
	ps_options.e=1	; Errors
	ps_options.l=1	; Lines
	ps_options.a=0	; All-in-one
	ps_options.m=0	; Model (#11)
	if n_elements(gen_model) ne 0 then begin
		ps_options.m=1	; Model
		widget_control,option_wid,set_value=[1,0,0,0,0,0,0,0,0,0,0,1]
	endif
	end
'V_ch':	begin
	widget_control,dropx_wid,set_droplist_select=2
	ww_setxaxis,{index:2,top:plot_wid}
	if class eq 'amoeba' then begin
		widget_control,dropy_wid,set_droplist_select=6
		ww_setyaxis,{index:6,top:plot_wid}
	endif else begin
		widget_control,dropy_wid,set_droplist_select=9
		ww_setyaxis,{index:9,top:plot_wid}
	endelse
	widget_control,dropsl_wid,set_droplist_select=3 & slice='ch'
	widget_control,dropst_wid,set_droplist_select=3 & st_dir='Sel'
 	if class eq 'amoeba' then stars=startable.starid $
			     else list_stars,stars
	if n_elements(gen_model) ne 0 then star=gen_model.starid $
				      else star=stars[0]
	st_sel=star
	index=where(stars eq star)
	widget_control,listst_wid,set_list_sel=index[0]
	widget_control,dropch_wid,set_droplist_select=0
	y_dir.ch='All'
;	Initialize for first baseline
	widget_control,dropbl_wid,set_droplist_select=1
	y_dir.bl='Selected'
	y_sel.bl=0
	y_sel.bl[0]=1
	widget_control,textbl_wid,set_value='1'
;	Initialize for all baselines
	widget_control,dropbl_wid,set_droplist_select=0
	y_dir.bl='All'
	y_sel.bl=0
	y_sel.bl[*]=1
	widget_control,textbl_wid,set_value='1'
	widget_control,droppt_wid,set_droplist_select=0
;	Initialize for all data points
	y_dir.pt='All'
	!y.range=[0,1.2]
	widget_control,option_wid,set_value=[1,0,1,0,0,0,0,0,0,0,0,0]
	ps_options.e=1	; Errors
	ps_options.l=1	; Lines
	ps_options.a=0	; All-in-one
	ps_options.m=0	; Model (#11)
	if n_elements(gen_model) ne 0 then begin
		ps_options.m=1	; Model
		ps_options.l=0	; Lines
		widget_control,option_wid,set_value=[1,0,0,0,0,0,0,0,0,0,0,1]
	endif
	end
'TA_ch':begin
	widget_control,dropx_wid,set_droplist_select=2
	ww_setxaxis,{index:2,top:plot_wid}
	if class eq 'amoeba' then begin
		widget_control,dropy_wid,set_droplist_select=9
		ww_setyaxis,{index:9,top:plot_wid}
	endif else begin
		if strpos(instrument_id(systemid),'GRAVITY') ge 0 $
		or strpos(instrument_id(systemid),'MATISSE') ge 0 $
			then o=3 else o=0
		widget_control,dropy_wid,set_droplist_select=16+o
		ww_setyaxis,{index:16+o,top:plot_wid}
	endelse
	widget_control,dropsl_wid,set_droplist_select=3 & slice='ch'
	widget_control,dropst_wid,set_droplist_select=3 & st_dir='Sel'
 	if class eq 'amoeba' then stars=startable.starid $
			     else list_stars,stars
	if n_elements(gen_model) ne 0 then star=gen_model.starid $
				      else star=stars[0]
	st_sel=star
	index=where(stars eq star)
	widget_control,listst_wid,set_list_sel=index[0]
	widget_control,dropch_wid,set_droplist_select=0
	y_dir.ch='All'
;	widget_control,dropbl_wid,set_droplist_select=1
;	y_dir.bl='Selected'
;	y_sel.bl=0
;	y_sel.bl(0)=1
;	widget_control,textbl_wid,set_value='1'
	widget_control,droppt_wid,set_droplist_select=0
	y_dir.pt='All'
	!y.range=[0,1.2]
	widget_control,option_wid,set_value=[1,0,1,0,0,0,0,0,0,0,0,0]
	ps_options.e=1	; Errors
	ps_options.l=1	; Lines
	ps_options.a=0	; All-in-one
	ps_options.m=0	; Model (#11)
	if n_elements(gen_model) ne 0 then begin
		ps_options.m=1	; Model
		ps_options.l=0	; Lines
		widget_control,option_wid,set_value=[1,0,0,0,0,0,0,0,0,0,0,1]
	endif
	end
'TP_ch':begin
	widget_control,dropx_wid,set_droplist_select=2
	ww_setxaxis,{index:2,top:plot_wid}
	if class eq 'amoeba' then begin
		widget_control,dropy_wid,set_droplist_select=10
		ww_setyaxis,{index:10,top:plot_wid}
	endif else begin
		if strpos(instrument_id(systemid),'GRAVITY') ge 0 $
		or strpos(instrument_id(systemid),'MATISSE') ge 0 $
			then o=3 else o=0
		widget_control,dropy_wid,set_droplist_select=20+o
		ww_setyaxis,{index:20+o,top:plot_wid}
	endelse
	widget_control,dropsl_wid,set_droplist_select=3 & slice='ch'
	widget_control,dropst_wid,set_droplist_select=3 & st_dir='Sel'
 	if class eq 'amoeba' then stars=startable.starid $
			     else list_stars,stars
	if n_elements(gen_model) ne 0 then star=gen_model.starid $
				      else star=stars[0]
	st_sel=star
	index=where(stars eq star)
	widget_control,listst_wid,set_list_sel=index[0]
	widget_control,dropch_wid,set_droplist_select=0
	y_dir.ch='All'
;	widget_control,dropbl_wid,set_droplist_select=1
;	y_dir.bl='Selected'
;	y_sel.bl=0
;	y_sel.bl(0)=1
;	widget_control,textbl_wid,set_value='1'
	widget_control,droppt_wid,set_droplist_select=0
	y_dir.pt='All'
	!y.range=[-180,180]
	widget_control,option_wid,set_value=[1,0,1,0,0,0,0,0,0,0,0,0]
	ps_options.e=1	; Errors
	ps_options.l=1	; Lines
	ps_options.a=0	; All-in-one
	ps_options.m=0	; Model (#11)
	if n_elements(gen_model) ne 0 then begin
		ps_options.m=1	; Model
		ps_options.l=0	; Lines
		widget_control,option_wid,set_value=[1,0,0,0,0,0,0,0,0,0,0,1]
	endif
	end
else:	return
endcase
;
end
