pro ww_utilities,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Dispatch for UTILITIES button.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,ScanTable,BGTable,StationTable
common Starbase,startable,notes
common Logs,ScanLog,ObserverLog,ConstrictorLog,OysterLog,InchwormLog
;
widget_control,event.id,get_value=command
case command of
	'MEMO':	begin
		help_wid=widget_base(/col,resource_name='oyster', $
			title='Memo search')
		text_wid=widget_text(help_wid,event_pro='ww_memo', $
			/editable,xsize=40)
		list_wid=widget_list(help_wid,value=' ', $
			ysize=6,event_pro='ww_memolist')
		widget_control,text_wid,set_uvalue=list_wid
		widget_control,help_wid,/realize
		xmanager,'memo',help_wid,/no_block
		end
	'OBSBASE':	begin
			spawn,'whoami',userid
			if userid[0] ne 'chummel' then begin
			   print,'***Error(WW_UTILITIES): permission denied!'
			   return
			endif
			ww_obssel
			end
	'.CAL->.CHA':	ww_calsel
	'.CHA->.OIFITS':ww_chasel
	'Load Night':	begin
			if n_elements(GenInfo) gt 0 then begin
			nights=GenInfo.Date+' '+GeoInfo.SystemId+' '+GenInfo.ConfigId
			window_wid=widget_base(title='Nights in buffer', $
				resource_name='oyster')
		   	list_wid=widget_list(window_wid,value=nights,uvalue=nights, $
			event_pro='ww_loadnight',ysize=n_elements(nights))
		   	widget_control,window_wid,/realize
		   	xmanager,'ww_loadnight',window_wid,/no_block
			endif
			end
	'Load StarTable'  :begin
			   get_startable
			   read_notes
			   end
	'Summary':begin
		  list_summary_chameleon
		  print,'Summary complete.'
		  end
	'Stars'  :list_stars
	'Scans'  :list_scans
	'BGScans':list_bgscans
	'ScnLog' :begin
		  if n_elements(ScanLog) gt 0 then begin
		  if strlen(strcompress(ScanLog,/remove)) gt 0 then begin
			index=where(byte(ScanLog) eq 10)
		  	xdisplayfile,'',title='ScanLog', $
				text=ScanLog+' ', $
				width=max(index-shift(index,1))
		  endif else print,'ScanLog empty!'
		  endif else print,'ScanLog nonexistent!'
		  end
	'ObsLog' :begin
		  if n_elements(ObserverLog) gt 0 then begin
		  if strlen(strcompress(ObserverLog,/remove)) gt 0 then begin
			index=where(byte(ObserverLog) eq 10)
		  	xdisplayfile,'',title='ObserverLog', $
				text=ObserverLog+' ', $
				width=max(index-shift(index,1))
		  endif else print,'ObserverLog empty!'
		  endif else print,'ObserverLog nonexistent!'
		  end
	'ConLog' :begin
		  if n_elements(ConstrictorLog) gt 0 then begin
		  if strlen(strcompress(ConstrictorLog,/remove)) gt 0 then begin
			index=where(byte(ConstrictorLog) eq 10)
		  	xdisplayfile,'',title='ConstrictorLog', $
				text=ConstrictorLog+' ', $
				width=max(index-shift(index,1))
		  endif else print,'ConstrictorLog empty!'
		  endif else print,'ConstrictorLog nonexistent!'
		  end
	'STARS':begin
		list_stars,stars
		if stars[0] ne '' then begin
		   window_wid=widget_base(title='StarInfo', $
				resource_name='oyster')
		   list_wid=widget_list(window_wid,value=stars,uvalue=stars, $
			event_pro='ww_starinfo',ysize=5)
		   widget_control,window_wid,/realize
		   xmanager,'ww_starinfo',window_wid,/no_block
		endif
		end
	'Star':begin
	       if n_elements(startable) ne 0 then startable_save=startable
	       star=strarr(1)
	       read,star,prompt='Enter star name: '
	       star=strupcase(star)
	       get_startable,star
	       list_star,star
	       if n_elements(startable_save) ne 0 then startable=startable_save
	       end
	'ScanForms':print_scanforms
	'SpecForms':print_specforms
endcase
;
end
