pro ww_volvoxsolve
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Display a widget to compute multiple-night solutions for star positions and
; proper motions. This widget shares resources with the other astrometry
; widget.
;
common SetFitStarsInfo,sel_stars,stars_directive	; Local common block (2)
common SetStationsInfo,sel_stations,stations_directive	; Local common block (2)
common SetFitNightsInfo,sel_nights,nights_directive	; Local common block (3)
common FitInfo,fit_stations,fit_stars,fit_data,fit_nights,fit_parms
common ChameleonWids,plot_wid,td_wid,cal_wid,astrom_wid,pivot_wid,triple_wid
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
;
; This is to tell the compiler that ww_astromfit is a function
forward_function ww_volvoxfit
;
; Remove existing widget
if n_elements(astrom_wid) eq 0 then astrom_wid=0L
if astrom_wid ne 0 then widget_control,astrom_wid,/destroy
;
astrom_wid=widget_base(title='VolvoxSolve',resource_name='oyster',/column, $
	kill_notify='ww_astromdestroyed',uvalue='Volvox', $
	xoffset=!dxsize-504,yoffset=!dysize-307)
;
; First two widget elements are in a row
row_wid=widget_base(astrom_wid,/row)
;
; Station selection
if n_elements(stationtable) eq 0 then get_stationtable,update=0
station_dirs=['All','Sel']
stations_directive='All'
fit_stations=stationtable.stationid
sel_stations=''
column1_wid=widget_base(row_wid,/column)
opmenustn_wid=widget_droplist(column1_wid,title='Stns:', $
	value=station_dirs,uvalue=station_dirs, $
	event_pro='ww_setstations')
stations=stationtable.stationid
list1_wid=widget_list(column1_wid,value=stations,uvalue=stations,/multiple, $
	event_pro='ww_setstations',xsize=3,ysize=3)
;
; Star selection
star_dirs=['All','Sel']
stars_directive=star_dirs[0]
fit_stars=startable.starid
sel_stars=''
column2_wid=widget_base(row_wid,/column)
opmenustr_wid=widget_droplist(column2_wid,title='Stars:', $
	value=star_dirs,uvalue=star_dirs, $
	event_pro='ww_setfitstars')
widget_control,opmenustr_wid,set_droplist_select=0
stars=startable.starid
list2_wid=widget_list(column2_wid,value=stars,uvalue=stars,/multiple, $
	event_pro='ww_setfitstars',ysize=3)
;
row2_wid=widget_base(astrom_wid,/row)
;
; Use uncorrected or corrected delays
data_dirs=['FDL','GRP','DRY','WET']
fit_data=data_dirs[0]
opmenuda_wid=widget_droplist(row2_wid,title='Data:', $
		value=data_dirs,uvalue=data_dirs, $
		event_pro='ww_setastrodata')
;
; Star parameters to solve for
fit_dirs=['RA/Dec','P&PMs','PMs']
fit_parms=fit_dirs[0]
opmenupa_wid=widget_droplist(row2_wid,title='Parm:', $
 		value=fit_dirs,uvalue=fit_dirs, $
 		event_pro='ww_setastroparms')
;
; Night selection
night_dirs=['All','Sel']
nights_directive=night_dirs[0]
fit_nights=geninfo.date+' '+geninfo.configid
sel_nights=''
opmenunt_wid=widget_droplist(astrom_wid,title='Nights:         ', $
	value=night_dirs,uvalue=night_dirs, $
	event_pro='ww_setfitnights')
widget_control,opmenunt_wid,set_droplist_select=0
nights=fit_nights
list3_wid=widget_list(astrom_wid,value=nights,uvalue=nights,/multiple, $
	event_pro='ww_setfitnights',ysize=3)
;
; Button box
button_wid=cw_bgroup(astrom_wid,/row,['Solve','Fit','Save','HELP'], $
	event_funct='ww_volvoxfit',/return_name)
;
; Display widget
widget_control,astrom_wid,/realize
xmanager,'ww_volvoxsolve',astrom_wid,/no_block
;
end
