pro ww_write,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Dispatch for Write(ACCESS) button.
;
common Hds,path,hds_file_stub
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if checkdata([1,5,6,7,8,9]) ne 0 then return
;
widget_control,event.id,get_value=command
;
if strlen(genconfig.configid) ne 0 $
	then configtag='_'+system_id(systemid)+'_'+genconfig.configid $
	else configtag=''
;
file_stub=genconfig.date+configtag	; as of April 10, 2017
;
if command eq 'OI-FITS' then begin
	put_oifits,file_stub
	return
endif
;
if command eq 'UV-FITS' then begin
	put_uvfits,file_stub
	return
endif
;
if command eq 'XDR' then begin
	put_xdr,file_stub
	return
endif
;
; Close current file
hds_close
;
filename=hds_file_stub+'.cha'
result=findfile(filename,count=fcount)
; unix_command='ls '+filename+'; echo $status'
; spawn,unix_command,result	; result(0)=0 if file found
print,'Open file '+filename
if fcount ne 0 then hds_open,filename,'UPDATE',status else $
	hds_new,filename,'DataSet','CHAMELEON',status
if status ne 0 then begin
	print,'***Error(WW_WRITE): file problem!'
	clearstatus
	return
endif
;
case command of
	'GeoParms' :put_geoparms
	'GenConfig':put_genconfig
	'ObsLog'   :put_observerlog
	'ConLog'   :put_constrictorlog
	'Scans'    :put_scans
	'HDS'	   :begin
		    put_scanlog
		    put_observerlog
		    put_constrictorlog
		    put_sysconfig
		    put_scans
		    end
endcase
hds_close
;
end
