pro xyimage,lambda=lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Display image of model by Fourier transforming uv-plane visibility.
; Image is monochromatic, given lambda.
;
if n_elements(lambda) eq 0 then lambda=0.55e-6
uvimage,lambda=lambda
restore
;
; image=dft(pearlimage(129,0.2),cmap,u,v)
;
r=size(cvf)
imsize=[r[1],r[2]]
; for i=0,r(2)-1 do cvf(*,i)=reverse(cvf(*,i))
; for i=0,r(1)-1 do cvf(i,*)=reverse(cvf(i,*))
image=shift(float(fft(shift(cvf,imsize[0]/2,imsize[1]/2),1)), $
	imsize[0]/2,imsize[1]/2)
for i=0,r[2]-1 do image[*,i]=reverse(image[*,i])
for i=0,r[1]-1 do image[i,*]=reverse(image[i,*],2)
;
loadct,0
tvscl,(image > 0)^(1/4.)
writefits,'xyimage.fits',image
;
save,cvf,u,v,image
end
