function zenithangle,hourangle,declination
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Returns zenith angle in degrees. Input HA is in hours, DEC in degrees.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
rad=180/pi_circle
dec=declination/rad
ha=hourangle*(15/rad)
longitude=polarmotion(-geoparms.longitude/15,latitude)
za=(rad*acos(sin(dec)*sin(Latitude/rad) $
  	        +cos(dec)*cos(Latitude/rad)*cos(ha)))
if n_elements(za) eq 1 then return,za[0] else return,za
;
end
