; This startup script compiles and saves the backup(!) OYSTER procedure and 
; function library
; Use: idl c
;
; List common blocks to be visible at the MAIN level
common OysterBridge,obd
common Starbase,StarTable,Notes
common Tables,scantable,bgtable,stationtable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
common PacketData,pd_all,var_num,packet
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
common MetroData,fbairtemp,fbsolidtmp
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
	ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SeeingData,scintillation,r0,t0,delayrms,phaserms,delayjitter2,natjitter2
common AuxData,parallaxes,k1,k2,vsini
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
;
common MidiObservation,obht_midi,acqindex,obsindex,phoindex,detwin
common AmberObservation,obht_amber,skyindex,darkindex,objindex,p2vmindex
common GravityObservation,obht_gravity,objindex_gravity
common MatisseObservation,obht_matisse,objindex_matisse
;
; Generally, compile functions first, then procedures
; compile_opt idl2
;
; OYSTER functions
.run idlfunctions.pro
.run ../backups/common/filter.pro
.run ../backups/common/functions.pro
.run ../backups/common/time.pro
.run ../backups/common/structure.pro
.run ../backups/common/oyster.pro
.run ../backups/common/cobra.pro
;
.run ../backups/common/atmospheres.pro
.run ../backups/common/beam.pro
.run ../backups/common/pearl.pro
.run ../backups/common/model.pro
.run ../backups/common/astrometry.pro
;
.run ../backups/common/lists.pro
.run ../backups/common/stars.pro
.run ../backups/common/starbase.pro
.run ../backups/common/starplot.pro
;
.run ../backups/common/hds.pro
.run ../backups/common/access.pro
.run ../backups/common/plotting.pro
.run ../backups/common/chameleon.pro
.run ../backups/common/starwheel.pro
;
.run ../backups/common/math.pro
.run ../backups/common/fitting.pro
.run ../backups/common/ameeba.pro
.run ../backups/common/roche.pro
;
.run ../backups/idl/plotwidget.pro
.run ../backups/idl/plotastro.pro
.run ../backups/idl/fitwidget.pro
.run ../backups/idl/cobrawidget.pro
.run ../backups/idl/mainwidget.pro
;
; Save main level common block definitions and compiled procedures and functions
version_origin=systime()+ ' by '+getenv('USER') $
	+' (compatible to IDL V4 or lower)'
save,filename='../../oyster.ver',version_origin
save,filename='../../oyster.var',/system_variables
save,filename='../../oyster.cpr',/routines
save,filename='../../oyster.cmb',/comm
;
exit
