; This startup script compiles and saves the OYSTER procedure and 
; function library. It includes the tellrem package.
; Use: idl c
;
; List common blocks to be visible at the MAIN level
common OysterBridge,obd
common Starbase,StarTable,Notes
common Tables,scantable,bgtable,stationtable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
common PacketData,pd_all,var_num,packet
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
common MetroData,fbairtemp,fbsolidtmp
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
	ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SeeingData,scintillation,r0,t0,delayrms,phaserms,delayjitter2,natjitter2
common AuxData,parallaxes,k1,k2,vsini
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
;
common MidiObservation,obht_midi,acqindex,obsindex,phoindex,detwin
common AmberObservation,obht_amber,skyindex,darkindex,objindex,p2vmindex
common GravityObservation,obht_gravity,objindex_gravity
common MatisseObservation,obht_matisse,objindex_matisse
;
; Generally, compile functions first, then procedures
; compile_opt idl2
;
; OYSTER functions
.run idlfunctions.pro
.run ../common/filter.pro
.run ../common/functions.pro
.run ../common/time.pro
.run ../common/structure.pro
.run ../common/oyster.pro
.run ../common/cobra.pro
;
.run ../common/atmospheres.pro
.run ../common/beam.pro
.run ../common/pearl.pro
.run ../common/model.pro
.run ../common/astrometry.pro
;
.run ../common/lists.pro
.run ../common/stars.pro
.run ../common/starbase.pro
.run ../common/starplot.pro
;
.run ../common/hds.pro
.run ../common/access.pro
.run ../common/plotting.pro
.run ../common/chameleon.pro
.run ../common/starwheel.pro
;
.run ../common/math.pro
.run ../common/fitting.pro
.run ../common/ameeba.pro
.run ../common/roche.pro
;
.run plotwidget.pro
.run plotastro.pro
.run fitwidget.pro
.run cobrawidget.pro
.run mainwidget.pro
;
; tellrem
cd,'/home/chummel/oyster/source/idlastro/pro'
.run idlastro_lib.pro
.run idlastro_lib.pro
cd,'/home/chummel/oyster/source/mpfit'
.run mpfit_lib.pro
.run mpfit_lib.pro
cd,'/home/chummel/oyster/source/proprietary/tellrem/routines'
.run tellrem_lib.pro
.run tellrem_lib.pro
cd,'/home/chummel/oyster/source'
;
; Save main level common block definitions and compiled procedures and functions
; Next block from c.pro added also here in 2025, original verion is ct_2019.pro
version_origin=systime()+ ' by '+getenv('USER') $
	+' (compatible to IDL V4 or lower)'
save,filename='../../oyster.ver',version_origin
save,filename='../../oyster.var',/system_variables
save,filename='../../oyster.cpr',/routines
save,filename='../../oyster.cmb',/comm
;
; tellrem addition
save,filename='../../tellrem.cpr',/routines
;
exit
