; This startup script compiles and saves the OYSTER procedure and 
; function library. CV5 version.
; Use: idl cv5
;
; List common blocks to be visible at the MAIN level
common OysterBridge,obd
common Starbase,StarTable,Notes
common Tables,scantable,bgtable,stationtable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
common PacketData,pd_all,var_num,packet
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
common MetroData,fbairtemp,fbsolidtmp
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
	ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SeeingData,scintillation,r0,t0,delayrms,phaserms,delayjitter2,natjitter2
common AuxData,parallaxes,k1,k2,vsini
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
;
common MidiObservation,obht_midi,acqindex,obsindex,phoindex,detwin
common AmberObservation,obht_amber,skyindex,darkindex,objindex,p2vmindex
common GravityObservation,obht_gravity,objindex_gravity
common MatisseObservation,obht_matisse,objindex_matisse
;
; Generally, compile functions first, then procedures
; compile_opt idl2
;
; OYSTER functions
.run v5/idlfunctions.pro
.run ../common/v5/filter.pro
.run ../common/v5/functions.pro
.run ../common/v5/time.pro
.run ../common/v5/structure.pro
.run ../common/v5/oyster.pro
.run ../common/v5/cobra.pro
;
.run ../common/v5/atmospheres.pro
.run ../common/v5/beam.pro
.run ../common/v5/pearl.pro
.run ../common/v5/model.pro
.run ../common/v5/astrometry.pro
;
.run ../common/v5/starbase.pro
.run ../common/v5/lists.pro
.run ../common/v5/stars.pro
.run ../common/v5/starplot.pro
;
.run ../common/v5/hds.pro
.run ../common/v5/access.pro
.run ../common/v5/plotting.pro
.run ../common/v5/chameleon.pro
.run ../common/v5/starwheel.pro
;
.run ../common/v5/math.pro
.run ../common/v5/fitting.pro
.run ../common/v5/ameeba.pro
.run ../common/v5/roche.pro
;
.run v5/mainwidget.pro
.run v5/plotwidget.pro
.run v5/plotastro.pro
.run v5/fitwidget.pro
.run v5/cobrawidget.pro
;
; Save main level common block definitions and compiled procedures and functions
version_origin=systime()+ ' by '+getenv('USER') $
	+' (compatible to IDL V5 and higher)'
save,filename='../../oyster.ver',version_origin
save,filename='../../oyster.cpr',/routines
save,filename='../../oyster.cmb',/comm
;
exit
