;-------------------------------------------------------------------------------
pro split
;
; Split IDL code containers into files, one for each function or procedure.
;
files=file_search('*.pro')
;
lines=''
;
for n=0,n_elements(files)-1 do begin
;
status=dc_read_fixed(files[n],lines,/col,format='(a80)')
lines=lines(where(strlen(strcompress(lines,/remove_all)) gt 0))
l=n_elements(lines)
i=0L
; Do not split these files
; if files[n] eq 'c.pro' then i=l	; Do not split c.pro
;
while i lt l-1 do begin
repeat begin
divider1=strpos(lines(i),';****')
divider2=strpos(lines(i),';----')
proname1=strpos(strupcase(lines(i+1)),'PRO')
proname2=strpos(strupcase(lines(i+1)),'FUNCTION')
comment=strpos(strmid(lines(i+1),0,1),';')
i=i+1
start_code=(divider1 ge 0 or divider2 ge 0) $
	and (proname1 ge 0 or proname2 ge 0) $
	and (comment lt 0)
endrep until start_code or i eq l-1
;
words=nameparse(lines(i),',')
words=nameparse(words(0))
openw,unit,strlowcase(words(1))+'.pro',/get_lun
;
repeat begin
printf,unit,strtrim(lines(i))
if start_code then begin
	dpos=strpos(lines(i),'$')
	if dpos(0) lt 0 then begin
		printf,unit,'COMPILE_OPT STRICTARR,STRICTARRSUBS'
		start_code=0
	endif
endif
i=i+1
divider1=strpos(lines(i),';****')
divider2=strpos(lines(i),';----')
end_code=(divider1 ge 0 or divider2 ge 0)
endrep until end_code or i eq l-1
free_lun,unit
;
endwhile
;
endfor
;
end
