;*******************************************************************************
; File: cobrawidget.pro
;
; Description:
; ------------
; Widget procedures for NPOI raw data access (except HDS) and analysis.
;
; Block directory:
; ----------------
; Block 1: window_slide,plot_slide,display_frames,
;	   fringemovie,fringemovie_event,fringeframes,fringeframes_event
; Block 2: packetlist,packetlist_event,starlist_event,scanlist_event
;
;************************************************************************Block 1
pro window_slide,xsize=xsize,ysize=ysize,xv=xv,yv=yv,index=index,wid=wid
;
; Open a plot window with sliders.
;
if not keyword_set(xsize) then xsize=640*2
if not keyword_set(ysize) then ysize=512
;
if n_elements(yv) eq 0 then begin
	if ysize gt 512 then yv=512 else yv=ysize
endif
if n_elements(xv) eq 0 then begin
	if xsize gt 640 then xv=640 else xv=xsize
endif
;
slide_image,show_full=0,slide_window=index,xsize=xsize,ysize=ysize, $
	xvisible=xv,yvisible=yv,block=0,top_id=wid,/register
;
!x.ticks=min([xsize/500,50])
!y.ticks=0
!y.ticklen=10./xsize
!x.style=1
!y.style=1
!p.multi=0
!x.margin=[12,3]
;
wset,index
;
end
;-------------------------------------------------------------------------------
pro plot_slide,xvector,yarray,labels,x2vector=x2vector,y2array=y2array,wid=wid
;
; Plots y(*,i) vs x(*), with i selected using a widget.
;
common PlotSlideLocal,x,y,x2,y2,do2,plabels,d_wid
;
count=n_elements(yarray[0,*])
;
x=xvector
y=yarray
if n_elements(labels) eq 0 then labels=sindgen(count)
plabels=labels
if n_elements(y2array) gt 0 then begin
	if n_elements(x2vector) eq 0 then x2=x $
				     else x2=x2vector
	y2=y2array
	do2=1
endif else do2=0
;
base_wid=widget_base(/column) & wid=base_wid
d_wid=widget_draw(base_wid,notify_realize='plotslide_event', $
	event_pro='plotslide_event', $
	scr_xsize=600,scr_ysize=200)
i_wid=cw_fslider(base_wid,minimum=1,maximum=count,value=1,/drag, $
	title='Index I',xsize=600,format='(i0)',uvalue='i')
j_wid=cw_fslider(base_wid,minimum=0,maximum=100,value=0,/drag, $
	title='Index J',xsize=600,format='(i0)',uvalue='j')
widget_control,base_wid,/realize
xmanager,'plot_slide',base_wid,/no_block,event_handler='plotslide_event'
;
end
;-------------------------------------------------------------------------------
pro plotslide_event,event
;
common PlotSlideLocal,x,y,x2,y2,do2,plabels,d_wid
common PlotslideEventLocal,i,j,index0
;
result=size(event)
if result[n_elements(result)-2] ne 8 then begin
	value=1
	i=1
	j=0
endif else begin
	widget_control,event.id,get_uvalue=slider,get_value=value
	case slider of
		'i':i=long(value)
		'j':j=long(value)
	endcase
endelse
;
index=i+j-1
if n_elements(index0) eq 0 then index0=index-1
if index eq index0 then return else index0=index
if index ge n_elements(plabels) then return
yi=extrac(y,0,index,n_elements(y[*,0]),1)
; xi=extrac(x,0,index,n_elements(x(*,0)),1)
xi=x
widget_control,d_wid,get_value=id
wset,id
plot,xi,yi,title=plabels[index]
;
if do2 then oplot,x2,extrac(y2,0,index,n_elements(y2[*,0]),1),psym=0
;
end
;-------------------------------------------------------------------------------
pro display_frames,frames,labels
;
common PlotImagesLocal,images,ilabels,d_wid
;
images=frames
for j=0,n_elements(frames[0,0,*])-1 do begin
	binsize=max(frames[*,*,j])/100
	binsize=max(frames)/100
	f=histogram(frames[*,*,j],min=0,binsize=binsize)
	tf=total(f)
	i=0
	tfi=0.
	repeat begin
		tfi=tfi+f[i]
		i=i+1
	endrep until tfi/tf gt 0.99
	images[*,*,j]=bytscl(frames[*,*,j],max=i*binsize)
endfor
images=frames	; Comment this line if you want to use the scaling from above
count=n_elements(images[0,0,*])
nx=n_elements(images[*,0,0])
ny=n_elements(images[0,*,0])
;
if n_elements(labels) eq 0 then labels=sindgen(count)
ilabels=labels
;
base_wid=widget_base(/column)
d_wid=widget_draw(base_wid,notify_realize='displayimages_event', $
	event_pro='displayimages_event', $
	scr_xsize=nx,scr_ysize=ny)
i_wid=cw_fslider(base_wid,minimum=1,maximum=count>2,value=1,/drag, $
	title='Index I',xsize=nx,format='(i0)',uvalue='i')
j_wid=cw_fslider(base_wid,minimum=0,maximum=100,value=0,/drag, $
	title='Index J',xsize=nx,format='(i0)',uvalue='j')
widget_control,base_wid,/realize
xmanager,'display_frames',base_wid,/no_block,event_handler='displayimages_event'
;
end
;-------------------------------------------------------------------------------
pro displayimages_event,event
;
common PlotImagesLocal,images,ilabels,d_wid
common PlotImagesEventLocal,i,j
;
result=size(event)
if result[n_elements(result)-2] ne 8 then begin
	value=1
	i=1
	j=0
endif else begin
	widget_control,event.id,get_uvalue=slider,get_value=value
	case slider of
		'i':i=long(value)
		'j':j=long(value)
	endcase
endelse
;
index=i+j-1
if index ge n_elements(ilabels) then return
image=images[*,*,index]
ni=n_elements(image[*,0])
nj=n_elements(image[0,*])
;
; nx=256
; x=float(indgen(nx)/(float(nx)/ni))
; ny=256
; y=float(indgen(ny)/(float(ny)/nj))
;
widget_control,d_wid,get_value=id
wset,id
; tv,bytscl(interpolate(float((image)),x,y,/grid))
tvscl,image
;tv,image
;
; xyouts,1,1,ilabels(index),color=100,/device
;
end
;-------------------------------------------------------------------------------
pro fringemovie,bincounts
;
; Run an animation using the frames in bincounts. Bincounts, according to
; standard COBRA format, must have three dimensions, i.e. number of bins,
; channels, and frames.
;
r=size(bincounts)
n_img=r[n_elements(r)-3]
n_chn=r[n_elements(r)-4]
n_bin=r[n_elements(r)-5]
if r[0] eq 3 then b=reform(bincounts,1,n_bin,n_chn,n_img) $
	     else b=bincounts
n_spc=n_elements(b[*,0,0,0])
;
nx=64
ny=64
;
base=widget_base(title='NPOI fringes')
animate=cw_animate(base,nx,ny*n_spc,n_img)
widget_control,/realize,base
;
;x=float((findgen(nx)/nx*n_bin))
;y=float((findgen(ny)/ny*n_chn))
x=float(long(findgen(nx)/nx*n_bin))
y=float(long(findgen(ny)/ny*n_chn))
;
; for k=0,n_spc-1 do b(k,*,*,*)=bytscl(b(k,*,*,*))
;
w=50
for i=0,n_img-1 do begin
	image=bytarr(n_spc*nx,ny)
;	for k=0,n_spc-1 do image(k*nx:(k+1)*nx-1,*) $
;			=bytscl(interpolate(reform(b(k,*,*,i)),x,y,/grid))
;	for k=0,n_spc-1 do image(k*nx:(k+1)*nx-1,*) $
;			=hist_equal(interpolate(reform(b(k,*,*,i)),x,y,/grid))
	for k=0,n_spc-1 do image[k*nx:(k+1)*nx-1,*] $
			=byte(interpolate(reform(b[k,*,*,i]),x,y,/grid) $
				*ravg1(255./max(b[k,*,*,i]),w))
	cw_animate_load,animate,frame=i, $
		image=transpose(image)
endfor
;
cw_animate_getp,animate,pixmap_vect
cw_animate_run,animate
xmanager,'fringemovie',base,event_handler='fringemovie_event'
;
end
;-------------------------------------------------------------------------------
pro fringemovie_event,event
;
widget_control,/destroy,event.top
;
end
;-------------------------------------------------------------------------------
pro fringegif,bincounts
;
; Run an animation using the frames in bincounts. Bincounts, according to
; standard COBRA format, must have three dimensions, i.e. number of bins,
; channels, and frames.
;
r=size(bincounts)
n_img=r[n_elements(r)-3]
n_chn=r[n_elements(r)-4]
n_bin=r[n_elements(r)-5]
if r[0] eq 3 then b=reform(bincounts,1,n_bin,n_chn,n_img) $
	     else b=bincounts
n_spc=n_elements(b[*,0,0,0])
;
nx=64
ny=64
;
x=float(long(findgen(nx)/nx*n_bin))
y=float(long(findgen(ny)/ny*n_chn))
;
w=50
loadct,0
for i=0,n_img-1 do begin
	image=bytarr(n_spc*nx,ny)
	for k=0,n_spc-1 do image[k*nx:(k+1)*nx-1,*] $
			=byte(interpolate(reform(b[k,*,*,i]),x,y,/grid) $
				*ravg1(255./max(b[k,*,*,i]),w))
	write_gif,'fringemovie.gif',transpose(image),/multiple
endfor
write_gif,'fringemovie.gif',/close
;
end
;-------------------------------------------------------------------------------
pro fringeframes
;
; Display a widget which lets one create and view fringe frames as a 
; function of tracking delay and air path.
;
common FringeFramesLocal,a,g,n,v,s,d_wid
;
loadct,0
;
base_wid=widget_base(/column)
d_wid=widget_draw(base_wid,notify_realize='fringeframes_event', $
	event_pro='fringeframes_event', $
	scr_xsize=192+192,scr_ysize=128)
a_wid=cw_fslider(base_wid,minimum=-30,maximum=30,value=0,/drag, $
	title='Differential air path [mm]', $
	uvalue='a',xsize=400)
g_wid=cw_fslider(base_wid,minimum=-10,maximum=10,value=0,/drag, $
	title='Tracking offset (FDL delay) [microns]', $
	uvalue='g',xsize=400)
s_wid=cw_fslider(base_wid,minimum=-50,maximum=50,value=0,/drag, $
	title='Glas mismatch [mu]', $
	uvalue='s',xsize=400)
v_wid=cw_fslider(base_wid,minimum=0.3,maximum=1.0,value=1,/drag, $
	title='Visibility amplitude', $
	uvalue='v',xsize=400)
n_wid=cw_fslider(base_wid,minimum=40,maximum=800,value=800,/drag, $
	title='Photonrate', $
	uvalue='n',xsize=400)
widget_control,base_wid,/realize
xmanager,'fringetrack',base_wid,/no_block,event_handler='fringeframes_event'
;
end
;-------------------------------------------------------------------------------
pro fringeframes_event,event
;
common FringeFramesLocal,a,g,n,v,s,d_wid
;
l=1/poly(findgen(32),[1.21678,0.034929])
r=poly_fit(l,edlen(l)-1,1)
;
nx=64
ny=64
;
result=size(event)
if result[n_elements(result)-2] ne 8 then begin
	a=0
	s=0
	g=0
	n=40
	v=1.0
endif else begin
	widget_control,event.id,get_uvalue=slider,get_value=value
	case slider of
		'a':a=value*1000
		's':s=value
		'g':g=value
		'v':v=value
		'n':n=fix(value/8)
	endcase
endelse
;
frame1=fringeframe(a,g,l,v,n,/poisson,glas=s)
n_bin=n_elements(frame1[*,0])
n_chn=n_elements(frame1[0,*])
x=float(long(findgen(nx)/nx*n_bin))
y=float(long(findgen(ny)/ny*n_chn))
vis=fringevis(frame1)
d=gitter(121,-12.)
fp=visdft(vis,l,d)
gd=groupdelay(fp,l,d)
gp=cphase(visdft(vis,l,gd))
ds=phaseshift(g/1e6,l/1e6)*(avg(l)/(2*!pi))
;solve,visrotate(vis,l,gd),l/1e6,sol1,/plot
;solve,vis,l/1e6,sol1,/plot
solve,vis,l/1e6,sol1
;
!p.charsize=1.0
widget_control,d_wid,get_value=id
wset,id
;
; Display raw frame
tvscl,interpolate(shift(reform(frame1),n_bin/2,0),x,y,/grid)
tv,bytarr(64,64),0,64
xyouts,0,80,/device,'g ='+string(gd,format='(f5.2)')
xyouts,0,70,/device,'p ='+string(cphase(total(visrotate(vis,l,gd)))*180/!pi, $
	format='(f6.1)')
;
; Display rotated frame
frame2=rotateframe(frame1,l,gd[0])
tvscl,interpolate(shift(reform(frame2),4,0),x,y,/grid),64,0
tv,bytarr(64,64),64,64
xyouts,64,70,/device,'P ='+string(-ds/avg(l)*360,format='(f6.1)')
;
; Display dispersion corrected frame
;tvscl,interpolate(shift(reform(frame3),4,0),x,y,/grid),128,0
tv,bytarr(64,64),128,64
xyouts,128,90,/device,'n ='+string(fix(sol1[2]),format='(i6)')
xyouts,128,80,/device,'v ='+string(sol1[0],format='(f6.1)')
xyouts,128,70,/device,'D ='+string(g+sol1[0],format='(f6.1)')
;
tv,bytarr(64,64),192,64
xyouts,192,120,/device,'g = group delay [mu]'
xyouts,192,110,/device,'p = phase of tracked fringe [deg]'
xyouts,192,100,/device,'P = phase shift from FDL delay [deg]'
xyouts,192, 90,/device,'n = fringe ID'
xyouts,192, 80,/device,'v = vacuum delay [mu]'
xyouts,192, 70,/device,'D = geometric delay [mu] (=0)'
;
end
;-------------------------------------------------------------------------------
pro interferograms
;
common InterferogramsLocal,g,a,x,cw,bw,nw,i_wid
;
base_wid=widget_base(/column)
i_wid=widget_draw(base_wid,notify_realize='interferograms_event', $
	event_pro='interferograms_event', $
	scr_xsize=192+192,scr_ysize=128)
g_wid=cw_fslider(base_wid,minimum=-10,maximum=10,value=0,/drag, $
	title='Tracking offset (FDL delay) [microns]', $
	uvalue='g',xsize=400)
a_wid=cw_fslider(base_wid,minimum=-30,maximum=30,value=0,/drag, $
	title='Differential air path [mm]', $
	uvalue='a',xsize=400)
n_wid=cw_fslider(base_wid,minimum=40,maximum=800,value=200,/drag, $
	title='Bandwidth', $
	uvalue='w',xsize=400)
widget_control,base_wid,/realize
xmanager,'interferograms',base_wid,/no_block,event_handler='interferograms_event'
;
end
;-------------------------------------------------------------------------------
pro interferograms_event,event
;
common InterferogramsLocal,g,a,x,cw,bw,nw,i_wid
;
result=size(event)
if result[n_elements(result)-2] ne 8 then begin
	dmax=3e-6
	nmax=100
	x=(findgen(nmax)/(nmax-1)-0.5)*2*dmax
;
	cw=700e-9
	bw=200e-9
	nw=100
	l=(findgen(nw)/(nw-1)-0.5)*bw+cw
	g=0.
	a=0.
endif else begin
	widget_control,event.id,get_uvalue=slider,get_value=value
	value=value[0]
	case slider of
		'g':g=value*1e-6
		'a':a=value*1000
		'w':bw=value*1e-9
	endcase
endelse
;
l=(findgen(nw)/(nw-1)-0.5)*bw+cw
nu=2.99e8/l
arg=2*!pi*(x#(1/l))
;
n=n_elements(x)
for i=0,nw-1 do arg[*,i]=arg[*,i]+2*!pi*g/l[i]
for i=0,nw-1 do arg[*,i]=arg[*,i]+a*(edlen(l[i]/1e-6)-1)
;
; i=50
; j=1
; print,'Group delay=',((arg(i,j)-arg(i,j-1))/(nu(j)-nu(j-1)))/(2*!pi)*2.99e14
;
f=cos(arg)
;
plot,x,total(f,2)
;
end
;************************************************************************Block 2
pro packetlist,rawfilespec
;
common PacketData,pd_all,var_num,packet
common PacketWids,listscan_wid,listpack_wid
;
if n_elements(rawfilespec) eq 1 then rawfiles=findfile(rawfilespec) $
				else rawfiles=rawfilespec
index=where(strpos(rawfiles,'fringeData') ne -1 $
         or strpos(rawfiles,'alignData') ne -1,count)
if count eq 0 then begin
	print,'***Error(NAVIGATOR): no valid files!'
	return
endif
rawfiles=rawfiles[index]
base_wid=widget_base(/row,title=strmid(rawfilespec[0],0,9)+'* (packetlist)', $
	resource_name='oyster')
col1_wid=widget_base(base_wid,/col)
for i=0,n_elements(rawfiles)-1 do begin
	pd=packetdir(rawfiles[i])
	if i eq 0 then pd_all=pd else pd_all=[pd_all,pd]
	text_wid=widget_text(col1_wid,value=rawfiles[i])
	list_wid=widget_list(col1_wid,event_pro='packetlist_event', $
		value=packettype(pd.type),ysize=10)
	widget_control,list_wid,set_uvalue=pd
endfor
;
col2_wid=widget_base(base_wid,/col)
index=where(packettype(pd_all.type) eq 'SCAN_START_VERSION_1',count)
if count gt 0 then begin
	stars=strarr(count)
	for i=0,count-1 do begin
		p=readpacket(pd_all[index[i]])
		stars[i]=p.body.starid
	endfor
	liststar_wid=widget_list(col2_wid,event_pro='starlist_event', $
		value=unique(stars),uvalue=unique(stars),ysize=6,/multiple)
	listscan_wid=widget_list(col2_wid,event_pro='scanlist_event', $
		value=' ',ysize=10)
	listpack_wid=widget_list(col2_wid,event_pro='packetlist_event', $
		value=' ',ysize=10,xsize=max(strlen(packettype(pd_all.type)))+1)
	widget_control,listpack_wid,set_uvalue=pd
endif
widget_control,base_wid,/realize
xmanager,'packetlist',base_wid,/no_block
;
end
;-------------------------------------------------------------------------------
pro starlist_event,event
;
common PacketData,pd_all,var_num,packet
common PacketWids,listscan_wid,listpack_wid
;
widget_control,event.id,get_uvalue=stars
i=widget_info(event.id,/list_select)
if i[0] ge 0 then stars=stars[i] else stars=''
index=where(packettype(pd_all.type) eq 'SCAN_START_VERSION_1',count)
if count gt 0 then begin
	k=intarr(count)
	starids=strarr(count)
	for i=0,count-1 do begin
		p=readpacket(pd_all[index[i]])
		starids[i]=p.body.starid
		for j=0,n_elements(stars)-1 do $
			if p.body.starid eq stars[j] then k[i]=p.body.scanid
	endfor
	k_index=where(k ne 0,count)
	if count eq 0 then begin
		widget_control,listscan_wid,set_value=' '
		widget_control,listpack_wid,set_value=' '
		return
	endif
	scanids=k[k_index]
	starids=starids[k_index]
	times=pd_all[index[k_index]].time
	pd_tail=pd_all[where(pd_all.time gt max(times))]
	j=where(packettype(pd_tail.type) eq 'SCAN_START_VERSION_1',count)
	if count gt 0 then time1=pd_tail[j].time else time1=max(pd_tail.time)
	widget_control,listscan_wid, $
		set_value=string(scanids,format='(i3)') $
			 +' ('+strmid(hms(times/3600000.0),0,7)+') '+starids, $
		set_uvalue=[pd_all[index[k_index]].time]
	widget_control,listpack_wid, $
		set_value=' '
endif
;
end
;-------------------------------------------------------------------------------
pro scanlist_event,event
;
common PacketData,pd_all,var_num,packet
common PacketWids,listscan_wid,listpack_wid
;
widget_control,event.id,get_uvalue=times
index=where(pd_all.time ge times[event.index] $
        and pd_all.type ne '00020000'X,count)
if count gt 0 then begin
	pd_sel=pd_all[index]
	si=sort(pd_sel.time)
	pd_sel=pd_sel[si]
	index=where(packettype(pd_sel.type) eq 'SCAN_START_VERSION_1',count)
	if count gt 1 then pd_sel=pd_sel[0:index[1]-1]
	widget_control,listpack_wid, $
		set_value=packettype(pd_sel.type), $
		set_uvalue=pd_sel
endif
;
end
;-------------------------------------------------------------------------------
pro packetlist_event,event
;
; Callback procedure for when user clicks on a packet. Reads packet and 
; performs courtesy operations/storage.
;
common PacketData,pd_all,var_num,packet
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
widget_control,event.id,get_uvalue=pd
index=where(pd_all.time eq pd[event.index].time $
        and pd_all.type eq pd[event.index].type)
jndex=where(pd_all.file eq pd[event.index].file)
print,'Reading packet No. '+string(index-jndex[0]+1,format='(i5)') $
		+' in file '+pd[event.index].file
print,'Header time stamp is '+hms(pd[event.index].time/3600000.0)
packet=readpacket(pd[event.index])
;
case pd[event.index].type of
;		     FILE_HEADER
	'00000000'X: begin
		     print,'File date: ',packet.body.date
		     Date=packet.body.date
		     end
;		     SCAN_START_VERSION_1
	'000b0000'X: print,'Scan '+string(packet.body.scanid)+' Star: '+packet.body.starid
;		     FDL_POSITION
	'000e0001'X: begin
		     set_screen
		     if n_elements(genconfig) ne 0 then begin
			numsid=genconfig.numsid
		     	labels=genconfig.stationid
			delays=packet.body.laserpath[genconfig.delaylineid-1,*]
			if genconfig.refstation ge 1 then begin
			for i=0,numsid-1 do $
				if i ne genconfig.refstation-1 then $
				delays[i,*]=delays[i,*]-delays[genconfig.refstation-1,*]
			delays[genconfig.refstation-1,*]=0
			ytitle=' Delay'
			endif else ytitle=' Path'
		     endif else begin
			numsid=6
		     	labels=strarr(numsid)
			delays=packet.body.laserpath
			ytitle=' Path'
		     endelse
		     !p.multi=[0,1,numsid]
		     !p.charsize=2.0
		     !y.title=ytitle+' [mu]'
		     time=double(packet.body.timestamp)/3600000l
		     time0=hms(time[0]) & time=(time-time[0])*3600
		     !x.title='Time [s] - '+time0
		     for i=0,numsid-1 do $
			plot,time,polyres(time,delays[i,*],1)*1e6, $
			ymargin=[3,1],ytitle=labels[i]+!y.title,psym=3
		     end
;		     FRINGE_DATA_VERSION_1
;	'000c0001'X: fringemovie,packet.body.bincounts
	'000c0001'X: begin
		     numout=3
		     if n_elements(genconfig) ne 0 then numout=genconfig.numoutbeam
		     !p.multi=[0,1,numout]
		     for i=0,numout-1 do fringespectrum,packet.body.bincounts[i,*,[0,1,2,3,4],*]
		     end
;		     FRINGE_BG
;	'000c0004'X: fringemovie,packet.body.bincounts
	'000c0004'X: begin
		     numout=2
		     if n_elements(genconfig) ne 0 then numout=genconfig.numoutbeam
		     !p.multi=[0,1,numout]
		     for i=0,numout-1 do fringespectrum,packet.body.bincounts[i,*,0,*]
		     end
;		     FRINGE_DARK
	'000c0005'X: print,packet.body.rate
;		     NAT_COUNTS
	'000d0001'X: begin
		     plot_benhist,counts=float(packet.body.quadcounts)
		     print,'Mean fluxes:'
		     print,natmfluxes(packet.body.quadcounts)
		     end
;		     SYS_CONFIG
	'000a0000'X: begin
		     geoparms=packet.body.geoparms
		     genconfig=packet.body.genconfig
		     systemid=packet.body.systemid
		     list_summary_chameleon
		     end
	else:
endcase
;
end
;-------------------------------------------------------------------------------
