pro photscale,calstar,scistar,template=template,noplot=noplot
;
; Given a calibrator, obtain information on absolute infrared fluxes and
; combine with measured spectra to derive scaling factor which convert
; counts into fluxes in Jansky.
;
; e.g. photscale,'HDN107446','USR0001',template='hd163588_K2III.tem'
;
common StarBase,StarTable,Notes
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(noplot) eq 0 then noplot=0
;
; Get 12 micron fluxes, i.e. color-corrected IRAS fluxes
get_f12
;
; Get template fluxes
f=cohen(calstar,l,template=template)	; W/cm^2/micron, lambda [m]
; hnu=6.63e-27*3e8/l 	; This is the energy (ergs) of a photon of lambda
; f=f*hnu*1e-4		; W/cm^2/micron
nl=n_elements(l)
index=where(l(1:nl-1)-l(0:nl-2) gt 0)
index=[0,index+1]	; remove duplicates
l=l(index)
f=f(index)
; Get transmission function of IRAS filter
t_iras=iras_f12(l*1e9)
f_iras=total(f*t_iras)/total(t_iras)
l_iras=total(l*t_iras)/total(t_iras)
f_iras=f_iras*(l_iras*1e6)^2/3e-16	; convert to Jy
; Compute IRAS flux of template
print,'Predicted IRAS flux for template [Jy]: ',f_iras
; Convert W/cm^2/micron to Jy
f=f*(l*1e6)^2/3e-16	; Jy
lambda=genconfig.wavelength(0:genconfig.numspecchan(0)-1,0)
; Interpolate template fluxes for spectrometer
fluxes=spline(l,f,reverse(lambda))
fluxes=reverse(fluxes)
index=where(genconfig.wavelength(0:genconfig.numspecchan(0)-1,0) gt 11.5e-6 $
        and genconfig.wavelength(0:genconfig.numspecchan(0)-1,0) lt 12.5e-6)
i=where(startable.starid eq calstar)
; print,'12 micron flux for template [Jy]: ',avg(fluxes(index))
print,'IRAS flux for calibrator [Jy]: ',startable(i).f12*1.4
f12tem=f_iras
; Normalize template to calibrator flux using the ratio of IRAS fluxes
fluxes=fluxes/f12tem*(startable(i).f12*1.4)
;
; Initialize scale factors with airmass correction
for i=0,n_elements(scans)-1 do $
        scans(i).photometryscale=1./cos(scans(i).za/(180/!pi))
;
index=where(scans.starid eq calstar,count)
counts=(scans(index).photometry*scans(index).photometryscale) > 0
;
for k=0,genconfig.numsid-1 do begin
for l=0,genconfig.numoutbeam-1 do begin
for j=0,genconfig.numspecchan(l)-1 do begin
index=where(counts(k,l,j,*) ne 0,count)
scale=0
scale_err=0
if count gt 1 then begin
	mcount=mean(counts(k,l,j,index))
	ecount=stddev(counts(k,l,j,index))
	scale=fluxes(j)/mcount
	scale_err=scale*(ecount/mcount)
endif else if count eq 1 then begin
	mcount=mean(counts(k,l,j,index))
	scale=fluxes(j)/mcount
endif
for i=0,n_elements(scans)-1 do begin
        scans(i).photometryscale(k,l,j)=scans(i).photometryscale(k,l,j)*scale
        if scans(i).starid eq calstar then scans(i).photometryerr(k,l,j)=scale_err
endfor
endfor
endfor
endfor
;
; Some diagnostic plotting...
;
; Conversion factor, converts counts into fluxes
if not noplot then begin
index=where(scans.starid eq calstar,count)
f=scans(index).photometryscale
l=genconfig.wavelength(*,0)*1e6
!p.multi=[0,2,2]
!y.title='Conversion factor'
!x.title='Wavelength ['+greek('mu')+'m]'
!y.range=[0,0.2]
if strmid(genconfig.stationid(0),0,2) eq 'UT' then !y.range=[0,0.002]
if !d.name ne 'PS' then window,/free else device,/color
for k=0,1 do begin
for j=0,1 do begin
	!p.title=calstar+' (IB '+string(k+1,format='(i1)') $
			+', OB '+string(j+1,format='(i1)')+')'
	plot,lambda*1e6,lambda*0,/nodata,xrange=[8,13]
	for i=0,count-1 do begin
		x=l
		y=reform(f(k,j,*,i))
		oplot,x,y,color=tci(3)
	endfor
endfor
endfor
endif
;
; Calibrator
if not noplot then begin
index=where(scans.starid eq calstar,count)
f=scans(index).photometry*scans(index).photometryscale
e=scans(index).photometryerr
l=genconfig.wavelength(*,0)*1e6
!p.multi=[0,2,2]
!y.title='F!D'+greek('nu')+'!N [Jy]'
!x.title='Wavelength ['+greek('mu')+'m]'
!y.range=0
if !d.name ne 'PS' then window,/free else device,/color
for k=0,1 do begin
for j=0,1 do begin
	!p.title=calstar+' (IB '+string(k+1,format='(i1)') $
			+', OB '+string(j+1,format='(i1)')+')'
	plot,lambda*1e6,fluxes,psym=0,xrange=[8,13],thick=3
	for i=0,count-1 do begin
		x=l
		y=reform(f(k,j,*,i))
		z=reform(e(k,j,*,i))
		jndex=where(y gt 0 and z gt 0,n)
		if n gt 0 then oplot,x(jndex),y(jndex),color=tci(3)
; if n gt 0 and k eq 1 and y(15) lt 15 then print,k,j,index(i)
; if n gt 0 and k eq 1 and y(15) lt 15 then oplot,x(jndex),y(jndex),color=tci(2)
; if n gt 0 and k eq 1 and y(15) lt 15 then scans(index(i)).photometry(k,j,*)=-1
	endfor
endfor
endfor
endif
;
; Science target
if n_elements(scistar) eq 1 then begin
index=where(scans.starid eq scistar,count)
f=scans(index).photometry*scans(index).photometryscale
e=scans(index).photometryerr
l=genconfig.wavelength(*,0)*1e6
lambda=l(where(l gt 7 and l lt 13)) & si=sort(lambda) & lambda=lambda(si)
fluxjy=lambda*0
fluxsq=fluxjy
numspectra=0
!p.multi=0
!x.range=[7.5,13]
!p.title=scistar
!p.title=''
!p.thick=2
!p.charsize=2
if !d.name ne 'PS' then window,/free else device,/color
for k=0,1 do begin
for j=0,1 do begin
	for i=0,count-1 do begin
		x=l
		y=reform(f(k,j,*,i))
		z=reform(e(k,j,*,i))
		index=where(y gt 0 and z gt 0,n)
		x=x(index)
		y=y(index)
		si=sort(x) & x=x(si) & y=y(si)
		if n gt 0 then begin
			if numspectra eq 0 then begin
				index=where(x gt 7 and x lt 13)
				plot,x,y,/nodata, $
				yrange=[min(y(index))*0,max(y(index))*1.2]
			endif
;			oplot,x,y,color=tci(3),psym=0
			fluxkj=spline(x,y,lambda)
			fluxjy=fluxjy+fluxkj
			fluxsq=fluxsq+fluxkj^2
			numspectra=numspectra+1
		endif
	endfor
endfor
endfor
fluxjy=fluxjy/numspectra
fluxsq=fluxsq/numspectra
oplot,lambda,fluxjy
fluxsg=sqrt(fluxsq-fluxjy^2)
oploterr,lambda,fluxjy,fluxsg,3
; xyouts,12.4,22.5,'[NeII]',charsize=1.5
openw,unit,scistar+'.txt',/get_lun
for i=0,n_elements(lambda)-1 do printf,unit,lambda(i),fluxjy(i),fluxsg(i)
free_lun,unit
endif
;
if !d.name ne 'PS' then set_screen else device,/close
;
end
;-------------------------------------------------------------------------------
