;
; Copyright 2005, 2006 University of Leiden.
;
; This file is part of MIA+EWS.
;
; MIA+EWS is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; MIA+EWS is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with MIA; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
pro convertEso,infile, outfile, ierr
indet = OBJ_NEW('imagedetector', infile, ierr=ierr)
if (ierr NE 0) then begin
   ewsprinterrmsg
   RETURN
endif
indet->close
inDetTable = *(indet->table())
nRegion = indet->nRegion()
outDet = OBJ_NEW('imagedetector', nRegion, maxCoeff = indet->maxCoeff())
*(outDet->table()) = inDetTable
indata = OBJ_NEW('imagedata', infile, ierr=ierr)
if (ierr NE 0) then begin
   ewsprinterrmsg
   RETURN
endif
inrow = indata->readrows(1)
intype = size(inrow.data1,/type)
if (intype eq 2) then begin
   outrow = outDet->datatemplate(/int)
   outData = OBJ_NEW('imagedata', outDet, /int)
endif else if (intype eq 3) then begin
   outrow = outDet->datatemplate(/long)
   outData = OBJ_NEW('imagedata', outDet, /long)
endif else if (intype eq 4) then begin
   outrow = outDet->datatemplate(/float)
   outData = OBJ_NEW('imagedata', outDet, /float)
endif
inTags = TAG_NAMES(inrow)
outTags = TAG_NAMES(outrow)
intyp = WHERE(STRPOS(inTAGS, 'TARTYP') GE 0)
outtyp = WHERE(STRPOS(outTAGS, 'TARTYP') GE 0)
insou = WHERE(STRPOS(inTAGS, 'SOURCE') GE 0)
outtar = WHERE(STRPOS(outTAGS, 'TARGET') GE 0)
indatacol = WHERE(STRPOS(inTAGS, 'DATA') GE 0)
outdatacol = WHERE(STRPOS(outTAGS, 'DATA') GE 0)
ntags = N_ELEMENTS(inTags)-1

ndata = indata->naxis()
ndata = ndata[1]
outDet->newFile, outfile,/table
outData->appendtofile, outDet
for iRow = 1, ndata do begin
   inrow = inData->readrows(irow)
      outRow.Frame = inRow.Frame
      outRow.Time  = inRow.Time
      outRow.exptime = inrow.exp_time
      outRow.opt_train = inrow.opt_train
      outRow.ins_train[*] = 1
      outRow.reference = inrow.reference
      outrow.opd = inrow.opd
      outrow.localopd = inrow.localopd
      outrow.offset = inrow.offset
      outrow.rotation=inrow.rotation
      outrow.stepping_phase=inrow.stepping_phase
      for i=0, N_ELEMENTS(insou)-1 do outRow.(outtar[i]) = inRow.(insou[i])
      for i=0, N_ELEMENTS(inData) do outRow.(outDatacol[i]) = inRow.(inDataCol[i])
      for i=0, N_ELEMENTS(outtype) do begin
         if (inRow.(intyp[i]) EQ 3) then outRow.(outtyp[i]) = 'S ' $
         else if (inRow.(intyp[i]) EQ 4) then outRow.(outtyp[i]) = 'B ' $
         else outRow.(outtyp[i]) = 'T '
      endfor
   outData->writerows, outRow
endfor
indata->close
outdata->close
obj_destroy,indata
obj_destroy,outdata

RETURN
END
