;
; Copyright 2005, 2006 University of Leiden.
;
; This file is part of MIA+EWS.
;
; MIA+EWS is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; MIA+EWS is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with MIA; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;********************************************************
;#class#
;oirWavelength
;#description#
;deal with Wavelength Tables
;#end_class#
;*******************************************************

PRO oi_Wavelength__DEFINE
;********************************************************
;#structure#
; wavelength
;#inheritance#
; fitsTable
;#description#
; Internal variables for wavelength Object
;#structure_text#
oir7={oi_wavelength, $; #class members#
INHERITS FITSTABLE, $;  #class inheritance#
revision:1,    $ int & revision number
INSNAME:STRING(REPLICATE(32B,16)), $ ;str & instrument/disperser e.g. 'MIDI/PRISM'
nWave:1  $ ;  int &number of wavelengths specified
}
;#end_structure#
;********************************************************

;********************************************************
;#structure#
; oi_Wavelength
;#inheritance#
; NONE
;#description#
;variables per row of oi_Wavelength Table
;#structure_text#
oir8={oi_wavelengthStruct, $ ; #FITS TABLE structure#
EFF_WAVE:0.0, $ ; effective wavelength (meters)
EFF_BAND:0.0 $ ; effective bandwidth (meters)
}
;#end_structure#
;********************************************************
END

FUNCTION oi_wavelength::init, input, iErr=iErr, insName=insName, $
   waves=waves, band=band
;construct a array geometry table object
;
;   input  poly
;
;   (1) a string, assumed to be a file name.  Open the
;       file and get the source table there
;   (2) a FITSFILE object;  read down the file and
;       get source table
;   (3) a (subclass of) a FITSEXTENSION object
;       grab the fitsfile object and treat as (3)
;
;establish error handler
   cErr = 0
   catch, cErr
   if (cErr NE 0) then begin
;supress further handling at this level 
      catch, /cancel 
      midiCatchError
      iErr = 1
RETURN,0
   endif         ; handle actual error
;determine input type
; no input: either dummy or waves+bands
   if(N_PARAMS() LE 0) then begin
      if (KEYWORD_SET(insname)) then self.insname = insname $
         else self.insname = 'UNKNOWN'
      if (N_ELEMENTS(waves) GT 0) then begin
         self.nWave = N_ELEMENTS(waves)
         self.Table = PTR_NEW(REPLICATE({oi_wavelengthStruct}, self.nWave))
         (*self.Table).eff_wave = waves
         if (N_ELEMENTS(band) EQ self.nWave) then (*self.Table).eff_band = band
      endif else self.nWave = 0
      if (0 eq self->FITSTABLE::init({oi_wavelengthStruct}, $
         extname='OI_WAVELENGTH', iErr=iErr)) then begin
            midiSetError, 'Wavelength Table Creation Failed',/notInitial
            RETURN,0
      (self.head)->addPar,'INSNAME', self.INSNAME
      (self.head)->addPar,'NWAVE', self.nWave
      endif
      RETURN, 1
   endif ; no input
   sInput = size(input)
   sInput = sInput[sInput[0]+1]
;    try string or object input
   if (sInput eq 7 or (sInput eq 11)) then begin 
;if string input save in temporary variable
      if (sInput eq 7) then tInput = input else begin
;if object input, test class and extract inFile if necessary
         inClass = OBJ_CLASS(input)
	 inClass = strTrim(inClass[0],2)
	 if (inClass EQ 'FITSFILE') then tInput = input else begin
;find highest order superclass
            sc = inClass
            while (sc NE '') do begin
               superClass = sc
               sc = OBJ_CLASS(sc,/super)
               sc = sc[0]
            endwhile
            superClass = superClass[0]
	    if (inClass EQ 'FITSEXTENSION' OR (superClass EQ 'FITSEXTENSION'))$
	       then tInput = input->file() else $
	       midiSetError, 'Source input object of unknown type'
         endelse        ; not a FITSFILE object
      endelse           ; not a string input
;call FITSTABLE constructor with string or FITSFILE input
      if (0 eq self->FITSTABLE::init(tInput, extName='OI_WAVELENGTH',$
         /table, iErr=iErr))  then $
         midiSetError, 'Source Table Creation from Disk Failed',/notInitial
      self.insname = (self.head)->getPar('INSNAME', matches)
      self.nWave   = (self.head)->getPar('NWAVE', matches)
   endif  else $           ; input from disk
      midiSetError, 'Source construction input of unknown type'
RETURN,1
END

PRO oi_wavelength::cleanup
   self->FitsTable::cleanup
RETURN
END

PRO oi_wavelength::set, waves=wave, band=band, insname=insname
;
   if (KEYWORD_SET(insname)) then begin
      self.insname = insname
      (self.head)->addPar,'INSNAME', self.INSNAME
   endif
   if (N_ELEMENTS(waves) GT 0) then begin
      self.nWave = N_ELEMENTS(waves)
      PTR_FREE,self.Table
      self.Table = PTR_NEW(REPLICATE({oi_wavelengthStruct}, self.nWave))
      (*self.Table).eff_wave = wave
      if (N_ELEMENTS(band) EQ self.nWave) then (*self.Table).eff_band = band
      (self.head)->addPar,'NWAVE', self.nWave
   endif
RETURN
END

;PRO oi_wavelength::newFile, fileName, iErr=iErr, priHead=priHead
;   self->fitsTable::newFile, fileName, /table, iErr=iErr, priHead=priHead
;RETURN
;END

;PRO oi_wavelength::appendToFile, input, iErr=iErr
;   self->fitsTable::appendToFile, input, /table, iErr=iErr
;RETURN
;END
