#include <stdio.h>
#include <stdlib.h>
#include "novas.h"

#define N_STARS 4
#define N_TIMES 2

int main (void)
{
/*
   Main function to check out many parts of NOVAS-C by calling
   function 'topo_star' with version 3 of function 'solarsystem'.

   For use with NOVAS-C 2.0
*/

   short int error = 0;
   short int i, j;

/*
   'deltat' is the difference in time scales, TT - UT1.

    The array 'tjd' contains four selected Julian dates at which the
    star positions will be evaluated.
*/

   double deltat = 65.003477;
   double tjd[N_TIMES] = {2453951.6, 2453951.7};
   double ra, dec;

/*
   FK5 catalog data for three selected stars.
*/

   cat_entry stars[N_STARS] = {
      {"HDN", "HD152786",   0, 16.977003, -55.990139, 
               -0.2000, -4.000,  0.0232, -6.0},
      {"HDN", "HD167618", 1, 18.293789, -36.761696,  
               -1.1000, -17.00,  0.0142,  1.0},
      {"HDN", "HD177716", 2, 19.115669, -27.670416,  
               -0.4000, -25.00,  0.0217,  45.0},
      {"HDN", "HD187076", 3, 19.789793,  18.534277, 
                0.0000,  1.000,  0.0043,  3.0}};

/*
   The observer's terrestrial coordinates (latitude, longitude, height).
*/

   site_info geo_loc = {-24.6258, -70.4032, 2635.0, 10.0, 1010.0};

/*
   A structure containing the body designation for Earth.
*/

   body earth;

/*
   Set up the structure containing the body designation for Earth.
*/

   if (error = set_body (0,3,"Earth", &earth))
   {
      printf ("Error %d from set_body.\n", error);
      exit (1);
   }

/*
   Compute the topocentric places of the three stars at the four
   selected Julian dates.
*/

   for (i = 0; i < N_TIMES; i++)
   {
      for (j = 0; j < N_STARS; j++)
      {
         if (error = topo_star (tjd[i],&earth,deltat,&stars[j],&geo_loc,
            &ra,&dec))
            printf ("Error %d from topo_star. Star %d  Time %d\n",
               error, j, i);
          else
         {
            printf ("JD = %f  Star = %s\n", tjd[i], stars[j].starname);
            printf ("RA = %12.9f  Dec = %12.8f\n", ra, dec);
            printf ("\n");
	    printf("%f %f\n",tjd[i],deltat);
	    printf("%f %f %f %f %f %f\n",stars[j].ra,stars[j].dec,stars[j].promora,stars[j].promodec,stars[j].parallax,stars[j].radialvelocity);
	    printf("%f %f %f %f %f\n",geo_loc.latitude,geo_loc.longitude,geo_loc.height,geo_loc.temperature,geo_loc.pressure);
         }
      }
      printf ("\n");
   }

   return (0);
}
