;
; Copyright 2005, 2006 University of Leiden.
;
; This file is part of MIA+EWS.
;
; MIA+EWS is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; MIA+EWS is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with MIA; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
PRO Delay__DEFINE
;********************************************************
;#structure#
; delay
;#inheritance#
; fitsTable
;#description#
; group delay estimates from dispersed observation
;#structure_text#
;define structures for source class
oir5={Delay,  $        ;#class members#
INHERITS FITSTABLE, $   ;#class inheritance#
revision:1 $           ;int & revision numbers
}
;#end_structure#
;********************************************************
;
;********************************************************
;#structure#
; delayStruct
;#inheritance#
; None
;#description#
; template for one row of source table
;#structure_text#
oir6={DelayStruct,  $  ;#FITS TABLE structure#
time:0.0d, $   ; dbl & time (days) of observation frame
telescope:0, $  ; int & delay of which telescope
delay:0.0d, $   ; dbl & estimated delay (sec)
amplitude:0.0 $   ; float & amplitude of delay function at peak
}
;#end_structure#
;********************************************************
END

FUNCTION delay::init, input, iErr=iErr
;construct a delay table object
;
;   input  poly
;   (1) if absent create a default, mostly empty source table.
;
;   (2) a string, assumed to be a file name.  Open the
;       file and get the delay table there
;   (3) a FITSFILE object;  read down the file and
;       get source table
;   (4) a (subclass of) a FITSEXTENSION object
;       grab the fitsfile object and treat as (3)
;
;establish error handler
   cErr = 0
   catch, cErr
   if (cErr NE 0) then begin
;supress further handling at this level 
      catch, /cancel 
      midiCatchError
      iErr = 1
RETURN,0
   endif         ; handle actual error
;determine input type
   if(N_PARAMS() GE 1) then begin
      sInput = size(input)
      sInput = sInput[sInput[0]+1]
   endif else begin
      sInput = 0
   endelse
;no input
   if (sInput EQ 0) then begin
      template = {delayStruct}
      self.table = PTR_NEW(template)
      if (0 eq self->FITSTABLE::init(template, $
         extname='DELAY', iErr=iErr)) then $
         midiSetError,'Delay Table Creation from Disk Failed',$
         /notInitial
;end of empty input, try string or object input
   endif else if (sInput eq 7 or (sInput eq 11)) then begin 
;if string input save in temporary variable
      if (sInput eq 7) then tInput = input else begin
;if object input, test class and extract inFile if necessary
         inClass = OBJ_CLASS(input)
	 inClass = strTrim(inClass[0],2)
	 if (inClass EQ 'FITSFILE') then tInput = input else begin
;find highest order superclass
            sc = inClass
            while (sc NE '') do begin
               superClass = sc
               sc = OBJ_CLASS(sc,/super)
               sc = sc[0]
            endwhile
            superClass = superClass[0]
	    if (inClass EQ 'FITSEXTENSION' OR (superClass EQ 'FITSEXTENSION'))$
	       then tInput = input->file() else $
	       midiSetError, 'Delay input object of unknown type'
         endelse        ; not a FITSFILE object
      endelse           ; not a string input
;call FITSTABLE constructor with string or FITSFILE input
      if (0 eq self->FITSTABLE::init(tInput, extName='DELAY',/table, $
         iErr=iErr)) then $
         midiSetError, 'Delay Table Creation from Disk Failed',/notInitial
   endif  else  midiSetError, 'Delay construction input of unknown type'
RETURN,1
END

PRO Delay::CLEANUP
PTR_FREE,self.table
RETURN
END

PRO DELAY::writeRows, input, startRow, iErr=iErr
;
;   specialization of fitstable::writerows for delay table
;   mostly makes sure structure formats are equivalent
   delaystruct = self->template()
   nRows = N_ELEMENTS(input)
   if (N_PARAMS() LT 2) then startRow = 1
   for i=0, nRows-1 do begin
      for j=0,3 do delaystruct.(j) = input[i].(j)
      self->FITSTABLE::writerows, delaystruct, startRow+i, iErr=iErr
      if (iErr NE 0) then midiSetError, 'delay:writerows failed',/notInitial
   endfor
RETURN
END
