;
; Copyright 2005, 2006 University of Leiden.
;
; This file is part of MIA+EWS.
;
; MIA+EWS is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; MIA+EWS is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with MIA; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
PRO opticalTrain__DEFINE
;********************************************************
;#structure#
; opticalTrain
;#inheritance#
; fitsTable
;#description#
;define structures for opticalTrain Class
;#structure_text#
oir9 = {opticalTrain, $ ;#class members#
INHERITS FITSTABLE,$    ;#class inheritance#
revision:1,        $    ;int & revision number
arrNam:'',         $  ; str & array name
dateObs:''        $  ; str & start date of obs. described by this table
}
;#end_structure#
;********************************************************
;********************************************************
;#structure#
; opticalTrainStruct
;#inheritance#
; NONE
;#description#
; template row for optical train table
;#structure_text#
oir10={opticalTrainStruct, $ ; #FITS TABLE structure#
index:0,          $ int &optical path index number
telescope:0,      $ int &telescope feeding this optical path (c.f. array geometry)
dly_line:0,       $ int &delay line feeding this path
lab_beam:0,       $ int &input channel selected
switchyard:STRING(REPLICATE(32b,16)) $str & selected option at lab switchyard
}
;#end_structure#
;********************************************************
END

FUNCTION opticalTrain::init, input, iErr=iErr, arrName=arrName, $
   dateObs=dateObs
;construct a source table object
;
;   input  poly
;   (1) if a number assume that this is number of rows
;       to in a  mostly empty source table.
;       if no input is not specified, nTrain = 2
;
;   (2) a string, assumed to be a file name.  Open the
;       file and get the source table there
;   (3) a FITSFILE object;  read down the file and
;       get source table
;   (4) a (subclass of) a FITSEXTENSION object
;       grab the fitsfile object and treat as (3)
;
;establish error handler
   cErr = 0
   catch, cErr
   if (cErr NE 0) then begin
;supress further handling at this level 
      catch, /cancel 
      midiCatchError
      iErr = 1
RETURN,0
   endif         ; handle actual error
;check keyword parameters
      if (NOT KEYWORD_SET(arrName)) then arrName = 'VLTI'
      self.arrNam = arrName
      if (NOT KEYWORD_SET(dateObs)) then dateObs = '    '
      self.dateObs = dateObs
;determine input type
   if(N_PARAMS() GE 1) then begin
      sInput = size(input)
      sInput = sInput[sInput[0]+1]
   endif else begin
      sInput = 2
      input  = 2
   endelse
;integer, thus input is the size of the opticalTrain table
   if (sInput ge 1 and (sInput le 3)) then begin
      nTrain = input
;add variable length pointers to fluxes etc.
      template = {OpticalTrainStruct}
;fill in blank character strings to set lengths
      template.switchyard=string(replicate(32B,16))
      self.table = PTR_NEW(replicate(template, nTrain))
;incarnate myself as a fits table
      if (0 eq self->FITSTABLE::init(template, $
         extname='OPTICAL_TRAIN', iErr=iErr)) then $
         midiSetError,'optical Train Table Creation from Disk Failed',$
	 /notInitial
;put keyword parameters into header
      (self.head)->addPar,'ARRNAM', self.arrNam
      (self.head)->addPar,'DATE_OBS', self.dateObs
;end of integer input, try string or object input
   endif else if (sInput eq 7 or (sInput eq 11)) then begin 
;if string input save in temporary variable
      if (sInput eq 7) then tInput = input else begin
;if object input, test class and extract inFile if necessary
         inClass = OBJ_CLASS(input)
	 inClass = strTrim(inClass[0],2)
	 if (inClass EQ 'FITSFILE') then tInput = input else begin
;find highest order superclass
            sc = inClass
            while (sc NE '') do begin
               superClass = sc
               sc = OBJ_CLASS(sc,/super)
               sc = sc[0]
            endwhile
            superClass = superClass[0]
	    if (inClass EQ 'FITSEXTENSION' OR (superClass EQ 'FITSEXTENSION'))$
	       then tInput = input->file() else $
	       midiSetError,'Source input object of unknown type'
         endelse        ; not a FITSFILE object
      endelse           ; not a string input
;call FITSTABLE constructor with string or FITSFILE input
      if (0 eq self->FITSTABLE::init(tInput, extName='OPTICAL_TRAIN',/table, $
         iErr=iErr)) then $
         midiSetError,'Optical Train Table Creation from Disk Failed',$
	 /notInitial
      self.arrNam = (self.head)->getPar('ARRNAM', matches)
      self.dateObs = (self.head)->getPar('DATE_OBS', matches)
   endif  else $; input from disk
      midiSetError,'optical train construction input of unknown type'
RETURN,1
END

PRO Source::CLEANUP
PTR_FREE,self.table
RETURN
END
