;*******************************************************************************
; File: myprimagui.pro
; Part of OYSTER (Christian Hummel)
;
; Block directory:
; ----------------
;
; Block 1: alloc_prima_options,
;	   badpixelmap,flatfieldmap,
;	   cleanprimaindex,cleanprimarawdir,
;	   analyzeprimaconfigids,primaconfigids,
;	   primarawdirchecksum,selectprimafiles,
;	   primaupdateconfig,primagenconfig,
;	   primastarids,primascan
; Block 2: amdlibp2vm,amdlibappendoidata,amdlibcomputeoidata,
;	   amdlibperformframeselection
; Block 3: primagui_event,primagui_configid,primagui_options,files_event,
;	   myprimagui,
;	   prima2p2vgui_event,prima2p2vgui,prima2p2vgui2_event,
;	   primap2vmfiles_event,primap2vmgui_event,primap2vmgui,
;	   primarecipes_event,primarecipesgui_event,primarecipesgui,
;	   primaobjectgui_event,primaobjectgui,
;	   primadefaultrecipes,primainitializepipe,myprimapipe,
;	   myprimapipe_merge,myprimavsop,
;	   calpiston,checkp2vm
;
;************************************************************************Block 1
function alloc_obht,n
;
obht_struc={filename:''}
return,replicate(obht_struc,n)
;
end
;-------------------------------------------------------------------------------
function alloc_prima_options
;
; Old versions:
; prima_options={piston:'PHASOR',errors:'THEORIC',frcrit:'FRG',frvalu:'2.0'}
;
nsel=3
return,{version:2, $
	short_config:0, $
	piston:'PHASE', $
	errors:'STATISTIC', $
	merges:'>', $
	selcrit:strarr(nsel)+'None', $
	seltype:strarr(nsel)+'Threshold', $
	selvalu:fltarr(nsel)+1.0}
;
end
;-------------------------------------------------------------------------------
function analyzeprimaconfigids
;
; Determine how many different configurations are present in the raw data
; of the working directory. Configurations are different for different
; baselines.
;
files=findfile('PACMA*.fits')
;
if strlen(files(0)) eq 0 then return,'No PACMA raw files'
;
n=n_elements(files)
configurations=strarr(n)
;
for i=0,n-1 do begin
;
	fitsfile=obj_new('fitsfile',files(i))
	prihead=fitsfile->prihead()
;
	insmode=strtrim(prihead->getpar('INS MODE'))
	dprtype=strtrim(prihead->getpar('DPR TYPE'))
;
	station_1=vlti_stationid(strtrim(prihead->getpar('ISS CONF STATION1')))
	station_2=vlti_stationid(strtrim(prihead->getpar('ISS CONF STATION2')))
;
	if strpos(dprtype,'OBJECT') ge 0 then $
	configurations(i)='PRIMA+'+station_1+'-'+station_2
;
	obj_destroy,fitsfile
;
endfor
;
index=where(strlen(configurations) ne 0,count)
if count gt 0 then configurations=unique(configurations(index)) $
	      else configurations='Any'
return,configurations
;
end
;-------------------------------------------------------------------------------
function primaconfigids,obht
;
; Return a unique set of configids currently loaded.
;
configid='PRIMA'
;
station_1=vlti_stationid(strtrim(obht.ISSCONFSTATION1,2))
station_2=vlti_stationid(strtrim(obht.ISSCONFSTATION2,2))
;
;
configurations=+configid+'+' $
 	+station_1+'-'+station_2
;
return,configurations
;
end
;-------------------------------------------------------------------------------
function primarawdirchecksum
;
; Returns a checksum of the MIDI files in the current directory.
;
f=findfile('PACMA*.fits')
n=n_elements(f)
if n eq 0 then return,0
r=file_info(f(0))
r=replicate(r,n)
for i=0,n-1 do r(i)=file_info(f(i))
;
return,strjoin(string(r.name)+string(r.ctime)+string(r.mtime)+string(r.size))
;
end
;************************************************************************Block 2
function mean_imaging_data,data
;
n=n_elements(data)
data1=total(data.data1(1:5,*),2)/n
data2=total(data.data2(1:5,*),2)/n
data3=total(data.data3(1:5,*),2)/n
data4=total(data.data4(1:5,*),2)/n
;
return,[[data1],[data2],[data3],[data4]]
;
end
;-------------------------------------------------------------------------------
pro fsuflat
;
common PrimaObservation,obht,skyindex,darkindex,objindex,p2vmindex
;
fbt=fbt_open(obht(0).filename)
fsua=fbt.IMAGING_DATA_FSUA->readrows()
fsub=fbt.IMAGING_DATA_FSUB->readrows()
fbt_close,fbt
;
fsua_dark=mean_imaging_data(fsua)
fsub_dark=mean_imaging_data(fsub)
;
fbt=fbt_open(obht(1).filename)
fsua=fbt.IMAGING_DATA_FSUA->readrows()
fsub=fbt.IMAGING_DATA_FSUB->readrows()
fbt_close,fbt
;
fsua_flat=mean_imaging_data(fsua)
fsub_flat=mean_imaging_data(fsub)
;
print,fsua_flat-fsua_dark
print,fsub_flat-fsub_dark
;
stop
;
end
;************************************************************************Block 3
function primagui_event,event
;
; This is the call back for buttons on the main MyPrimaGui.
;
common PrimaGuiWids,prima_wid,files_wid,window_slide_wid,pipeline_wid
common PrimaTaskWids,prima2p2v_wid,primaobject_wid,primap2vm_wid,primarecipes_wid
common PrimaPipeline,rawdir,rawdirchecksum,configid,recipes
common PrimaObservation,obht,skyindex,darkindex,objindex,p2vmindex
common PrimaOptions,prima_options,p2vmfile
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
widget_control,event.id,get_uvalue=dir
;
case event.value of
;
'Observation':	begin
;		Clean desktop a little
		wdall
		if widget_info(prima2p2v_wid,/valid) then widget_control,prima2p2v_wid,/destroy
		set_screen
		!x.range=0
		!y.range=0
		!p.psym=0
;
		files=pacmafs()
		obht=alloc_obht(n_elements(files))
		obht.filename=files
;
;		If a complete observation was selected, get additional info
		fitsfiles=obht.filename
		fitsfile=obj_new('fitsfile',fitsfiles(0))
		prihead=fitsfile->prihead()
		airmass=strtrim(prihead->getpar('ISS AIRM END'))
		seeing=strtrim(prihead->getpar('ISS AMBI FWHM'))
		dispersion=strtrim(prihead->getpar('INS MODE'))
		obj_destroy,prihead
		obj_destroy,fitsfile
		print,'Airmass:',airmass,', seeing:',seeing
		end
'PACMA':	begin
		spawn,'dfits PACMA*.fits | fitsort '+ $
			'OBS.TARG.NAME ORIGFILE '+ $
			'OBJECT '+ $
			'| sort -n -k 1',r
		xdisplayfile,'',title='dfits',text=r,width=142
		end
'AMBIENT':	begin
		spawn,'dfits PACMA*.fits | fitsort '+ $
			'OBS.TARG.NAME OBJECT '+ $
			'ISS.AMBI.FWHM.START ISS.AMBI.TAU0.START ISS.AMBI.WINDSP'+ $
			'| sort -n -k 1',r
		xdisplayfile,'',title='dfits',text=r,width=142
		end
'OYSTER': 	begin
		primainitializepipe
		print,'OYSTER data and recipes initialized.'
		widget_control,pipeline_wid,/sensitive
		oyster
		end
'Pipeline':	begin
		!p.multi=[0,2,2]
		myprimapipe
		end
'Recipes': 	begin
		primarecipesgui
		end
'Cleanup': 	begin
		selectprimafiles,/all
		targets=unique(obht.targname)
		for i=0,n_elements(targets)-1 do begin
		spawn,'rm -f '+strcompress(targets(i),/remove_all)+'.AVG*.fits'
		spawn,'rm -f '+strcompress(targets(i),/remove_all)+'.PHAS*.fits'
		endfor
		print,'Cleanup done.'
		end
'SmartMove':    begin
		print,'Reading files...'
                if n_elements(obht) gt 0 then begin
			index=where(strlen(strcompress(obht.issconfstation1,/remove_all)) ne 2,count)
			if count gt 0 then begin
				spawn,'mkdir -p moreprimadata'
				for i=0,count-1 do spawn,'mv '+obht(index(i)).filename+' moreprimadata'
			endif
			index=where(strlen(strcompress(obht.issconfstation1,/remove_all)) eq 2,count)
			if count gt 0 then obht=obht(index)
                        cleanprimarawdir,obht.filename
                endif else cleanprimarawdir
		print,'Moved files to moreprimadata.'
                end
'Move':		begin
		for i=0,n_elements(obht.filename)-1 do $
			print,obht(i).filename
		answer=' '
		read,prompt='Move these files to "moreprimadata"? (y/n): ',answer
		if answer eq 'y' then begin
			spawn,'mkdir -p moreprimadata'
			for i=0,n_elements(obht.filename)-1 do begin
				spawn,'mv '+obht(i).filename+' moreprimadata'
			endfor
		endif
		end
'Delete':	begin
		for i=0,n_elements(obht.filename)-1 do $
			print,obht(i).filename
		answer=' '
		read,prompt='Delete these files? (yes/no): ',answer
		if answer eq 'yes' then spawn,'rm -f '+strjoin(obht.filename,' ')
		if answer ne 'yes' then print,'Files not removed.'
		end
'Rename':	begin
		for i=0,n_elements(obht.filename)-1 do begin
			fitsfile=obj_new('fitsfile',obht(i).filename)
			prihead=fitsfile->prihead()
			dateobs=strmid(strtrim(prihead->getpar('DATE-OBS')),0,23)
			origfile=strtrim(prihead->getpar('ORIGFILE'),2)
			obj_destroy,fitsfile
			if strpos(obht(i).filename,origfile) ge 0 $
				then outfile='PACMA.'+dateobs+'.fits' $
				else outfile=origfile
			command='mv '+obht(i).filename+' '+outfile
			print,command
			spawn,command
		endfor
		end
'Reset':	begin
		spawn,'rm -f gorgonzola.sav'
		spawn,'rm -f obht.sav'
		spawn,'rm -f rawdirchecksum.sav'
		RawDirCheckSum=''
		if n_elements(obht) ne 0 then begin
			obht=obht(0)
			obht.filename=''
			widget_control,files_wid, $
				set_value=obht.filename,set_uvalue=obht.filename
		endif
		print,'Done.'
		end
'FSU Flat':		begin
		if n_elements(obht) eq 0 then begin
			print,'Please select files first!'
			return,-1
		endif
		fsuflat
		end
'OBJECT': 	begin
		if n_elements(obht) eq 0 then begin
			print,'Please select files first!'
			return,-1
		endif
		if objindex(0) ne -1 then primaobjectgui $
				     else print,'***Error: no objects selected!'
		end
;
endcase
;
end
;-------------------------------------------------------------------------------
function primagui_configid,event
;
common PrimaPipeline,rawdir,rawdirchecksum,configid,recipes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
; Set configid
r=size(event)
if r(n_elements(r)-2) eq 8 then begin
	widget_control,event.id,get_uvalue=configids
	configid=configids(event.index)
endif else configid=event
;
; Load buffered OYSTER observation
if n_elements(geninfo) eq 0 or n_elements(recipes) eq 0 then begin
	print,'Warning: OYSTER not initialized'
	return,-1
endif
index=where(geninfo.configid eq configid)
datum=geninfo(index).date
array=geoinfo(index).systemid
loadnight,datum,array,configid
recipes_file='Recipes_'+configid+'.xdr'
restore,recipes_file
print,'Restored recipes ',recipes_file
selectprimafiles,/all
;
end
;-------------------------------------------------------------------------------
pro primagui_frvalu,event
;
common PrimaOptions,prima_options,p2vmfile
;
widget_control,event.id,get_value=frvalu
prima_options.frvalu=frvalu
print,'Fringe criterion set to: ',prima_options.frcrit+' '+prima_options.frvalu
;
end
;-------------------------------------------------------------------------------
pro primagui_selvalu,event
;
; New for amdlib 2.0 beta-2
;
common PrimaOptions,prima_options,p2vmfile
;
widget_control,event.id,get_uvalue=command,get_value=selvalu
if command eq 'selValue1' then prima_options.selvalu(0)=selvalu
if command eq 'selValue2' then prima_options.selvalu(1)=selvalu
if command eq 'selValue3' then prima_options.selvalu(2)=selvalu
print,command+' set to: '+selvalu
;
end
;-------------------------------------------------------------------------------
function primagui_options,event
;
common PrimaOptions,prima_options,p2vmfile
;
widget_control,event.id,get_uvalue=command,get_value=values
if command eq 'piston' then prima_options.piston=values(event.index)
if command eq 'errors' then prima_options.errors=values(event.index)
if command eq 'merges' then prima_options.merges=values(event.index)
if command eq 'frsel'  then prima_options.frcrit=values(event.index)
;
; amdlib 2.0 beta-2
if command eq 'selcrit1' then prima_options.selcrit(0)=values(event.index)
if command eq 'selcrit2' then prima_options.selcrit(1)=values(event.index)
if command eq 'selcrit3' then prima_options.selcrit(2)=values(event.index)
if command eq 'seltype1' then prima_options.seltype(0)=values(event.index)
if command eq 'seltype2' then prima_options.seltype(1)=values(event.index)
if command eq 'seltype3' then prima_options.seltype(2)=values(event.index)
if command eq 'selvalu1' then prima_options.selvalu(0)=values(event.index)
if command eq 'selvalu2' then prima_options.selvalu(1)=values(event.index)
if command eq 'selvalu3' then prima_options.selvalu(2)=values(event.index)
;
end
;-------------------------------------------------------------------------------
function files_event,event
;
; When clicking on a file, start fv on it.
;
widget_control,event.id,get_uvalue=files
if n_elements(files) ne 0 then $
spawn,'fv -cmap 2 '+files(event.index)+' &'
;
end
;-------------------------------------------------------------------------------
pro myprimagui,dir
;
; Creates the MyPrimaiGui main widget.
;
common PrimaGuiWids,prima_wid,files_wid,window_slide_wid,pipeline_wid
common PrimaTaskWids,prima2p2v_wid,primaobject_wid,primap2vm_wid,primarecipes_wid
common PrimaOptions,prima_options,p2vmfile
common PrimaObservation,obht,skyindex,darkindex,objindex,p2vmindex
common PrimaPipeline,rawdir,rawdirchecksum,configid,recipes
;
; Initialization and cleanup
if n_elements(prima_wid) eq 0 then prima_wid=0L
if n_elements(prima2p2v_wid) eq 0 then prima2p2v_wid=0L
if n_elements(primaobject_wid) eq 0 then primaobject_wid=0L
if n_elements(primap2vm_wid) eq 0 then primap2vm_wid=0L
if n_elements(primarecipes_wid) eq 0 then primarecipes_wid=0L
if widget_info(prima_wid,/valid) then widget_control,prima_wid,/destroy
if widget_info(prima2p2v_wid,/valid) then widget_control,prima2p2v_wid,/destroy
if widget_info(primaobject_wid,/valid) then widget_control,primaobject_wid,/destroy
if widget_info(primap2vm_wid,/valid) then widget_control,primap2vm_wid,/destroy
if widget_info(primarecipes_wid,/valid) then widget_control,primarecipes_wid,/destroy
p2vmfile=''
;
if total(strlen(findfile('rawdirchecksum'))) ne 0 then restore,'rawdirchecksum'
;
RawDir=''
if n_elements(dir) eq 0 then spawn,'pwd',RawDir else RawDir=dir
RawDir=RawDir(0)+'/'
if total(strlen(findfile(RawDir))) eq 0 then begin
	print,'***Error(MYPACMAGUI): raw file directory non-existent!'
	return
endif
;
; This is used to detect changes to the raw directory
if n_elements(RawDirCheckSum) eq 0 then RawDirCheckSum=''
;
; Allocate options
prima_options=alloc_prima_options()
spawn,'amdlibComputeOiData -h',result
ipos=where(strpos(result,'amdlib') ge 0 and strpos(result,'version') ge 0)
words=nameparse(result(ipos))
prima_options.version=fix(words(1))
print,'Installed version of amdlib: ',prima_options.version
;
prima_wid=widget_base(/column,title=RawDir(0))
;
templates=['Observation', $
	   'Products']
button_wid=cw_bgroup(prima_wid,/row,templates, $
	event_func='primagui_event',/return_name)
;
templates=['FSU Flat', $
	   'Sky Flat']
button_wid=cw_bgroup(prima_wid,/row,templates, $
 	event_func='primagui_event',/return_name)
;
templates=['PACMA','FSU','AMBIENT']
button_wid=cw_bgroup(prima_wid,/row,templates, $
	event_func='primagui_event',/return_name)
;
files_wid=widget_list(prima_wid,value=strarr(10)+' ', $
	event_func='files_event', $
	xsize=15,ysize=10)
;
templates=['Reset','SmartMove','Move','Delete','Rename']
button_wid=cw_bgroup(prima_wid,/row,templates, $
	event_func='primagui_event',/return_name)
;
col_wid=widget_base(prima_wid,/col,/frame)
;
configids=analyzeprimaconfigids()
opmenuc_wid=widget_droplist(col_wid,event_func='primagui_configid', $
	uvalue=configids,value=configids)
configid=configids(0)
;
row_wid=widget_base(col_wid,/row)
;
templates=['Pipeline','Recipes','Cleanup']
pipeline_wid=cw_bgroup(row_wid,/row,templates, $
	event_func='primagui_event',/return_name)
widget_control,pipeline_wid,sensitive=0
templates=['OYSTER']
pipeline2_wid=cw_bgroup(row_wid,/row,templates, $
	event_func='primagui_event',/return_name)
;
widget_control,prima_wid,/realize
xmanager,'myprimagui',prima_wid,/no_block
;
end
;-------------------------------------------------------------------------------
function prima2p2vgui_options,event
;
common PrimaP2vmOptions,primap2vm_options
;
case event.value of
	0: primap2vm_options.c=event.select
endcase
;
end
;-------------------------------------------------------------------------------
function prima2p2vgui_event,event
;
common PrimaObservation,obht,skyindex,darkindex,objindex,p2vmindex
common Prima2p2vGuiWids,draw_wid
common PrimaP2vmOptions,primap2vm_options
;
; OYSTER common blocks
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
widget_control,event.id,get_uvalue=shutters
shutter=shutters(event.index)
;
widget_control,draw_wid,get_value=id
wset,id
erase
;
index=where(shutters eq shutter)
if primap2vm_options.c then begin
	bpix=badpixelmap(obht)
	flat=flatfieldmap(obht)
	dark=obht(p2vmindex(0)).filename
	command='amdlibCalibrateRawData '+bpix+' '+flat+' '+dark+' 1 ' $
		+obht(p2vmindex(index)).filename+' cosmetic.p2vm.fits'
	command='amdlibCalibrateRawData '+bpix+' '+flat+' '+dark+' ' $
		+obht(p2vmindex(index)).filename+' cosmetic.p2vm.fits'
	spawn,command
	filename='cosmetic.p2vm.fits'
endif else filename=obht(p2vmindex(index)).filename
data=oirgetdata(filename)
;
image1=bytscl(total(data.data1,3))
image2=bytscl(total(data.data2,3))
image3=bytscl(total(data.data3,3))
image4=bytscl(total(data.data4,3))
image=[image1,image2,image3,image4]
;
; Display in GUI
loadct,0
tvsclm,image,2
;
end
;-------------------------------------------------------------------------------
pro prima2p2vgui
;
; GUI for P2VM analysis.
;
common PrimaObservation,obht,skyindex,darkindex,objindex,p2vmindex
common PrimaTaskWids,prima2p2v_wid,primaobject_wid,primap2vm_wid,primarecipes_wid
common Prima2p2vGuiWids,draw_wid
common PrimaOptions,prima_options,p2vmfile
common PrimaPipeline,rawdir,rawdirchecksum,configid,recipes
common PrimaP2vmOptions,primap2vm_options
;
; Remove any existing widget
if widget_info(prima2p2v_wid,/valid) then widget_control,prima2p2v_wid,/destroy
;
primap2vm_options={c:0}
;
; Obtain shutter information
p2vmimages=obht.filename
n=n_elements(p2vmimages)
shutters=strarr(n)
for i=0,n-1 do begin
	fitsfile=obj_new('fitsfile',p2vmimages(i))
	prihead=fitsfile->prihead()
	shutter1=string(prihead->getpar('INS SHUT1 ST'))
	shutter2=string(prihead->getpar('INS SHUT2 ST'))
	shutter3=string(prihead->getpar('INS SHUT3 ST'))
	shutters(i)='Shutters '+strcompress(shutter1+shutter2+shutter3,/remove_all)
	obj_destroy,prihead
	obj_destroy,fitsfile
endfor
;
; Now create GUI
prima2p2v_wid=widget_base(/col, $
	title='P2VM for '+configid)
row_wid=widget_base(prima2p2v_wid,/row)
;
opmenu_wid=widget_droplist(row_wid,event_func='prima2p2vgui_event', $
	uvalue=shutters,value=shutters)
;
options=['Cosmetics']
options_wid=cw_bgroup(row_wid,options,/row,/nonexclusive, $
	event_func='prima2p2vgui_options')
;
draw_wid=widget_draw(prima2p2v_wid,event_pro='acqdraw_event', $
	scr_xsize=62*4,scr_ysize=69*2)
;
widget_control,prima2p2v_wid,/realize
xmanager,'prima2p2vgui2',prima2p2v_wid,/no_block
;
end
;-------------------------------------------------------------------------------
function primap2vmfiles_event,event
;
; Call-back for clicks on mask files in the primap2vmgui.
;
common PrimaOptions,prima_options,p2vmfile
common PrimaP2vmGuiWids,p2vmfiles_wid,draw_wid
;
widget_control,event.id,get_uvalue=files
p2vmfile=files(event.index) & p2vmfile=p2vmfile(0)
;
print,'Selected p2vm file: ',p2vmfile
;
widget_control,draw_wid,get_value=id
wset,id
;
end
;-------------------------------------------------------------------------------
function primap2vmgui_event,event
;
common PrimaObservation,obht,skyindex,darkindex,objindex,p2vmindex
common PrimaP2vmGuiWids,p2vmfiles_wid,draw_wid
common PrimaOptions,prima_options,p2vmfile
common PrimaPipeline,rawdir,rawdirchecksum,configid,recipes
;
widget_control,draw_wid,get_value=id
wset,id
;
case event.value of
;
'Update/Clear':	primap2vmgui,/update
'Check Shift' : begin
		if strlen(p2vmfile) eq 0 then begin
			print,'Error: please select P2VM file!'
			return,-1
		endif
		spawn,'rm -f batch.i'
		openw,unit,'batch.i',/get_lun
		printf,unit,'#include "amdlib.i"'
		bpix=badpixelmap(obht)
		flat=flatfieldmap(obht)
		printf,unit,'amdlibLoadFlatFieldMap, inputFlatFieldFile="'+flat+'"'
		printf,unit,'amdlibLoadBadPixelMap, inputBadPixelFile="'+bpix+'"'
		command='amdlibCheckSpectralShift,' $
		       +'inputRawFile="'+obht(objindex(0)).filename+'",' $
		       +'inputBiasFile="'+obht(darkindex(0)).filename+'",' $
		       +'inputP2vmFile="'+p2vmfile+'"'
		printf,unit,command
		printf,unit,'pause,50000;'
		printf,unit,'quit;'
		free_lun,unit
		print,'Calling yorick...(in background)'
		spawn,'yorick -batch batch.i &'
		end
'Store':	begin
		print,'Not yet implemented.'
		end
;
endcase
;
end
;-------------------------------------------------------------------------------
pro primap2vmgui,update=update
;
; GUI to select and manage p2vm files.
;
common PrimaOptions,prima_options,p2vmfile
common PrimaP2vmGuiWids,p2vmfiles_wid,draw_wid
common PrimaTaskWids,prima2p2v_wid,primaobject_wid,primap2vm_wid,primarecipes_wid
;
if n_elements(update) eq 0 then update=0
;
p2vmfile=''
spawn,'pwd',currentdir
;
; First, find all p2vm files in current directory
p2vmfiles=findfile('*.p2vm.fits')
n=n_elements(p2vmfiles)
if strlen(p2vmfiles(0)) eq 0 then begin
	print,'No P2VM files found in '+currentdir+'!'
endif
;
if update and widget_info(primap2vm_wid,/valid) then begin
	widget_control,p2vmfiles_wid,set_value=p2vmfiles,set_uvalue=p2vmfiles
	p2vmfile=''
	print,'P2VM file selection cleared.'
endif else begin
;
; Remove any existing widget
if widget_info(primap2vm_wid,/valid) then widget_control,primap2vm_wid,/destroy
;
primap2vm_wid=widget_base(/col,title='P2VM Tracker '+currentdir)
;
draw_wid=widget_draw(primap2vm_wid,event_pro='p2vmdraw_event', $
	scr_xsize=300,scr_ysize=200)
;
p2vmfiles_wid=widget_list(primap2vm_wid,value=p2vmfiles,uvalue=p2vmfiles, $
        event_func='primap2vmfiles_event',xsize=25,ysize=10)
;
tools=['Update/Clear','Check Shift','Store']
button_wid=cw_bgroup(primap2vm_wid,/row,tools, $
	event_funct='primap2vmgui_event',/return_name)
;
widget_control,primap2vm_wid,/realize
xmanager,'primap2vmgui',primap2vm_wid,/no_block
;
endelse
;
end
;-------------------------------------------------------------------------------
function primarecipes_event,event
;
; Call-back for clicks on recipes files in the primarecipesgui.
;
common PrimaOptions,prima_options,p2vmfile
common PrimaRecipesGuiWids,recipes_wid,recipetext_wid
common PrimaPipeline,rawdir,rawdirchecksum,configid,recipes
;
widget_control,event.id,get_uvalue=tags
tag=tags(event.index) & tag=tag(0)
;
index=where(recipes.tag eq tag)
fields=tag_names(recipes)
for i=0,n_elements(fields)-1 do fields(i)=fields(i)+'='+recipes(index).(i)
widget_control,recipetext_wid,set_value=fields
;
end
;-------------------------------------------------------------------------------
function primarecipesgui_event,event
;
common PrimaObservation,obht,skyindex,darkindex,objindex,p2vmindex
common PrimaOptions,prima_options,p2vmfile
common PrimaPipeline,rawdir,rawdirchecksum,configid,recipes
common PrimaRecipesGuiWids,recipes_wid,recipetext_wid
common PrimaP2vmGuiWids,p2vmfiles_wid,draw_wid
;
case event.value of
;
'Update':	begin
		tags=recipes.tag
		widget_control,recipes_wid,set_value=tags
		end
'Store':	begin
		filename='Recipes_'+configid+'.xdr'
		save,recipes,filename=filename
		print,'Saved recipes to: ',filename
		end
'Get P2VM':	begin
		if n_elements(p2vmfiles_wid) eq 0 then p2vmfiles_wid=0
		if widget_info(p2vmfiles_wid,/valid) eq 0 then begin
			print,'***Error: Please start the P2VM tracker first!'
			return,-1
		endif
		widget_control,p2vmfiles_wid,get_uvalue=p2vmfiles
		recipes.p2vm_file=p2vmfiles( $
		      widget_info(p2vmfiles_wid,/list_select))
		print,'Stored '+p2vmfiles(0)+' in all recipes.'
		end
;
endcase
;
end
;-------------------------------------------------------------------------------
pro primarecipesgui
;
; GUI to select and manage recipes.
;
common PrimaOptions,prima_options,p2vmfile
common PrimaP2vmGuiWids,p2vmfiles_wid,draw_wid
common PrimaTaskWids,prima2p2v_wid,primaobject_wid,primap2vm_wid,primarecipes_wid
common PrimaRecipesGuiWids,recipes_wid,recipetext_wid
common PrimaPipeline,rawdir,rawdirchecksum,configid,recipes
;
; Remove any existing widget
if widget_info(primarecipes_wid,/valid) then widget_control,primarecipes_wid,/destroy
;
primarecipes_wid=widget_base(/col,title='Recipes')
;
primarow_wid=widget_base(primarecipes_wid,/row)
;
tags=recipes.tag
;
recipes_wid=widget_list(primarow_wid,value=tags,uvalue=tags, $
        event_func='primarecipes_event',xsize=25,ysize=10)
;
tools=['Update','Get P2VM','Store']
button_wid=cw_bgroup(primarow_wid,/col,tools, $
	event_funct='primarecipesgui_event',/return_name)
;
recipetext_wid=widget_text(primarecipes_wid,value='Click to see recipe', $
	/scroll,ysize=8)
;
widget_control,primarecipes_wid,/realize
xmanager,'primarecipesgui',primarecipes_wid,/no_block
;
end
;-------------------------------------------------------------------------------
function vis_row_files,vis_file
;
; Both with amdlib pre-2.0 and the new amdlib with the -s option,
; different rows (i.e. bands) are written into separate files.
;
n=strlen(vis_file)
vis_files=findfile(strmid(vis_file,0,n-5)+'*')
;
; The file format has changed with DRS_2.0_Beta_1, and we now use ComputeOiData.
; if strlen(vis_files(0)) ne 0 then begin
; 	fitsfile=obj_new('fitsfile',vis_files(0))
; 	prihead=fitsfile->prihead()
; 	program=strtrim(prihead->getpar('PRO REC1 ID'))
; 	obj_destroy,prihead
; 	obj_destroy,fitsfile
; 	if program ne 'amdlibComputeOiData' then vis_files=''
; endif
;
return,vis_files
;
end
;-------------------------------------------------------------------------------
function primaobjectgui_event,event
;
common PrimaObservation,obht,skyindex,darkindex,objindex,p2vmindex
common PrimaOptions,prima_options,p2vmfile
common PrimaPipeline,rawdir,rawdirchecksum,configid,recipes
common PrimaObjectGuiWids,files_wid,draw_wid,c_wid,qc_wid,fp_wid
common PrimaObjectGui,objectfiles,row,channel,baseline,threshold
common PrimaData,prima_data,oi_array,oi_wavelength,oi_vis2,oi_t3
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if n_elements(p2vmfile) eq 0 then p2vmfile=''
;
widget_control,event.id,get_uvalue=values
if n_elements(values) eq 1 then value=event.value else value=values(event.index)
;
if objindex(0) lt 0 then return,-1
target=strtrim(obht(objindex(0)).targname,2)
;
widget_control,draw_wid,get_value=id
wset,id
set_screen
!p.charsize=1
if total(abs(!y.range)) ne 0 or total(abs(!x.range)) ne 0 $
	then user_range=1 $
	else user_range=0
;
case value of
'All selected files': begin
		objectfiles=obht(objindex).filename
;		widget_control,fp_wid,sensitive=0
		end
'J':		begin
		row=0
		if n_elements(oi_wavelength) ne 0 then begin
		r=size(oi_wavelength.j)
		if r(n_elements(r)-2) ne 8 then begin
			print,'No J data present!'
			widget_control,fp_wid,sensitive=0
			return,-1
		endif
		max_channel=n_elements(oi_wavelength.(row)(0).d(*).eff_wave)
		widget_control,c_wid,set_value=[1,1,max_channel]
		widget_control,fp_wid,/sensitive
		endif
		end
'H':		begin
		row=1
		if n_elements(oi_wavelength) ne 0 then begin
		r=size(oi_wavelength.h)
		if r(n_elements(r)-2) ne 8 then begin
			print,'No H data present!'
			widget_control,fp_wid,sensitive=0
			return,-1
		endif
		max_channel=n_elements(oi_wavelength.(row)(0).d(*).eff_wave)
		widget_control,c_wid,set_value=[1,1,max_channel]
		widget_control,fp_wid,/sensitive
		endif
		end
'K':		begin
		row=2
		if n_elements(oi_wavelength) ne 0 then begin
		r=size(oi_wavelength.k)
		if r(n_elements(r)-2) ne 8 then begin
			print,'No K data present!'
			widget_control,fp_wid,sensitive=0
			return,-1
		endif
		max_channel=n_elements(oi_wavelength.(row)(0).d(*).eff_wave)
		widget_control,c_wid,set_value=[1,1,max_channel]
		widget_control,fp_wid,/sensitive
		endif
		end
'Cleanup':	begin
		for i=0,n_elements(objectfiles)-1 do begin
			dest_file=target+'.'+ $
				  prima_options.piston+'.'+ $
				  prima_options.errors+'.'+ $
				  objectfiles(i)
			vis_files=vis_row_files(dest_file)
			for j=0,n_elements(vis_files)-1 do spawn,'rm -f '+vis_files(j)
		endfor
		print,'Cleanup done.'
		end
else:
endcase
;
end
;-------------------------------------------------------------------------------
pro primaobjectgui
;
; Display GUI for software which computes visibilities.
;
common PrimaObservation,obht,skyindex,darkindex,objindex,p2vmindex
common PrimaOptions,prima_options,p2vmfile
common PrimaTaskWids,prima2p2v_wid,primaobject_wid,primap2vm_wid,primarecipes_wid
common PrimaObjectGuiWids,files_wid,draw_wid,c_wid,qc_wid,fp_wid
common PrimaObjectGui,objectfiles,row,channel,baseline,threshold
common PrimaObjectGui2Local,c_value,s_value
;
; Remove any existing widget
if widget_info(primaobject_wid,/valid) then widget_control,primaobject_wid,/destroy
;
primaobject_wid=widget_base(/col, $
	title=obht(objindex(0)).targname+' ' $
	     +obht(objindex(0)).insmode $
	     +'('+strtrim(string(obht(objindex(0)).p2vmid),2)+')')
;
reduction_wid=widget_base(primaobject_wid,/col,/frame)
;
; Compute visibilities
reductionrow_wid=widget_base(reduction_wid,/col)
objectfiles=obht(objindex).filename
files=['All selected files',objectfiles]
files_wid=widget_droplist(reductionrow_wid,value=files,uvalue=files, $
	event_func='primaobjectgui_event')
widget_control,files_wid,sensitive=0
row_wid=widget_base(reductionrow_wid,/row)
button_wid=cw_bgroup(row_wid,/row,['ExtractVis','Cleanup'], $
	event_funct='primaobjectgui_event',/return_name)
qc_guis=['DataQC']
qc_wid=cw_bgroup(row_wid,/row,qc_guis, $
	event_funct='primaobjectgui_event',/return_name)
widget_control,qc_wid,sensitive=0
;
primaobjectrow_wid=widget_base(primaobject_wid,/row)
plots=['V2 vs SNR','V2 vs Piston','Piston vs SNR','Piston vs Time','Piston Closure','V2 Histogram']
fp_wid=widget_droplist(primaobjectrow_wid,event_func='primaobjectgui_event', $
	uvalue=plots,value=plots)
widget_control,fp_wid,sensitive=0
rows=['J','H','K'] &  row=2
rowmenu_wid=widget_droplist(primaobjectrow_wid,event_func='primaobjectgui_event', $
	uvalue=rows,value=rows)
widget_control,rowmenu_wid,set_droplist_select=2
baselines=[vlti_stationid(obht(objindex(0)).issconfstation1) $
      +'-'+vlti_stationid(obht(objindex(0)).issconfstation2)]
if not isnumeric(obht(objindex(0)).issconfstation3) then $
baselines=[baselines, $
	vlti_stationid(obht(objindex(0)).issconfstation2)+'-' $
       +vlti_stationid(obht(objindex(0)).issconfstation3), $
	vlti_stationid(obht(objindex(0)).issconfstation3)+'-' $
       +vlti_stationid(obht(objindex(0)).issconfstation1)]
baseline=baselines(0)
basemenu_wid=widget_droplist(primaobjectrow_wid,event_func='primaobjectgui_event', $
	uvalue=[baselines,'dummy'],value=baselines)
;
draw_wid=widget_draw(primaobject_wid,event_pro='trackdraw_event', $
	scr_xsize=300,scr_ysize=200)
;
max_channel=500
if strpos(obht(objindex(0)).insmode,'Low') ge 0 then max_channel=15
c_value=0
c_wid=cw_fslider(primaobject_wid,minimum=0,maximum=max_channel,value=0,/drag, $
	title='Channel (0=white light)',xsize=300,format='(i4)',uvalue='c')
widget_control,c_wid,sensitive=0
channel=-1
;
s_value=0
s_wid=cw_fslider(primaobject_wid,minimum=0,maximum=5,value=s_value,/drag, $
        title='SNR threshold for plotting',xsize=300,format='(i1)',uvalue='s')
threshold=0
;
widget_control,primaobject_wid,/realize
xmanager,'primaobjectgui2',primaobject_wid,/no_block
;
end
;-------------------------------------------------------------------------------
pro primaobjectgui2_event,event
;
common PrimaObjectGui,objectfiles,row,channel,baseline,threshold
common PrimaObjectGui2Local,c_value,s_value
;
widget_control,event.id,get_uvalue=slider,get_value=value
case slider of
	'c':c_value=long(value)
	's':s_value=long(value)
endcase
;
channel=c_value-1
threshold=s_value
;
end
;-------------------------------------------------------------------------------
pro myprimaphopipe
;
outfile='myprimaphopipe.txt'
openw,OUT,outfile,/get_lun
print,"Writing to ",outfile
;
kmags=replicate({star:'',p:0.0,s:0.0},5)
stars=['HD66598','alf-cru','HD108248','HD92397','HD156274_LHS445', $
       'HD3045_HIP2653','HD10360_HD10360J','HD202730_SAO246964', $
       'HD100286','HD106976','HD177463_HD177442']
pmags=[3.0,1.0,1.0,0.9,3.4,3.8,3.6,4.1,4.5,5.7,2.7]
smags=[4.6,1.3,1.3,8.0,4.9,4.3,3.9,5.4,4.5,6.0,3.6]
;
backfiles=file_search('PACMAN_SKY_BACK*[0-9].fits')
skyfiles=file_search('PACMAN_SKY_FLAT*[0-9].fits')
;
nb=n_elements(backfiles)
ns=n_elements(skyfiles)
;
if 2*nb ne ns then begin
	print,'***Error: inconsistent data set!'
	return
endif
;
for i=0,nb-1 do begin
;
; Background
fbt=fbt_open(backfiles(i))
swapped0= strtrim((fbt.fileobj->prihead())->getpar('HIERARCH ESO INS MODE'),2)
data= fbt.IMAGING_DATA_FSUA->readrows()
Nrows= N_elements(data)
fluxBA=(total(data.data1[3]) + total(data.data2[3]) + $
        total(data.data3[3]) + total(data.data4[3]) ) / float(4*Nrows)
data= fbt.IMAGING_DATA_FSUB->readrows()
Nrows= N_elements(data)
fluxBB=(total(data.data1[3]) + total(data.data2[3]) + $
        total(data.data3[3]) + total(data.data4[3]) ) / float(4*Nrows)
fbt_close,fbt
if swapped0 ne 'NORMAL' then begin
;	v=fluxBA
;	fluxBA=fluxBB
;	fluxBB=v
endif
print,'-----------------------------'
print,fluxBA,fluxBB
;
; Telescope 1
fbt=fbt_open(skyfiles(i*2))
swapped1= strtrim((fbt.fileobj->prihead())->getpar('HIERARCH ESO INS MODE'),2)
if swapped1 ne 'NORMAL' then begin
	print,'Swapped'
endif
target= strtrim((fbt.fileobj->prihead())->getpar('HIERARCH ESO OBS TARG NAME'),2)
ditA=float((fbt.fileobj->prihead())->getpar('HIERARCH ESO ISS PRI FSU1 DIT'))
ditB=float((fbt.fileobj->prihead())->getpar('HIERARCH ESO ISS PRI FSU2 DIT'))
data= fbt.IMAGING_DATA_FSUA->readrows()
Nrows= N_elements(data)
flux1A=(total(data.data1[3]) + total(data.data2[3]) + $
        total(data.data3[3]) + total(data.data4[3]) ) / float(4*Nrows)
data= fbt.IMAGING_DATA_FSUB->readrows()
Nrows= N_elements(data)
flux1B=(total(data.data1[3]) + total(data.data2[3]) + $
        total(data.data3[3]) + total(data.data4[3]) ) / float(4*Nrows)
fbt_close,fbt
if swapped1 ne 'NORMAL' then begin
;        v=flux1A
;        flux1A=flux1B
;        flux1B=v
endif
flux1A=flux1A-fluxBA
flux1B=flux1B-fluxBB
print,flux1A,flux1B
;
index=where(stars eq target)
pmag=pmags(index(0))
smag=smags(index(0))
pflux=10^(-pmag/2.5)*1e5
sflux=10^(-smag/2.5)*1e5
;
if swapped0 ne 'NORMAL' then begin
	v=pflux
	pflux=sflux
	sflux=v
endif
; Note: in normal mode, the primary is on FSUB!
print,sflux,pflux
sys_magA=(flux1A/ditA)/sflux
sys_magB=(flux1B/ditB)/pflux
if swapped0 ne 'NORMAL' then begin
;	v=sys_magA
;	sys_magA=sys_magB
;	sys_magB=v
endif
printf,OUT,format='(A-20," TEL1 FSUA:",F7.1," FSUB:",F7.1)',target,sys_magA,sys_magB
;
; Telescope 2
fbt=fbt_open(skyfiles(i*2+1))
swapped2= strtrim((fbt.fileobj->prihead())->getpar('HIERARCH ESO INS MODE'),2)
target= strtrim((fbt.fileobj->prihead())->getpar('HIERARCH ESO OBS TARG NAME'),2)
ditA=float((fbt.fileobj->prihead())->getpar('HIERARCH ESO ISS PRI FSU1 DIT'))
ditB=float((fbt.fileobj->prihead())->getpar('HIERARCH ESO ISS PRI FSU2 DIT'))
data= fbt.IMAGING_DATA_FSUA->readrows()
Nrows= N_elements(data)
flux2A=(total(data.data1[3]) + total(data.data2[3]) + $
        total(data.data3[3]) + total(data.data4[3]) ) / float(4*Nrows)
data= fbt.IMAGING_DATA_FSUB->readrows()
Nrows= N_elements(data)
flux2B=(total(data.data1[3]) + total(data.data2[3]) + $
        total(data.data3[3]) + total(data.data4[3]) ) / float(4*Nrows)
fbt_close,fbt
if swapped2 ne 'NORMAL' then begin
;        v=flux2A
;        flux2A=flux2B
;        flux2B=v
endif
flux2A=flux2A-fluxBA
flux2B=flux2B-fluxBB
print,flux2A,flux2B
;
if swapped0 ne swapped1 or swapped0 ne swapped2 then begin
	print,'***Error: inconsistent swap state!'
	return
endif
;
index=where(stars eq target)
pmag=pmags(index(0))
smag=smags(index(0))
pflux=10^(-pmag/2.5)*1e5
sflux=10^(-smag/2.5)*1e5
;
if swapped0 ne 'NORMAL' then begin
	v=pflux
	pflux=sflux
	sflux=v
endif
sys_magA=(flux2A/ditA)/sflux
sys_magB=(flux2B/ditB)/pflux
if swapped0 ne 'NORMAL' then begin
;	v=sys_magA
;	sys_magA=sys_magB
;	sys_magB=v
endif
printf,OUT,format='(A-20," TEL2 FSUA:",F7.1," FSUB:",F7.1)',target,sys_magA,sys_magB
;
endfor
;
free_lun,OUT
;
s=dc_read_free('myprimaphopipe.txt',v1,v2,v3,d1,v4,d2,/col)
d1=medianve(d1,e1)
d2=medianve(d2,e2)
print,d1,d2,e1,e2
;
end
;-------------------------------------------------------------------------------
pro myprimadarkpipe
;
outfile='myprimadarkpipe.txt'
openw,OUT,outfile,/get_lun
print,"Writing to ",outfile
;
darkfiles=file_search('PACMAN_LAB_DARK*[0-9].fits')
flatfiles=file_search('PACMAN_LAB_FLAT*[0-9].fits')
;
nb=n_elements(darkfiles)
ns=n_elements(flatfiles)
;
if 2*nb ne ns then begin
	print,'***Error: inconsistent data set!'
	return
endif
;
for i=0,nb-1 do begin
;
; Dark
fbt=fbt_open(darkfiles(i))
data= fbt.IMAGING_DATA_FSUA->readrows()
Nrows= N_elements(data)
fluxDA=(total(data.data1[3]) + total(data.data2[3]) + $
        total(data.data3[3]) + total(data.data4[3]) ) / float(4*Nrows)
data= fbt.IMAGING_DATA_FSUB->readrows()
Nrows= N_elements(data)
fluxDB=(total(data.data1[3]) + total(data.data2[3]) + $
        total(data.data3[3]) + total(data.data4[3]) ) / float(4*Nrows)
fbt_close,fbt
print,'-----------------------------'
;
; Flat 1
fbt=fbt_open(flatfiles(i*2))
data= fbt.IMAGING_DATA_FSUA->readrows()
Nrows= N_elements(data)
fluxFA=(total(data.data1[3]) + total(data.data2[3]) + $
        total(data.data3[3]) + total(data.data4[3]) ) / float(4*Nrows)
data= fbt.IMAGING_DATA_FSUB->readrows()
Nrows= N_elements(data)
fluxFB=(total(data.data1[3]) + total(data.data2[3]) + $
        total(data.data3[3]) + total(data.data4[3]) ) / float(4*Nrows)
fbt_close,fbt
;
fluxFA=fluxFA-fluxDA
fluxFB=fluxFB-fluxDB
;
print,fluxFA,fluxFB
;
; Flat 2
fbt=fbt_open(flatfiles(i*2+1))
data= fbt.IMAGING_DATA_FSUA->readrows()
Nrows= N_elements(data)
fluxFA=(total(data.data1[3]) + total(data.data2[3]) + $
        total(data.data3[3]) + total(data.data4[3]) ) / float(4*Nrows)
data= fbt.IMAGING_DATA_FSUB->readrows()
Nrows= N_elements(data)
fluxFB=(total(data.data1[3]) + total(data.data2[3]) + $
        total(data.data3[3]) + total(data.data4[3]) ) / float(4*Nrows)
fbt_close,fbt
;
fluxFA=fluxFA-fluxDA
fluxFB=fluxFB-fluxDB
;
print,fluxFA,fluxFB
;
endfor
;
end
;-------------------------------------------------------------------------------
