pro mdata,starname,outprefix
COMPILE_OPT DEFINT32, STRICTARR, STRICTARRSUBS
;
; This is a modification of  sdata so that we may run it 
; on multiple stars for a given night. It also modifes the 
; resulting structure in the .dat file so that the outprefix, 
; NPOI name and expected diameter are included for ease 
; of use with subsequent procedures like cubegrid.pro.
; The struture output will contain a flag indicating whether 
; we used the r-i color for the diameter. If not the diameter.bsc
; file was used. This is somewhat specific to the TPF survey
; project and would need modification for general use. 
;
; Print calibrated scan squared visibilities, errors and calculated
; model visibilities for NPOI data to a structure called sdata.
; Based on structure created by Chris Tycner, and modified by 
; Bob Zavala to include channel widths and other information.
;
; I believe loops have been set to use dimensions from genconfig 
; correctly. In principle this allows cha files from both 
; beam combiner setups to be used. *I may need to check that 
; genconfig indexes are compatible with old beam combiner data.*
;
; Input variables: starname = oyster compatible FKV, BSC name
;                  outprefix = filename prefix for sdata structure to be 
;                              saved into.
;
; File NPOI/Data/scan.info on medea has description of keywords, indices etc.
;
; Some OYSTER common statements
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Starbase,startable

; Make output file name
outname= outprefix+'-'+genconfig.date+'.dat'

; First record scan numbers for this star into array index
index=where(scans.starid eq starname)

; now select only those scans containing starid=starname using
; index array
smallscans=scans[index]

; We will need the diameter, so get this via startable

get_startable,starname
; Check if we have a BSC number, if not get it assuming the 
; FKV number is used for starid
IF startable.bsc EQ 0 THEN BEGIN 
    startable.bsc=cri(startable.fkv,'fkv-bsc') 
    get_diameter
ENDIF ELSE BEGIN
    get_diameter
ENDELSE

; See if get_diameter worked, if not use r-i color
; we use the riFlag to record if we used this method or the 
; diameter.bsc file
riFlag='FALSE'
IF startable.diameter EQ 0.0 THEN BEGIN
    print,'***Getting diameter using R-I color.***'
    IF startable.ri EQ 100.0 THEN get_ubvri
    diameter_ri
    riFlag='TRUE'
ENDIF

; Set up dummy vector to record number of lines the structure 
; sdata will require. Structure indices are defined and fixed  
; when created. Thus I need to know the dimension before I create 
; the structure sdata.
; This requires a double read of data in memory, and not a double read 
; of a file from disk.

dummy=FLTARR(10000)

i=0
; Now begin loop over the structure scans
FOR sc=0,n_elements(smallscans)-1 DO BEGIN
    FOR ob = 0,genconfig.numoutbeam-1 DO BEGIN
        FOR bl = 0,genconfig.numbaseline[ob]-1 DO BEGIN
            FOR ch = 0,genconfig.numspecchan[ob]-1 DO BEGIN
                IF smallscans[sc].vissqerr[ob,ch,bl] gt 0 THEN BEGIN
;               Check if data was flagged. For example, if Channel 11, Spec 1
;               was used, data was flagged, and this test excludes that data.
                    dummy[i]=smallscans[sc].vissq[ob,ch,bl]
                    i=i+1
                ENDIF
            ENDFOR
        ENDFOR
    ENDFOR
ENDFOR
counter=i
print,'sdata structure will contain ',counter,' lines.'
 
; Define the structure we will store the data in.

sdata = {name:outprefix,npoiId:starname,diam:startable.diameter, $ 
         riFlag:riFlag, $ 
         u:FLTARR(counter),v:FLTARR(counter),w:FLTARR(counter), $
         v2d:FLTARR(counter),v2d_err:FLTARR(counter),v2cd:FLTARR(counter), $
         v2cd_err:FLTARR(counter),v2oysmod:FLTARR(counter),v2chanmod:FLTARR(counter), $
         uv_orient:LONARR(counter),uv_scan:LONARR(counter),channel:LONARR(counter), $
         uv_wave:FLTARR(counter),chan_width:FLTARR(counter),uv_label:STRARR(counter), $
         uv_outbeam:LONARR(counter),uv_baseline:LONARR(counter), $
         photonrate:FLTARR(counter),photonrateerr:FLTARR(counter), $ 
         bgrate:FLTARR(counter),bgrateerr:FLTARR(counter)}

; reinitialize index i
i=0
; Now begin loop over the structure scans to fill sdata 
FOR sc=0,n_elements(smallscans)-1 DO BEGIN
    FOR ob = 0,genconfig.numoutbeam-1 DO BEGIN
        FOR bl = 0,genconfig.numbaseline[ob]-1 DO BEGIN
            FOR ch = 0,genconfig.numspecchan[ob]-1 DO BEGIN
                IF smallscans[sc].vissqerr[ob,ch,bl] gt 0 THEN BEGIN
;               Check if data was flagged. For example, if Channel 11, Spec 1
;               was used, data was flagged, and this test excludes that data.
                    sdata.u[i] = smallscans[sc].uvw[ob,ch,bl,0]
                    sdata.v[i] = smallscans[sc].uvw[ob,ch,bl,1] 
                    sdata.w[i] = smallscans[sc].uvw[ob,ch,bl,2]
                    sdata.v2d[i] = smallscans[sc].vissq[ob,ch,bl]
                    sdata.v2d_err[i] = smallscans[sc].vissqerr[ob,ch,bl]
                    sdata.v2cd[i] = smallscans[sc].vissqc[ob,ch,bl]
                    sdata.v2cd_err[i] = smallscans[sc].vissqcerr[ob,ch,bl]
                    sdata.v2oysmod[i] = smallscans[sc].vissqm[ob,ch,bl]
                    sdata.v2chanmod[i] = 0.0
                    sdata.uv_orient[i] = 99
                    sdata.uv_scan[i] = smallscans[sc].Iscan
                    sdata.channel[i] = ch+1
                    sdata.uv_wave[i] = genconfig.wavelength[ch,ob]
                    sdata.chan_width[i] = genconfig.chanwidth[ch,ob]
                    sdata.uv_label[i] = genconfig.baselineid[bl,ob]
                    sdata.uv_outbeam[i] = ob+1
                    sdata.uv_baseline[i] = bl+1
                    sdata.photonrate[i] = smallscans[sc].photonrate[ob,ch]
                    sdata.photonrateerr[i] = smallscans[sc].photonrateerr[ob,ch]
                    sdata.bgrate[i] = smallscans[sc].backgndrate[ob,ch]
                    sdata.bgrateerr[i] = smallscans[sc].backgnderr[ob,ch]
                    i=i+1
;                    print,'Next i = ',i
                ENDIF
            ENDFOR
        ENDFOR
    ENDFOR
ENDFOR


save,sdata,filename=outname

print,'Scan data for star ',starname,' saved to file ',outname,'.'

end


