;-------------------------------------------------------------------------------
pro rename2arc,fitsfiles
;
if n_elements(fitsfiles) eq 0 then fitsfiles='*.fits'
;
files=file_search(fitsfiles)
;
for i=0,n_elements(files)-1 do begin
;
	words=nameparse(files(i),['.','_'])
	instrument=words(0)
;
	fitsfile=obj_new('fitsfile',files(i))
	prihead=fitsfile->prihead()
	arcfile=prihead->getpar('ARCFILE')
	origfile=string(prihead->getpar('ORIGFILE'))
	obj_destroy,fitsfile
	if strpos(origfile,instrument) eq 0 and $
	   strpos(arcfile,instrument) eq 0 then begin
	command='mv '+files(i)+' '+arcfile
	spawn,command
	endif
;
endfor
;
end
;-------------------------------------------------------------------------------
pro rename2ins,fitsfiles
;
if n_elements(fitsfiles) eq 0 then fitsfiles='*.fits'
;
files=file_search(fitsfiles)
;
for i=0,n_elements(files)-1 do begin
;
	words=nameparse(files(i),['.','_'])
	instrument=words(0)
;
	fitsfile=obj_new('fitsfile',files(i))
	prihead=fitsfile->prihead()
	origfile=string(prihead->getpar('ORIGFILE'))
	arcfile=string(prihead->getpar('ARCFILE'))
	obj_destroy,fitsfile
;	if strlen(origfile) ne 0 and $
;	   strpos(arcfile,instrument) eq 0 then begin
	if strpos(origfile,instrument) eq 0 and $
	   strpos(arcfile,instrument) eq 0 then begin
	command='mv '+files(i)+' '+origfile
	spawn,command
	endif
;
endfor
;
end
;-------------------------------------------------------------------------------
pro calsciangles,w
;
dirs=file_search()
n_dirs=n_elements(dirs)
k=0
w=0.0
;
for nd=0,n_dirs-1 do begin
;
cd,dirs(nd)
obx=file_search('*.obx')
;
i_sci=where(strpos(obx,'SCI') eq 0)
lines=''
status=dc_read_fixed(obx(i_sci(0)),lines,/col,resize=[1],format='(a80)')
j=where(strpos(lines,'ra') eq 0) & j=j(0)
words=nameparse(lines(j),'"')
ra_sci=hms2h(words(1))
j=where(strpos(lines,'dec') eq 0) & j=j(0)
words=nameparse(lines(j),'"')
dec_sci=dms2d(words(1))
;
i_cal=where(strpos(obx,'CAL') eq 0,n_cal)
for n=0,n_cal-1 do begin
	lines=''
	status=dc_read_fixed(obx(i_cal(n)),lines,/col,resize=[1],format='(a80)')
	j=where(strpos(lines,'ra') eq 0) & j=j(0)
	words=nameparse(lines(j),'"')
	ra_cal=hms2h(words(1))
	j=where(strpos(lines,'dec') eq 0) & j=j(0)
	words=nameparse(lines(j),'"')
	dec_cal=dms2d(words(1))
	wn=winkel(ra_sci,dec_sci,ra_cal,dec_cal)
	if n eq 0 then begin
		wn0=wn
		w=[w,wn]
	endif else begin
		if wn ne wn0 then w=[w,wn]
	endelse
endfor
;
cd,'..'
;
endfor
;
w=w(1:n_elements(w)-1)
histograph,w,binsize=10,min=0
;
end
;-------------------------------------------------------------------------------
pro fov_obx,mode
;
common StarBase,StarTable,Notes
;
n=n_elements(startable)
;
spawn,'rm -f HDN*'+mode+'.obx'
;
lines=''
status=dc_read_fixed('fov_'+mode+'.obx',lines,/col,resize=[1],format='(a80)')
m=n_elements(lines)
;
for i=0,n-1 do begin
	sep_string=string(fix(startable(i).a*1000),format='(i3.3)')
	j=where(strpos(lines,'name') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+startable(i).starid+'_'+sep_string+'_'+mode+'"'
	OBname=startable(i).starid+'_'+sep_string+'_'+mode+''
;
	j=where(strpos(lines,'TARGET.NAME') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+'hd'+strcompress(string(startable(i).hdn),/remove_all)+'"'
;
	j=where(strpos(lines,'userComments') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "' $
		+'Sep.='+string(startable(i).a*1000,format='(f4.0)')+' mas' $
		+', D ='+string(startable(i).diameter,format='(f4.1)')+' mas' $
		+', K ='+string(startable(i).mk,format='(f4.1)')+' mag' $
		+'"'
;
	j=where(strpos(lines,'comments') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+startable(i).spectrum+'"'
;
	j=where(strpos(lines,'ra') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+hms(startable(i).ra,/aspro)+'"'
;
	j=where(strpos(lines,'dec') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+dms(startable(i).dec,/aspro)+'"'
;
	j=where(strpos(lines,'propRA') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "' $
	+string((startable(i).pmra*cos(startable(i).dec*!pi/180)/100)*15)+'"'
;
	j=where(strpos(lines,'propDec') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).pmdec/100)+'"'
;
	j=where(strpos(lines,'SEQ.SOURCE.HMAG') eq 0,count)
	for k=0,count-1 do begin
	words=nameparse(lines(j(k)))
	lines(j(k))=words(0)+' "'+string(startable(i).mh > 0)+'"'
	endfor
;
	j=where(strpos(lines,'SEQ.SOURCE.KMAG') eq 0,count)
	for k=0,count-1 do begin
	words=nameparse(lines(j(k)))
	lines(j(k))=words(0)+' "'+string(startable(i).mk > 0)+'"'
	endfor
;
	j=where(strpos(lines,'TEL.COU.MAG') eq 0,count) & j=j(0)
	if j ne -1 then begin
		words=nameparse(lines(j))
		lines(j)=words(0)+' "'+string(startable(i).mv > 0)+'"'
	endif
;
	j=where(strpos(lines,'ISS.IAS.HMAG') eq 0,count) & j=j(0)
	if j ne -1 then begin
		words=nameparse(lines(j))
		lines(j)=words(0)+' "'+string(startable(i).mh > 0)+'"'
	endif
;
	openw,unit,OBname+'.obx',/get_lun
;	openw,unit,stars(i)+'.obx',/get_lun
	for j=0,m-1 do printf,unit,lines(j)
	free_lun,unit
;
endfor
;
end
;-------------------------------------------------------------------------------
pro stecklum_obx
;
common StarBase,StarTable,Notes
;
get_stecklum,/init
startable=startable(where(startable.hdn ne 0))
n=n_elements(startable)
;
table=startable
rename_starids,'hdn-bsc'
read_catalogs
rename_bsc
table.name=startable.name
startable=table
;
; i=where(startable.pmdec lt 10. and startable.hdn gt 0 and startable.pmra lt 0.66)
; startable=startable(i)
;
lines=''
status=dc_read_fixed('hd.obx',lines,/col,resize=[1],format='(a80)')
m=n_elements(lines)
;
for i=0,n-1 do begin
;	j=where(strpos(lines,'name') eq 0) & j=j(0)
;	words=nameparse(lines(j))
;	lines(j)=words(0)+' "'+stars(i)+'"'
;	if signof(fix(strmid(dc(i),0,3))) lt 0 then s='-' else s='+'
;	lines(j)=words(0)+' "CAL_'+strmid(ra(i),0,5)+s+strmid(dc(i),1,2)+' (' $
;		+strcompress(string(fix(fi(i))),/remove)+' Jy)"'
;
	j=where(strpos(lines,'name') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+startable(i).starid+'"'
	OBname='CAL_'+strmid(hms(startable(i).ra,/aspro),0,5) $
                     +strmid(dms(startable(i).dec,/aspro),0,3)
	lines(j)=words(0)+' "CAL_'+strmid(hms(startable(i).ra,/aspro),0,5) $
			+strmid(dms(startable(i).dec,/aspro),0,3)+' (' $
		+strcompress(string(fix(startable(i).f12)),/remove)+' Jy)"'
;
	j=where(strpos(lines,'TARGET.NAME') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+'hd'+strcompress(string(startable(i).hdn))+'"'
;
	j=where(strpos(lines,'userComments') eq 0) & j=j(0)
	words=nameparse(lines(j))
;	baselines=['UT1-UT2','UT1-UT3','UT1-UT4']
;	lengths=[56.5,102.4,130.2]
	baselines=['32 m','64 m','128 m']
	lengths=[32.0,64.0,128.0]
	uvdist=fltarr(3)
	factor=!pi^2/(180l*3600l*1000l)
	lambda=10e-6
	label='Vis: '
	for k=0,2 do begin
		arg=lengths(k)/lambda*factor*startable(i).diameter
		if arg eq 0 then visamp=1 else visamp=2*beselj(arg,1)/arg
		label=label+baselines(k)+' '+string(visamp*100,format='(i3)')+'%   '
	endfor
	lines(j)=words(0)+' "'+startable(i).name+': ' $
		+strcompress(startable(i).spectrum)+', ' $
		+string(startable(i).diameter,format='(f4.1)')+' mas, ' $
		+label+'"'
;
	j=where(strpos(lines,'ra') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+hms(startable(i).ra,/aspro)+'"'
;
	j=where(strpos(lines,'dec') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+dms(startable(i).dec,/aspro)+'"'
;
	j=where(strpos(lines,'propRA') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string((startable(i).pmra*cos(startable(i).dec*!pi/180)/100)*15)+'"'
;
	j=where(strpos(lines,'propDec') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).pmdec/100)+'"'
;
	j=where(strpos(lines,'SEQ.HMAG') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).mh > 0)+'"'
;
	j=where(strpos(lines,'SEQ.CORR.IRFLUX') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).f12*visamp)+'"'
;
	j=where(strpos(lines,'SEQ.UNCORR.IRFLUX') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).f12)+'"'
;
	j=where(strpos(lines,'COU.GS.MAG') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).mv > 0)+'"'
;
	if startable(i).f12*visamp ge 15 and startable(i).mv lt 15 then begin
;		       and startable(i).pmra lt 0.66 and startable(i).pmdec lt 10. then begin
		openw,unit,OBname+'.obx',/get_lun
		for j=0,m-1 do printf,unit,lines(j)
		free_lun,unit
	endif
;
endfor
;
end
;-------------------------------------------------------------------------------
pro merand_obx
;
common StarBase,StarTable,Notes
;
get_merand,/init
startable=startable(where(startable.hdn ne 0))
n=n_elements(startable)
;
; i=where(startable.pmdec lt 10. and startable.hdn gt 0 and startable.pmra lt 0.66)
; startable=startable(i)
;
spawn,'rm -f CAL_*.obx'
;
lines=''
status=dc_read_fixed('MRK-3T.obx',lines,/col,resize=[1],format='(a80)')
m=n_elements(lines)
;
for i=0,n-1 do begin
	j=where(strpos(lines,'name') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+startable(i).starid+'"'
	OBname='CAL_'+strmid(hms(startable(i).ra,/aspro),0,5) $
                     +strmid(dms(startable(i).dec,/aspro),0,3)
	lines(j)=words(0)+' "CAL_'+strmid(hms(startable(i).ra,/aspro),0,5) $
			+strmid(dms(startable(i).dec,/aspro),0,3)+'"'
;
	j=where(strpos(lines,'TARGET.NAME') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+'hd'+strcompress(string(startable(i).hdn))+'"'
;
	j=where(strpos(lines,'userComments') eq 0) & j=j(0)
	words=nameparse(lines(j))
	baselines=['32 m','64 m','128 m']
	lengths=[32.0,64.0,128.0]
	uvdist=fltarr(3)
	factor=!pi^2/(180l*3600l*1000l)
	lambda=2.2e-6
	label='Vis(K): '
	for k=0,2 do begin
		arg=lengths(k)/lambda*factor*startable(i).diameter
		if arg eq 0 then visamp=1 else visamp=2*beselj(arg,1)/arg
		label=label+baselines(k)+' '+string(visamp*100,format='(i3)')+'%   '
	endfor
	lines(j)=words(0)+' "'+'Type '+startable(i).spectrum $
;		+', H='+string(startable(i).mh,format='(f4.1)') $
;		+', K='+string(startable(i).mk,format='(f3.1)') $
		+', D='+string(startable(i).diameter,format='(f3.1)')+' mas' $
		+', '+label $
		+'"'
;
	j=where(strpos(lines,'ra') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+hms(startable(i).ra,/aspro)+'"'
;
	j=where(strpos(lines,'dec') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+dms(startable(i).dec,/aspro)+'"'
;
	j=where(strpos(lines,'propRA') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string((startable(i).pmra*cos(startable(i).dec*!pi/180)/100)*15)+'"'
;
	j=where(strpos(lines,'propDec') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).pmdec/100)+'"'
;
	j=where(strpos(lines,'SEQ.SOURCE.HMAG') eq 0)
	for k=0,n_elements(j)-1 do begin
	words=nameparse(lines(j(k)))
	lines(j(k))=words(0)+' "'+string(startable(i).mh > 0)+'"'
	endfor
;
	j=where(strpos(lines,'SEQ.SOURCE.KMAG') eq 0)
	for k=0,n_elements(j)-1 do begin
	words=nameparse(lines(j(k)))
	lines(j(k))=words(0)+' "'+string(startable(i).mk > 0)+'"'
	endfor
;
	j=where(strpos(lines,'TEL.COU.MAG') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).mv > 0)+'"'
;
	if startable(i).mh lt 3 and startable(i).mk lt 2.5 and startable(i).dec lt 40 then begin
	openw,unit,OBname+'.obx',/get_lun
;	openw,unit,stars(i)+'.obx',/get_lun
	for j=0,m-1 do printf,unit,lines(j)
	free_lun,unit
	endif
;
endfor
;
end
;-------------------------------------------------------------------------------
pro borde_obx
;
common StarBase,StarTable,Notes
;
get_borde,/init
startable=startable(where(startable.hdn ne 0))
n=n_elements(startable)
;
; i=where(startable.pmdec lt 10. and startable.hdn gt 0 and startable.pmra lt 0.66)
; startable=startable(i)
;
spawn,'rm -f CAL_*.obx'
;
lines=''
status=dc_read_fixed('MRK-3T.obx',lines,/col,resize=[1],format='(a80)')
m=n_elements(lines)
;
for i=0,n-1 do begin
	j=where(strpos(lines,'name') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+startable(i).starid+'"'
	OBname='CAL_'+strmid(hms(startable(i).ra,/aspro),0,5) $
                     +strmid(dms(startable(i).dec,/aspro),0,3)
	lines(j)=words(0)+' "CAL_'+strmid(hms(startable(i).ra,/aspro),0,5) $
			+strmid(dms(startable(i).dec,/aspro),0,3)+'"'
;
	j=where(strpos(lines,'TARGET.NAME') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+'hd'+strcompress(string(startable(i).hdn))+'"'
;
	j=where(strpos(lines,'userComments') eq 0) & j=j(0)
	words=nameparse(lines(j))
	baselines=['32 m','64 m','128 m']
	lengths=[32.0,64.0,128.0]
	uvdist=fltarr(3)
	factor=!pi^2/(180l*3600l*1000l)
	lambda=2.2e-6
	label='Vis: '
	for k=0,2 do begin
		arg=lengths(k)/lambda*factor*startable(i).diameter
		if arg eq 0 then visamp=1 else visamp=2*beselj(arg,1)/arg
		label=label+baselines(k)+' '+string(visamp*100,format='(i3)')+'%   '
	endfor
	lines(j)=words(0)+' "'+'Type '+startable(i).spectrum $
;		+', H='+string(startable(i).mh,format='(f4.1)') $
;		+', K='+string(startable(i).mk,format='(f4.1)') $
		+', D='+string(startable(i).diameter,format='(f3.1)')+' mas' $
		+', '+label $
		+'"'
;
	j=where(strpos(lines,'ra') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+hms(startable(i).ra,/aspro)+'"'
;
	j=where(strpos(lines,'dec') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+dms(startable(i).dec,/aspro)+'"'
;
	j=where(strpos(lines,'propRA') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string((startable(i).pmra*cos(startable(i).dec*!pi/180)/100)*15)+'"'
;
	j=where(strpos(lines,'propDec') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).pmdec/100)+'"'
;
	j=where(strpos(lines,'SEQ.SOURCE.HMAG') eq 0)
	for k=0,n_elements(j)-1 do begin
	words=nameparse(lines(j(k)))
	lines(j(k))=words(0)+' "'+string(startable(i).mh > 0)+'"'
	endfor
;
	j=where(strpos(lines,'SEQ.SOURCE.KMAG') eq 0)
	for k=0,n_elements(j)-1 do begin
	words=nameparse(lines(j(k)))
	lines(j(k))=words(0)+' "'+string(startable(i).mk > 0)+'"'
	endfor
;
	j=where(strpos(lines,'TEL.COU.MAG') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).mv > 0)+'"'
;
	if startable(i).mh lt 2.5 and startable(i).mk lt 2.5 and startable(i).dec lt 40 then begin
	openw,unit,OBname+'.obx',/get_lun
;	openw,unit,stars(i)+'.obx',/get_lun
	for j=0,m-1 do printf,unit,lines(j)
	free_lun,unit
	endif
;
endfor
;
end
;-------------------------------------------------------------------------------
pro getuncert
;
common StarBase,StarTable,Notes
;
get_stecklum,/init
d=startable.diameter
de=startable.diametere
;
index=where(startable.diameter ne 0)
v2_uncert=viscalerror(d(index),de(index))*100
;
chi2=float(startable.sflag)
startable.sflag='!'
startable(index).sflag='OK'
index=where(v2_uncert gt 10)
startable(index).sflag='!'
index=where(chi2 gt 20)
startable(index).sflag='!'
;
index=where(startable.sflag eq '!')
jndex=where(startable(index).f12 gt 20 and startable(index).diameter lt 15)
;
startable=startable(index(jndex))
;
; Prepare OBs
n=n_elements(startable)
;
table=startable
rename_starids,'hdn-bsc'
read_catalogs
rename_bsc
table.name=startable.name
startable=table
;
; i=where(startable.pmdec lt 10. and startable.hdn gt 0 and startable.pmra lt 0.66)
; startable=startable(i)
;
lines=''
status=dc_read_fixed('hd.obx',lines,/col,resize=[1],format='(a80)')
m=n_elements(lines)
;
for i=0,n-1 do begin
;	j=where(strpos(lines,'name') eq 0) & j=j(0)
;	words=nameparse(lines(j))
;	lines(j)=words(0)+' "'+stars(i)+'"'
;	if signof(fix(strmid(dc(i),0,3))) lt 0 then s='-' else s='+'
;	lines(j)=words(0)+' "CAL_'+strmid(ra(i),0,5)+s+strmid(dc(i),1,2)+' (' $
;		+strcompress(string(fix(fi(i))),/remove)+' Jy)"'
;
	j=where(strpos(lines,'name') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+startable(i).starid+'"'
	OBname='CAL_'+strmid(hms(startable(i).ra,/aspro),0,5) $
                     +strmid(dms(startable(i).dec,/aspro),0,3)
	lines(j)=words(0)+' "CAL_'+strmid(hms(startable(i).ra,/aspro),0,5) $
			+strmid(dms(startable(i).dec,/aspro),0,3)+' (' $
		+strcompress(string(fix(startable(i).f12)),/remove)+' Jy)"'
;
	j=where(strpos(lines,'TARGET.NAME') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+'hd'+strcompress(string(startable(i).hdn))+'"'
;
	j=where(strpos(lines,'userComments') eq 0) & j=j(0)
	words=nameparse(lines(j))
;	baselines=['UT1-UT2','UT1-UT3','UT1-UT4']
;	lengths=[56.5,102.4,130.2]
	baselines=['32 m','64 m','128 m']
	lengths=[32.0,64.0,128.0]
	uvdist=fltarr(3)
	factor=!pi^2/(180l*3600l*1000l)
	lambda=10e-6
	label='Vis: '
	for k=0,2 do begin
		arg=lengths(k)/lambda*factor*startable(i).diameter
		if arg eq 0 then visamp=1 else visamp=2*beselj(arg,1)/arg
		label=label+baselines(k)+' '+string(visamp*100,format='(i3)')+'%   '
	endfor
	lines(j)=words(0)+' "'+startable(i).name+': ' $
		+strcompress(startable(i).spectrum)+', ' $
		+string(startable(i).diameter,format='(f4.1)')+' mas, ' $
		+label+'"'
;
	j=where(strpos(lines,'ra') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+hms(startable(i).ra,/aspro)+'"'
;
	j=where(strpos(lines,'dec') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+dms(startable(i).dec,/aspro)+'"'
;
	j=where(strpos(lines,'propRA') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string((startable(i).pmra*cos(startable(i).dec*!pi/180)/100)*15)+'"'
;
	j=where(strpos(lines,'propDec') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).pmdec/100)+'"'
;
	j=where(strpos(lines,'SEQ.HMAG') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).mh > 0)+'"'
;
	j=where(strpos(lines,'SEQ.CORR.IRFLUX') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).f12*visamp)+'"'
;
	j=where(strpos(lines,'SEQ.UNCORR.IRFLUX') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).f12)+'"'
;
	j=where(strpos(lines,'COU.GS.MAG') eq 0) & j=j(0)
	words=nameparse(lines(j))
	lines(j)=words(0)+' "'+string(startable(i).mv > 0)+'"'
;
	if startable(i).f12*visamp ge 15 and startable(i).mv lt 15 then begin
;		       and startable(i).pmra lt 0.66 and startable(i).pmdec lt 10. then begin
		openw,unit,OBname+'.obx',/get_lun
		for j=0,m-1 do printf,unit,lines(j)
		free_lun,unit
	endif
;
endfor
;
end
;-------------------------------------------------------------------------------
pro checkmidiobx,obs
;
common StarBase,StarTable,Notes
;
if n_elements(obs) eq 0 then obs='*.obx'
;
f=findfile(obs)
;
n=n_elements(f)
hdn=lonarr(n)
target=strarr(n)
;
for i=0,n-1 do begin
;
lines=''
status=dc_read_fixed(f(i),lines,/col,resize=[1],format='(a80)')
m=n_elements(lines)
j=where(strpos(lines,'TARGET.NAME') eq 0) & j=j(0)
words=nameparse(lines(j),'"')
target(i)=words(1)
hdn(i)=long(strmid(cri_vlti(target(i),'hdn'),3,6))
;
endfor
;
index=where(hdn lt 0,count)
if count gt 0 then print,target(index)
;
hdu=unique(hdn,index)
nu=n_elements(hdu)
targetu=target(index)
;
get_stecklum,/init
sts=startable
get_verhoelst,/init
stv=startable
;
stsindex=intarr(nu)
stvindex=intarr(nu)
for i=0,nu-1 do begin
	stsindex(i)=where(sts.hdn eq hdu(i),counts)
	stvindex(i)=where(stv.hdn eq hdu(i),countv)
	if counts eq 0 and countv eq 0 then begin
		print,'Neither in Stecklum nor in Verhoelst: ',hdu(i),' '+targetu(i)
		index=where(hdn eq hdu(i),count)
		for j=0,count -1 do print,f(index(j))
	endif
	if counts eq 0 and countv ne 0 then begin
		print,'Only in Verhoelst: ',hdu(i),' '+targetu(i)
		index=where(hdn eq hdu(i),count)
		for j=0,count -1 do print,f(index(j))
	endif
	if counts ne 0 and countv eq 0 then begin
		print,'Only in Stecklum: ',hdu(i),' '+targetu(i)
		index=where(hdn eq hdu(i),count)
		for j=0,count -1 do print,f(index(j))
	endif
endfor
;
end
;-------------------------------------------------------------------------------
pro checkamberobx,obs
;
common StarBase,StarTable,Notes
;
if n_elements(obs) eq 0 then obs='*.obx'
;
f=findfile(obs)
;
n=n_elements(f)
hdn=lonarr(n)
target=strarr(n)
;
for i=0,n-1 do begin
;
lines=''
status=dc_read_fixed(f(i),lines,/col,resize=[1],format='(a80)')
m=n_elements(lines)
j=where(strpos(lines,'TARGET.NAME') eq 0) & j=j(0)
words=nameparse(lines(j),'"')
target(i)=words(1)
hdn(i)=long(strmid(cri_vlti(target(i),'hdn'),3,6))
;
endfor
;
index=where(hdn eq 0,count)
if count gt 0 then print,target(index)
;
hdu=unique(hdn,index)
nu=n_elements(hdu)
targetu=target(index)
;
get_calvin,/init
stc=startable
;
get_cat,'CAL'
str=startable
;
stcindex=intarr(nu)
strindex=intarr(nu)
for i=0,nu-1 do begin
	stcindex(i)=where(stc.hdn eq hdu(i),countc)
	strindex(i)=where(str.hdn eq hdu(i),countr)
if countr ne 0 then print,'In readme.calvin: ',targetu(i)
	if countc eq 0 and countr eq 0 then begin
		print,'Neither in CalVin nor in readme.calvin: ',hdu(i),' '+targetu(i)
		index=where(hdn eq hdu(i),count)
		for j=0,count -1 do print,f(index(j))
stop
	endif
endfor
;
end
;-------------------------------------------------------------------------------
pro checkmidiobs,obs,target,flux,vis,baseline,hmag
;
common StarBase,StarTable,Notes
;
if n_elements(obs) eq 0 then obs='*.obx'
;
f=findfile(obs)
;
n=n_elements(f)
target=strarr(n)
vis=fltarr(n)
flux=fltarr(n)
hmag=fltarr(n)
;
for i=0,n-1 do begin
;
lines=''
status=dc_read_fixed(f(i),lines,/col,resize=[1],format='(a80)')
m=n_elements(lines)
j=where(strpos(lines,'SEQ.UNCORR.IRFLUX') eq 0) & j=j(0)
words=nameparse(lines(j),'"')
flux(i)=float(words(1))
j=where(strpos(lines,'SEQ.CORR.IRFLUX') eq 0) & j=j(0)
words=nameparse(lines(j),'"')
vis(i)=float(words(1))/flux(i)
j=where(strpos(lines,'TARGET.NAME') eq 0) & j=j(0)
words=nameparse(lines(j),'"')
target(i)=words(1)
j=where(strpos(lines,'SEQ.HMAG') eq 0) & j=j(0)
words=nameparse(lines(j),'"')
hmag(i)=float(words(1))
;
endfor
;
end
;-------------------------------------------------------------------------------
pro mymidivsop_transfer
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,scantable,bgtable,stationtable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common StarBase,StarTable,Notes
;
files=findfile('/home/chummel/public_html/midi/vsop/Dates/*/*.fits')
index=where(strpos(files,'PRISM') ge 0,num_files)
files=files(index)
;
first=1
num_scans=0
;
for i=0,num_files-1 do begin
	get_oifits,files(i)
	num_scan=n_elements(scans)
	num_scans=num_scans+num_scan
;
	get_verhoelst
	get_stecklum
	k=where(startable.diameter eq 0,count)
	if count gt 0 then begin
		get_jhk
		diameter_vk
		k=where(startable.diameter eq 0,count)
		if count gt 0 then begin
			startable(k).class=3
			diameter_vk
		endif
	endif
	calcviscal
;
	if first then begin
;
		freememory
		bufferinfo=replicate(nightinfo(),num_files)
		GeoInfo=replicate(GeoParms,num_files)
		GenInfo=replicate(allocgenconfig(/geninfo),num_files)
;
		table=startable
		starids=scans.starid
		vissqec=fltarr(genconfig.numspecchan(0),num_files*10)
		vissqecerr=fltarr(genconfig.numspecchan(0),num_files*10)
		first=0
	endif else begin
		table=merge_startable(table,startable)
		starids=[starids,scans.starid]
	endelse
	vissqec(*,num_scans-num_scan:num_scans-1)=scans.vissqec(0,*,0)
	vissqecerr(*,num_scans-num_scan:num_scans-1)=scans.vissqecerr(0,*,0)
;
        g=geninfo(i)
        struct_assign,genconfig,g
        geninfo(i)=g
        g=geoinfo(i)
        struct_assign,geoparms,g
        geoinfo(i)=g
	bufferinfo(i).file=files(i)
	storenight
endfor
;
startable=table
vissqec=sqrt(vissqec(*,0:num_scans-1))
vissqecerr=vissqecerr(*,0:num_scans-1)/2
;
; Find median transfer function
j=where(genconfig.wavelength gt 8e-6 and genconfig.wavelength lt 12e-6)
lambda=genconfig.wavelength(j)*1e6
nl=n_elements(lambda)
vissqec=vissqec(j,*)
vissqecerr=vissqecerr(j,*)
;
tf=fltarr(nl)
tfe=fltarr(nl)
;
for j=0,nl-1 do begin
	k=where(vissqecerr(j,*) gt 0)
	tf(j)=medianve(vissqec(j,k),e)
	tfe(j)=e
endfor
;
; Mean TF error
mtfe=mean(tfe/tf)
;
!p.charsize=1.5
!y.title='Transfer function'
!x.title='Wavelength [microns]'
!p.title='MIDI'
!x.range=[8,12]
!y.range=[0,1.2]
!p.psym=0
!p.thick=0
!p.color=tci(1)
if !d.name eq 'PS' then !p.color=0
;
plot,lambda,vissqec(*,0),/nodata
for i=0,num_scans-1 do begin
	j=where(vissqecerr gt 0,count)
	if count gt 0 then  oplot,lambda(j),vissqec(j,i)
endfor
;
!p.thick=5
!p.color=tci(3)
oplot,lambda,tf
oploterr,lambda,tf,tfe,3
!p.thick=0
!p.color=tci(1)
if !d.name eq 'PS' then !p.color=0
;
; Find out which calibrator might be bad
stars=unique(starids)
ns=n_elements(stars)
badid=intarr(ns)
;
tfs=fltarr(nl)
tfsc=fltarr(nl)
tfse=fltarr(nl)
;
for i=0,ns-1 do begin
	k=where(starids eq stars(i))
	vsqec=vissqec(*,k)
	vsqece=vissqecerr(*,k)
	for j=0,nl-1 do begin
		k=where(vsqece(j,*) gt 0,count)
		if count gt 0 then begin
			tfs(j)=medianve(vsqec(j,k))
			tfsc(j)=count
		endif
	endfor
	ratio=tfs/tf
	if abs(mean(ratio)-1) gt mtfe $
		and total(tfsc) gt 2*nl $
		and stddev(ratio) lt 0.1 then begin
		badid(i)=1
		oplot,lambda,tfs,psym=0,color=tci(2),thick=2
	endif
endfor 
;
print,'Bad calibrators: ',stars(where(badid eq 1))
;
; Plot a specific star
star='HDN048915'
k=where(starids eq star)
vsqec=vissqec(*,k)
vsqece=vissqecerr(*,k)
for j=0,nl-1 do begin
        k=where(vsqece(j,*) gt 0,count)
        if count gt 0 then begin
                tfs(j)=medianve(vsqec(j,k),e)
                tfse(j)=e
        endif
endfor
!p.color=tci(5)
!p.thick=3
oplot,lambda,tfs,psym=0
oploterr,lambda,tfs,tfe,3
!p.thick=0
!p.color=0
;
if !d.name eq 'PS' then device,/close
;
end
;-------------------------------------------------------------------------------
pro mymidivsop_conversionfactor,save_file
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,scantable,bgtable,stationtable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common StarBase,StarTable,Notes
;
band=[10.5,11.5]*1e-6
beams=['A','B']
;
if n_elements(save_file) ne 0 then restore,save_file else begin
files=findfile('/home/chummel/public_html/midi/vsop/Dates/*/*.cha.xdr')
index=where(strpos(files,'PRISM') ge 0,num_files)
files=files(index)
;
; MIDI beam A and B
stations=strarr(num_files,2)
stations(*,0)=strmid(specname(files),17,3)
stations(*,1)=strmid(specname(files),21,3)
;
maxchan=100
maxstar=20
conv_factor=fltarr(maxchan,maxstar,num_files,2)
conv_error=fltarr(maxchan,maxstar,num_files,2)
conv_weight=fltarr(maxstar,num_files)
lambda=fltarr(maxchan,num_files)
;
numchan=intarr(num_files)
numstar=intarr(num_files)
;
for i=0,num_files-1 do begin
	get_xdr,files(i)
	numchan(i)=genconfig.numspecchan(0)
	numstar(i)=n_elements(startable)
	lambda[0:genconfig.numspecchan(0)-1,i] $
	=genconfig.wavelength(0:genconfig.numspecchan(0)-1,0)
	amc=1./cos(scans.za/(180/!pi))
	for j=0,n_elements(startable)-1 do begin
		k=where(scans.starid eq startable(j).starid,count)
		conv_weight(j,i)=count
		if count gt 0 then begin
		photscale,startable(j).starid,/noplot
		conv_factor(0:genconfig.numspecchan(0)-1,j,i,0) $
		=scans(k(0)).photometryscale(0,0,0:genconfig.numspecchan(0)-1) $
		/amc(k(0))
		conv_error(0:genconfig.numspecchan(0)-1,j,i,0) $
		=scans(k(0)).photometryerr(0,0,0:genconfig.numspecchan(0)-1)
		conv_factor(0:genconfig.numspecchan(0)-1,j,i,1) $
		=scans(k(0)).photometryscale(1,0,0:genconfig.numspecchan(0)-1) $
		/amc(k(0))
		conv_error(0:genconfig.numspecchan(0)-1,j,i,1) $
		=scans(k(0)).photometryerr(1,0,0:genconfig.numspecchan(0)-1)
		endif
	endfor
endfor
;
save,stations,numstar,lambda, $
	conv_factor,conv_error,conv_weight,filename='conversiondata.xdr'
endelse
;
; Plot conversion factors
FOR i=0,1 DO BEGIN
;
stations_u=unique(stations(*,i))
num_u=n_elements(stations_u)
ny=fix(sqrt(num_u))
nx=num_u/ny
if nx ge 3 or ny ge 3 then !p.charsize=2 else !p.charsize=1.5
!p.multi=[0,nx,ny]
!y.title='Conversion factor'
if !d.name ne 'PS' then window,/free
;
; Plot for each station attached to this beam
for j=0,num_u-1 do begin
	index=where(stations(*,i) eq stations_u(j),count)
	cf=conv_factor(*,*,index,i)
	ce=conv_error(*,*,index,i)
	maxstar=total(numstar(index))
	y=fltarr(maxstar)
	e=fltarr(maxstar)
	k0=0
	for k=0,count-1 do begin
		jndex=where(lambda(*,index(k)) gt band(0) $
			and lambda(*,index(k)) lt band(1),nl)
		k1=k0+numstar(index(k))-1
		y(k0:k1)=total(cf(jndex,0:numstar(index(k))-1,k),1)/nl
		e(k0:k1)=total(ce(jndex,0:numstar(index(k))-1,k),1)/nl
		k0=k0+numstar(index(k))
	endfor
	if strpos(stations_u(j),'UT') ge 0 then yrange=[0,0.003] $
					   else yrange=[0,0.05]
	!x.range=[-1,n_elements(y)+1]
	!p.title=stations_u(j)+' ('+beams(i)+')'
	index=where(y gt 0)
	plot,y(index)*10,psym=1,yrange=yrange*10
	oploterr,y(index)*10,e(index)*10,3
endfor
;
ENDFOR
;
; Plot conversion factor intra-night error
FOR i=0,1 DO BEGIN
;
stations_u=unique(stations(*,i))
num_u=n_elements(stations_u)
ny=fix(sqrt(num_u))
nx=num_u/ny
if nx ge 3 or ny ge 3 then !p.charsize=2 else !p.charsize=1.5
!p.multi=[0,nx,ny]
!y.title='Intra night %'
if !d.name ne 'PS' then window,/free
;
; Plot for each station attached to this beam
for j=0,num_u-1 do begin
	index=where(stations(*,i) eq stations_u(j),count)
	cf=conv_factor(*,*,index,i)
	ce=conv_error(*,*,index,i)
	cw=conv_weight(*,index)
	maxstar=total(numstar(index))
	y=fltarr(count)
	e=fltarr(count)
;	Each night with this station
	for k=0,count-1 do begin
		jndex=where(lambda(*,index(k)) gt band(0) $
			and lambda(*,index(k)) lt band(1),nl)
		cfn=total(cf(jndex,0:numstar(index(k))-1,k),1)/nl
		cen=total(ce(jndex,0:numstar(index(k))-1,k),1)/nl
		l=where(cfn gt 0,lc)
		if lc gt 1 then begin
			y(k)=stddev(cfn(l))/mean(cfn(l))
		endif else begin
			y(k)=cen(l)/cfn(l)
		endelse
	endfor
	!x.range=[-1,n_elements(y)+1]
	!p.title=stations_u(j)+' ('+beams(i)+')'
	index=where(y gt 0,count)
	if count gt 0 then $
	plot,y(index)*100,psym=6,yrange=[0,100]
endfor
;
ENDFOR
;
end
;-------------------------------------------------------------------------------
pro setbflagtobm
;
; Set startable.bflag to 'C' only for Borde 2002 and Merand 2005 calibrators,
; assuming that they can be recognized in the name through pre-fixes
; 'B02' and 'M05'
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common StarBase,StarTable,Notes
;
startable.bflag='.'
;
; Set startable.bflag='C' for Borde and Merand calibrators
index=where(strpos(startable.name,'B02') eq 0,count)
if count gt 0 then startable(index).bflag='C'
index=where(strpos(startable.name,'M05') eq 0,count)
if count gt 0 then startable(index).bflag='C'
;
end
;-------------------------------------------------------------------------------
pro ambertriples
;
; Set all triple amplitudes to unity
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
scans.tripleamp=1
scans.tripleampc=1
scans.tripleampe=1
scans.tripleampec=1
;
scans.tripleamperr=-1
scans.tripleampcerr=-1
scans.tripleampeerr=-1
scans.tripleampecerr=-1
;
end
;-------------------------------------------------------------------------------
