;*******************************************************************************
; File: idlfunctions.pro
;
; Description: 
; ------------
; This file contains functions and procedures to be compiled for the IDL
; version of the OYSTER software.
;
; Block directory:
; ----------------
; Block 1: dc_read_free,dc_read_fixed,dc_read_tiff
; Block 2: unique,avg,nint,linknload
; Block 3: dt_print,quit,bye,hak
;
;************************************************************************Block 1
function dc_read_free,file,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10, $
	v11,v12,v13,v14,v15,v16,v17,v18,v19,v20, $
	v21,v22,v23,v24,v25,v26,v27,v28,v29,v30, $
	v31,v32,v33,v34,v35,v36,v37,v38,v39, $
	column=col,row=row,nrecs=nrc,nskip=skp,null=nul, $
	ignore=ign,resize=res,filters=fil,delimeter=delim
;
; Reads free format column or row oriented ascii files with alphanumeric data.
; If neither row or column keywords are set, assume row oriented data.
;
forward_function nameparse,isnumeric,produkt
;
; Check if file exists
if n_elements(file) eq 0 then begin
	print,'***Error(DC_READ_FREE): file undefined!'
	return,-1
endif
result=findfile(file)
if strlen(result(0)) eq 0 then begin
	print,'***Error(DC_READ_FREE): file not found: '+file+'!'
	return,-1
endif
;
; Get number of lines/physical records
openr,unit,file,/get_lun
r=fstat(unit)
if r.size eq 0 then return,-1
s=bytarr(r.size)
readu,unit,s
free_lun,unit
index=where(s eq 10b,num_lines)
;
; Check the row keyword
if not keyword_set(row) then row=0
;
; Check the column keyword
if not keyword_set(col) then row=1
;
; Check the nrecs keyword
if not keyword_set(nrc) then nrc=num_lines
;
; Check the delimeters keyword
if not keyword_set(delim) then delim=[' ',string(09b)]
;
; Check the nskip keyword
if not keyword_set(skp) then skp=0
if skp ge num_lines then return,-1
;
; Check the null keyword
if not keyword_set(nul) then nul=''
;
; Check the ignore keyword
if keyword_set(ign) then i_ign=n_elements(ign) else i_ign=0
;
; Check the filters keyword
if keyword_set(fil) then i_fil=n_elements(fil) else i_fil=0
;
; Check type of input parameters
type=intarr(n_params()-1)
for i=0,n_params()-2 do begin
	case i+1 of
		 1:type(i)=(size( v1))(n_elements(size( v1))-2)
		 2:type(i)=(size( v2))(n_elements(size( v2))-2)
		 3:type(i)=(size( v3))(n_elements(size( v3))-2)
		 4:type(i)=(size( v4))(n_elements(size( v4))-2)
		 5:type(i)=(size( v5))(n_elements(size( v5))-2)
		 6:type(i)=(size( v6))(n_elements(size( v6))-2)
		 7:type(i)=(size( v7))(n_elements(size( v7))-2)
		 8:type(i)=(size( v8))(n_elements(size( v8))-2)
		 9:type(i)=(size( v9))(n_elements(size( v9))-2)
		10:type(i)=(size(v10))(n_elements(size(v10))-2)
		11:type(i)=(size(v11))(n_elements(size(v11))-2)
		12:type(i)=(size(v12))(n_elements(size(v12))-2)
		13:type(i)=(size(v13))(n_elements(size(v13))-2)
		14:type(i)=(size(v14))(n_elements(size(v14))-2)
		15:type(i)=(size(v15))(n_elements(size(v15))-2)
		16:type(i)=(size(v16))(n_elements(size(v16))-2)
		17:type(i)=(size(v17))(n_elements(size(v17))-2)
		18:type(i)=(size(v18))(n_elements(size(v18))-2)
		19:type(i)=(size(v19))(n_elements(size(v19))-2)
		20:type(i)=(size(v20))(n_elements(size(v20))-2)
		21:type(i)=(size(v21))(n_elements(size(v21))-2)
		22:type(i)=(size(v22))(n_elements(size(v22))-2)
		23:type(i)=(size(v23))(n_elements(size(v23))-2)
		24:type(i)=(size(v24))(n_elements(size(v24))-2)
		25:type(i)=(size(v25))(n_elements(size(v25))-2)
		26:type(i)=(size(v26))(n_elements(size(v26))-2)
		27:type(i)=(size(v27))(n_elements(size(v27))-2)
		28:type(i)=(size(v28))(n_elements(size(v28))-2)
		29:type(i)=(size(v29))(n_elements(size(v29))-2)
		30:type(i)=(size(v30))(n_elements(size(v30))-2)
		31:type(i)=(size(v31))(n_elements(size(v31))-2)
		32:type(i)=(size(v32))(n_elements(size(v32))-2)
		33:type(i)=(size(v33))(n_elements(size(v33))-2)
		34:type(i)=(size(v34))(n_elements(size(v34))-2)
		35:type(i)=(size(v35))(n_elements(size(v35))-2)
		36:type(i)=(size(v36))(n_elements(size(v36))-2)
		37:type(i)=(size(v37))(n_elements(size(v37))-2)
		38:type(i)=(size(v38))(n_elements(size(v38))-2)
		39:type(i)=(size(v39))(n_elements(size(v39))-2)
	endcase
endfor
;
; Check dimensions of input parameters
n_el=intarr(n_params()-1)
for i=0,n_params()-2 do begin
	case i+1 of
		 1:n_el(i)=n_elements( v1)
		 2:n_el(i)=n_elements( v2)
		 3:n_el(i)=n_elements( v3)
		 4:n_el(i)=n_elements( v4)
		 5:n_el(i)=n_elements( v5)
		 6:n_el(i)=n_elements( v6)
		 7:n_el(i)=n_elements( v7)
		 8:n_el(i)=n_elements( v8)
		 9:n_el(i)=n_elements( v9)
		10:n_el(i)=n_elements(v10)
		11:n_el(i)=n_elements(v11)
		12:n_el(i)=n_elements(v12)
		13:n_el(i)=n_elements(v13)
		14:n_el(i)=n_elements(v14)
		15:n_el(i)=n_elements(v15)
		16:n_el(i)=n_elements(v16)
		17:n_el(i)=n_elements(v17)
		18:n_el(i)=n_elements(v18)
		19:n_el(i)=n_elements(v19)
		20:n_el(i)=n_elements(v20)
		21:n_el(i)=n_elements(v21)
		22:n_el(i)=n_elements(v22)
		23:n_el(i)=n_elements(v23)
		24:n_el(i)=n_elements(v24)
		25:n_el(i)=n_elements(v25)
		26:n_el(i)=n_elements(v26)
		27:n_el(i)=n_elements(v27)
		28:n_el(i)=n_elements(v28)
		29:n_el(i)=n_elements(v29)
		30:n_el(i)=n_elements(v30)
		31:n_el(i)=n_elements(v31)
		32:n_el(i)=n_elements(v32)
		33:n_el(i)=n_elements(v33)
		34:n_el(i)=n_elements(v34)
		35:n_el(i)=n_elements(v35)
		36:n_el(i)=n_elements(v36)
		37:n_el(i)=n_elements(v37)
		38:n_el(i)=n_elements(v38)
		39:n_el(i)=n_elements(v39)
	endcase
endfor
;
; Open file, read, and parse it 
openr,unit,file,/get_lun
a=''
line=0L
recd=0L
while not eof(unit) and line lt nrc do begin
	readf,unit,a
	skip=0
	if recd lt skp then a=''
	if strlen(a) eq 0 then skip=1 else begin
;		First, replace the characters to be filtered
		for i=0,i_fil-1 do begin
			while strpos(a,fil(i)) ne -1 do $
				strput,a,' ',strpos(a,fil(i))
		endfor
;		Then, ignore the lines with certain string in them
		for i=0,i_ign-1 do begin
			case ign(i) of
			'$TEXT_IN_NUMERIC':if produkt(isnumeric(nameparse(a,delim))) $
					   eq 0 then goto,next_line
			else: if strpos(a,ign(i),0) ne -1 then skip=1
			endcase
		endfor
	endelse
	if strlen(nul) gt 0 then while strpos(a,'null') ne -1 do strput,a,nul,strpos(a,'null')
	if not skip then begin
		words=[nameparse(a,delim),strarr(39)]
		for i=0,n_params()-2 do begin
			if row then begin
			case i+1 of
			 	1: v1(*)=words(                 0:total(n_el(0:i))-1)
			 	2: v2(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			 	3: v3(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			 	4: v4(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			 	5: v5(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			 	6: v6(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			 	7: v7(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			 	8: v8(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			 	9: v9(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       10:v10(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       11:v11(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       12:v12(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       13:v13(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       14:v14(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       15:v15(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       16:v16(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       17:v17(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       18:v18(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       19:v19(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       20:v20(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       21:v21(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       22:v22(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       23:v23(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       24:v24(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       25:v25(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       26:v26(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       27:v27(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       28:v28(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       29:v29(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       30:v30(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       31:v31(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       32:v32(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       33:v33(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       34:v34(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       35:v35(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       36:v36(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       37:v37(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       38:v38(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			       39:v39(*)=words(total(n_el(0:i-1)):total(n_el(0:i))-1)
			endcase
			endif else begin
			if line eq 0 then begin
				if type(i) eq 0 then begin
					if isnumeric(words(i)) then begin
					if strpos(words(i),'.') ne -1 then type(i)=5 $
							              else type(i)=3
					endif else type(i)=7
				endif
			endif
			case type(i) of
				1: v=byte(words(i))
				2: v=fix(words(i))
				3: v=long(words(i))
				4: v=float(words(i))
				5: v=double(words(i))
				6: v=complex(words(i))
				7: v=words(i)
			endcase
			if line eq 0 then begin
				case i+1 of 
					1: v1=replicate(v,num_lines)
					2: v2=replicate(v,num_lines)
					3: v3=replicate(v,num_lines)
					4: v4=replicate(v,num_lines)
					5: v5=replicate(v,num_lines)
					6: v6=replicate(v,num_lines)
					7: v7=replicate(v,num_lines)
					8: v8=replicate(v,num_lines)
					9: v9=replicate(v,num_lines)
				       10:v10=replicate(v,num_lines)
				       11:v11=replicate(v,num_lines)
				       12:v12=replicate(v,num_lines)
				       13:v13=replicate(v,num_lines)
				       14:v14=replicate(v,num_lines)
				       15:v15=replicate(v,num_lines)
				       16:v16=replicate(v,num_lines)
				       17:v17=replicate(v,num_lines)
				       18:v18=replicate(v,num_lines)
				       19:v19=replicate(v,num_lines)
				       20:v20=replicate(v,num_lines)
				       21:v21=replicate(v,num_lines)
				       22:v22=replicate(v,num_lines)
				       23:v23=replicate(v,num_lines)
				       24:v24=replicate(v,num_lines)
				       25:v25=replicate(v,num_lines)
				       26:v26=replicate(v,num_lines)
				       27:v27=replicate(v,num_lines)
				       28:v28=replicate(v,num_lines)
				       29:v29=replicate(v,num_lines)
				       30:v30=replicate(v,num_lines)
				       31:v31=replicate(v,num_lines)
				       32:v32=replicate(v,num_lines)
				       33:v33=replicate(v,num_lines)
				       34:v34=replicate(v,num_lines)
				       35:v35=replicate(v,num_lines)
				       36:v36=replicate(v,num_lines)
				       37:v37=replicate(v,num_lines)
				       38:v38=replicate(v,num_lines)
				       39:v39=replicate(v,num_lines)
				endcase
			endif
			case i+1 of 
				1: v1(line)=v
				2: v2(line)=v
				3: v3(line)=v
				4: v4(line)=v
				5: v5(line)=v
				6: v6(line)=v
				7: v7(line)=v
				8: v8(line)=v
				9: v9(line)=v
			       10:v10(line)=v
			       11:v11(line)=v
			       12:v12(line)=v
			       13:v13(line)=v
			       14:v14(line)=v
			       15:v15(line)=v
			       16:v16(line)=v
			       17:v17(line)=v
			       18:v18(line)=v
			       19:v19(line)=v
			       20:v20(line)=v
			       21:v21(line)=v
			       22:v22(line)=v
			       23:v23(line)=v
			       24:v24(line)=v
			       25:v25(line)=v
			       26:v26(line)=v
			       27:v27(line)=v
			       28:v28(line)=v
			       29:v29(line)=v
			       30:v30(line)=v
			       31:v31(line)=v
			       32:v32(line)=v
			       33:v33(line)=v
			       34:v34(line)=v
			       35:v35(line)=v
			       36:v36(line)=v
			       37:v37(line)=v
			       38:v38(line)=v
			       39:v39(line)=v
			endcase
			endelse
		endfor
		line=line+1
	endif
	next_line:
	recd=recd+1
endwhile
;
if not row then begin
for i=0,n_params()-2 do begin
	case i+1 of
	 1: v1= v1(0:line-1)
	 2: v2= v2(0:line-1)
	 3: v3= v3(0:line-1)
	 4: v4= v4(0:line-1)
	 5: v5= v5(0:line-1)
	 6: v6= v6(0:line-1)
	 7: v7= v7(0:line-1)
	 8: v8= v8(0:line-1)
	 9: v9= v9(0:line-1)
	10:v10=v10(0:line-1)
	11:v11=v11(0:line-1)
	12:v12=v12(0:line-1)
	13:v13=v13(0:line-1)
	14:v14=v14(0:line-1)
	15:v15=v15(0:line-1)
	16:v16=v16(0:line-1)
	17:v17=v17(0:line-1)
	18:v18=v18(0:line-1)
	19:v19=v19(0:line-1)
	20:v20=v20(0:line-1)
	21:v21=v21(0:line-1)
	22:v22=v22(0:line-1)
	23:v23=v23(0:line-1)
	24:v24=v24(0:line-1)
	25:v25=v25(0:line-1)
	26:v26=v26(0:line-1)
	27:v27=v27(0:line-1)
	28:v28=v28(0:line-1)
	29:v29=v29(0:line-1)
	30:v30=v30(0:line-1)
	31:v31=v31(0:line-1)
	32:v32=v32(0:line-1)
	33:v33=v33(0:line-1)
	34:v34=v34(0:line-1)
	35:v35=v35(0:line-1)
	36:v36=v36(0:line-1)
	37:v37=v37(0:line-1)
	38:v38=v38(0:line-1)
	39:v39=v39(0:line-1)
	endcase
endfor
endif
;
free_lun,unit
;
return,0
;
end
;-------------------------------------------------------------------------------
function dc_read_fixed,file,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12, $
	v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24, $
	v25,v26,v27,v28,v29,v30,v31,v32,v33,v34,v35,v36, $
	column=col,row=row,nrecs=nrc,nskip=skp,null=nul, $
	ignore=ign,resize=res,filters=fil,format=form,delimeter=delim
;
; Reads fixed format column or row oriented ascii files, with alphanumeric data.
; If neither row or column keywords are set, assume row oriented data.
;
forward_function nameparse,isnumeric,produkt
;
; Check if file exists
if n_elements(file) eq 0 then return,-1
result=findfile(file)
if strlen(result(0)) eq 0 then return,-1
;
; Get number of lines/physical records
openr,unit,file,/get_lun
r=fstat(unit)
if r.size eq 0 then return,-1
s=bytarr(r.size)
readu,unit,s
free_lun,unit
index=where(s eq 10b,num_lines)
reclen_est=r.size/num_lines*2
;
; Check the row keyword
if not keyword_set(row) then row=0
;
; Check the column keyword
if not keyword_set(col) then row=1
;
; Check the nrecs keyword
if not keyword_set(nrc) then nrc=num_lines
;
; Check the nskip keyword
if not keyword_set(skp) then skp=0
if skp ge num_lines then return,-1
;
; Check the null keyword
if not keyword_set(nul) then nul=''
;
; Check the delimeters keyword
if not keyword_set(delim) then delim=[' ',string(09b)]
;
; Check the ignore keyword
if keyword_set(ign) then i_ign=n_elements(ign) else i_ign=0
;
; Check the filters keyword
if keyword_set(fil) then i_fil=n_elements(fil) else i_fil=0
;
; Check the format keyword; don't skip blank lines if not decoded
if not keyword_set(form) then form=' '
if n_elements(nameparse(form,',')) eq 1 and strpos(form,'a') ge 0 then blankskip=0 $
						      		  else blankskip=1
;
; Check type of input parameters
type=intarr(n_params()-1)
for i=0,n_params()-2 do begin
	case i+1 of
		 1:type(i)=(size( v1))(n_elements(size( v1))-2)
		 2:type(i)=(size( v2))(n_elements(size( v2))-2)
		 3:type(i)=(size( v3))(n_elements(size( v3))-2)
		 4:type(i)=(size( v4))(n_elements(size( v4))-2)
		 5:type(i)=(size( v5))(n_elements(size( v5))-2)
		 6:type(i)=(size( v6))(n_elements(size( v6))-2)
		 7:type(i)=(size( v7))(n_elements(size( v7))-2)
		 8:type(i)=(size( v8))(n_elements(size( v8))-2)
		 9:type(i)=(size( v9))(n_elements(size( v9))-2)
		10:type(i)=(size(v10))(n_elements(size(v10))-2)
		11:type(i)=(size(v11))(n_elements(size(v11))-2)
		12:type(i)=(size(v12))(n_elements(size(v12))-2)
		13:type(i)=(size(v13))(n_elements(size(v13))-2)
		14:type(i)=(size(v14))(n_elements(size(v14))-2)
		15:type(i)=(size(v15))(n_elements(size(v15))-2)
		16:type(i)=(size(v16))(n_elements(size(v16))-2)
		17:type(i)=(size(v17))(n_elements(size(v17))-2)
		18:type(i)=(size(v18))(n_elements(size(v18))-2)
		19:type(i)=(size(v19))(n_elements(size(v19))-2)
		20:type(i)=(size(v20))(n_elements(size(v20))-2)
		21:type(i)=(size(v21))(n_elements(size(v21))-2)
		22:type(i)=(size(v22))(n_elements(size(v22))-2)
		23:type(i)=(size(v23))(n_elements(size(v23))-2)
		24:type(i)=(size(v24))(n_elements(size(v24))-2)
		25:type(i)=(size(v25))(n_elements(size(v25))-2)
		26:type(i)=(size(v26))(n_elements(size(v26))-2)
		27:type(i)=(size(v27))(n_elements(size(v27))-2)
		28:type(i)=(size(v28))(n_elements(size(v28))-2)
		29:type(i)=(size(v29))(n_elements(size(v29))-2)
		30:type(i)=(size(v30))(n_elements(size(v30))-2)
		31:type(i)=(size(v31))(n_elements(size(v31))-2)
		32:type(i)=(size(v32))(n_elements(size(v32))-2)
		33:type(i)=(size(v33))(n_elements(size(v33))-2)
		34:type(i)=(size(v34))(n_elements(size(v34))-2)
		35:type(i)=(size(v35))(n_elements(size(v35))-2)
		36:type(i)=(size(v36))(n_elements(size(v36))-2)
	endcase
endfor
;
; Check dimensions of input parameters
n_el=intarr(n_params()-1)
for i=0,n_params()-2 do begin
	case i+1 of
		 1:n_el(i)=n_elements( v1)
		 2:n_el(i)=n_elements( v2)
		 3:n_el(i)=n_elements( v3)
		 4:n_el(i)=n_elements( v4)
		 5:n_el(i)=n_elements( v5)
		 6:n_el(i)=n_elements( v6)
		 7:n_el(i)=n_elements( v7)
		 8:n_el(i)=n_elements( v8)
		 9:n_el(i)=n_elements( v9)
		10:n_el(i)=n_elements(v10)
		11:n_el(i)=n_elements(v11)
		12:n_el(i)=n_elements(v12)
		13:n_el(i)=n_elements(v13)
		14:n_el(i)=n_elements(v14)
		15:n_el(i)=n_elements(v15)
		16:n_el(i)=n_elements(v16)
		17:n_el(i)=n_elements(v17)
		18:n_el(i)=n_elements(v18)
		19:n_el(i)=n_elements(v19)
		20:n_el(i)=n_elements(v20)
		21:n_el(i)=n_elements(v21)
		22:n_el(i)=n_elements(v22)
		23:n_el(i)=n_elements(v23)
		24:n_el(i)=n_elements(v24)
		25:n_el(i)=n_elements(v25)
		26:n_el(i)=n_elements(v26)
		27:n_el(i)=n_elements(v27)
		28:n_el(i)=n_elements(v28)
		29:n_el(i)=n_elements(v29)
		30:n_el(i)=n_elements(v30)
		31:n_el(i)=n_elements(v31)
		32:n_el(i)=n_elements(v32)
		33:n_el(i)=n_elements(v33)
		34:n_el(i)=n_elements(v34)
		35:n_el(i)=n_elements(v35)
		36:n_el(i)=n_elements(v36)
	endcase
endfor
;
; Open file, read, and parse it 
openr,unit,file,/get_lun
a=''
line=0L
recd=0L
while not eof(unit) and line lt nrc do begin
	readf,unit,a
	for i=0,reclen_est do a=a+' '
	skip=0
	if recd lt skp then a=''
	if strlen(strcompress(a,/remove)) eq 0 and blankskip then skip=1 else begin
;		First, replace the characters to be filtered
		for i=0,i_fil-1 do begin
			while strpos(a,fil(i)) ne -1 do $
				strput,a,' ',strpos(a,fil(i))
		endfor
;		Then, ignore the lines with certain string in them
		for i=0,i_ign-1 do begin
			case ign(i) of
			'$TEXT_IN_NUMERIC':if produkt(isnumeric(nameparse(a,delim))) $
					   eq 0 then goto,next_line
			else: if strpos(a,ign(i),0) ne -1 then skip=1
			endcase
		endfor
	endelse
	if strlen(nul) gt 0 then while strpos(a,'null') ne -1 do strput,a,nul,strpos(a,'null')
	if not skip then begin
		if row then begin
			case n_params()-1 of
			 1:reads,a,v1,format=form
			 2:reads,a,v1,v2,format=form
			 3:reads,a,v1,v2,v3,format=form
			 4:reads,a,v1,v2,v3,v4,format=form
			 5:reads,a,v1,v2,v3,v4,v5,format=form
			 6:reads,a,v1,v2,v3,v4,v5,v6,format=form
			 7:reads,a,v1,v2,v3,v4,v5,v6,v7,format=form
			 8:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,format=form
			 9:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,format=form
			10:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,format=form
			11:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,format=form
			12:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,format=form
			13:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,format=form
			14:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,format=form
			15:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,format=form
			16:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,format=form
			17:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,format=form
			18:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,format=form
			19:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,format=form
			20:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,format=form
			21:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,format=form
			22:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,format=form
			23:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,format=form
			24:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,format=form
			25:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,v25,format=form
			26:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,v25,v26,format=form
			27:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,v25,v26,v27,format=form
			28:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,v25,v26,v27,v28,format=form
			29:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,v25,v26,v27,v28,v29,format=form
			30:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,v25,v26,v27,v28,v29,v30,format=form
			31:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,v25,v26,v27,v28,v29,v30,v31,format=form
			32:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,v25,v26,v27,v28,v29,v30,v31,v32,format=form
			33:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,v25,v26,v27,v28,v29,v30,v31,v32,v33,format=form
			34:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,v25,v26,v27,v28,v29,v30,v31,v32,v33,v34,format=form
			35:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,v25,v26,v27,v28,v29,v30,v31,v32,v33,v34,v35,format=form
			36:reads,a,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,v25,v26,v27,v28,v29,v30,v31,v32,v33,v34,v35,v36,format=form
			endcase
		endif else begin
		if line eq 0 then begin
			if strlen(form) ne 0 then begin
				words=nameparse(strupcase(form),',')
				words=words(where(strpos(words,'X') eq -1))
				forms=''
				for i=0,n_elements(words)-1 do begin
					ipos=strpos(words(i),'(')
					jpos=strpos(words(i),')')
					if ipos gt 0 and jpos ge 0 then begin
						n=fix(strmid(words(i),0,ipos))
						sub_forms=nameparse( $
						strmid(words(i),ipos,jpos-ipos),',')
						new_forms=strarr(n)+strjoin(sub_forms)
					endif else new_forms=words(i)
					forms=[forms,new_forms]
				endfor
				words=forms(1:n_elements(forms)-1)
				for i=0,n_elements(words)-1 do begin
				if strpos(words(i),'F') ne -1 then type(i)=4
				if strpos(words(i),'D') ne -1 then type(i)=5
				if strpos(words(i),'I') ne -1 then type(i)=3
				if strpos(words(i),'A') ne -1 then type(i)=7
				endfor
			endif else if produkt(type) eq 0 then begin
				words=nameparse(a,delim)
				for i=0,n_params()-2 do begin
					if type(i) eq 0 then begin
					if isnumeric(words(i)) then begin
					if strpos(words(i),'.') ne -1 then type(i)=5 $
						      	              else type(i)=3
					endif else type(i)=7
					endif
				endfor
			endif
			for i=0,n_elements(words)-1 do begin
				case type(i) of
					1: v=0b
					2: v=0
					3: v=0l
					4: v=0.
					5: v=0.d0
					6: v=complex(0.)
					7: v=''
				endcase
				case i+1 of 
					1: v1=replicate(v,num_lines)
					2: v2=replicate(v,num_lines)
					3: v3=replicate(v,num_lines)
					4: v4=replicate(v,num_lines)
					5: v5=replicate(v,num_lines)
					6: v6=replicate(v,num_lines)
					7: v7=replicate(v,num_lines)
					8: v8=replicate(v,num_lines)
					9: v9=replicate(v,num_lines)
				       10:v10=replicate(v,num_lines)
				       11:v11=replicate(v,num_lines)
				       12:v12=replicate(v,num_lines)
				       13:v13=replicate(v,num_lines)
				       14:v14=replicate(v,num_lines)
				       15:v15=replicate(v,num_lines)
				       16:v16=replicate(v,num_lines)
				       17:v17=replicate(v,num_lines)
				       18:v18=replicate(v,num_lines)
				       19:v19=replicate(v,num_lines)
				       20:v20=replicate(v,num_lines)
				       21:v21=replicate(v,num_lines)
				       22:v22=replicate(v,num_lines)
				       23:v23=replicate(v,num_lines)
				       24:v24=replicate(v,num_lines)
				       25:v25=replicate(v,num_lines)
				       26:v26=replicate(v,num_lines)
				       27:v27=replicate(v,num_lines)
				       28:v28=replicate(v,num_lines)
				       29:v29=replicate(v,num_lines)
				       30:v30=replicate(v,num_lines)
				       31:v31=replicate(v,num_lines)
				       32:v32=replicate(v,num_lines)
				       33:v33=replicate(v,num_lines)
				       34:v34=replicate(v,num_lines)
				       35:v35=replicate(v,num_lines)
				       36:v36=replicate(v,num_lines)
				endcase
				case i+1 of
					 1:	d1=v1(0)
					 2:	d2=v2(0)
					 3:	d3=v3(0)
					 4:	d4=v4(0)
					 5:	d5=v5(0)
					 6:	d6=v6(0)
					 7:	d7=v7(0)
					 8:	d8=v8(0)
					 9:	d9=v9(0)
					10:	d10=v10(0)
					11:	d11=v11(0)
					12:	d12=v12(0)
					13:	d13=v13(0)
					14:	d14=v14(0)
					15:	d15=v15(0)
					16:	d16=v16(0)
					17:	d17=v17(0)
					18:	d18=v18(0)
					19:	d19=v19(0)
					20:	d20=v20(0)
					21:	d21=v21(0)
					22:	d22=v22(0)
					23:	d23=v23(0)
					24:	d24=v24(0)
					25:	d25=v25(0)
					26:	d26=v26(0)
					27:	d27=v27(0)
					28:	d28=v28(0)
					29:	d29=v29(0)
					30:	d30=v30(0)
					31:	d31=v31(0)
					32:	d32=v32(0)
					33:	d33=v33(0)
					34:	d34=v34(0)
					35:	d35=v35(0)
					36:	d36=v36(0)
				endcase
			endfor
		endif
		case n_params()-1 of
			 1:reads,a,d1,format=form
			 2:reads,a,d1,d2,format=form
			 3:reads,a,d1,d2,d3,format=form
			 4:reads,a,d1,d2,d3,d4,format=form
			 5:reads,a,d1,d2,d3,d4,d5,format=form
			 6:reads,a,d1,d2,d3,d4,d5,d6,format=form
			 7:reads,a,d1,d2,d3,d4,d5,d6,d7,format=form
			 8:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,format=form
			 9:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,format=form
			10:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,format=form
			11:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,format=form
			12:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,format=form
			13:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,format=form
			14:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,format=form
			15:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,format=form
			16:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,format=form
			17:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,format=form
			18:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,format=form
			19:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,format=form
			20:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,format=form
			21:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,format=form
			22:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,format=form
			23:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,format=form
			24:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,format=form
			25:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,d25,format=form
			26:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,d25,d26,format=form
			27:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,d25,d26,d27,format=form
			28:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,d25,d26,d27,d28,format=form
			29:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,d25,d26,d27,d28,d29,format=form
			30:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,d25,d26,d27,d28,d29,d30,format=form
			31:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,d25,d26,d27,d28,d29,d30,d31,format=form
			32:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,d25,d26,d27,d28,d29,d30,d31,d32,format=form
			33:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,d25,d26,d27,d28,d29,d30,d31,d32,d33,format=form
			34:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,d25,d26,d27,d28,d29,d30,d31,d32,d33,d34,format=form
			35:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,d25,d26,d27,d28,d29,d30,d31,d32,d33,d34,d35,format=form
			36:reads,a,d1,d2,d3,d4,d5,d6,d7,d8,d9,d10,d11,d12,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,d25,d26,d27,d28,d29,d30,d31,d32,d33,d34,d35,d36,format=form
		endcase
		for i=0,n_params()-2 do begin
			case i+1 of 
				1: v1(line)=d1
				2: v2(line)=d2
				3: v3(line)=d3
				4: v4(line)=d4
				5: v5(line)=d5
				6: v6(line)=d6
				7: v7(line)=d7
				8: v8(line)=d8
				9: v9(line)=d9
			       10:v10(line)=d10
			       11:v11(line)=d11
			       12:v12(line)=d12
			       13:v13(line)=d13
			       14:v14(line)=d14
			       15:v15(line)=d15
			       16:v16(line)=d16
			       17:v17(line)=d17
			       18:v18(line)=d18
			       19:v19(line)=d19
			       20:v20(line)=d20
			       21:v21(line)=d21
			       22:v22(line)=d22
			       23:v23(line)=d23
			       24:v24(line)=d24
			       25:v25(line)=d25
			       26:v26(line)=d26
			       27:v27(line)=d27
			       28:v28(line)=d28
			       29:v29(line)=d29
			       30:v30(line)=d30
			       31:v31(line)=d31
			       32:v32(line)=d32
			       33:v33(line)=d33
			       34:v34(line)=d34
			       35:v35(line)=d35
			       36:v36(line)=d36
			endcase
		endfor
		endelse
		line=line+1
	endif
	next_line:
	recd=recd+1
endwhile
;
if not row then begin
for i=0,n_params()-2 do begin
	case i+1 of
	 1: v1= v1(0:line-1)
	 2: v2= v2(0:line-1)
	 3: v3= v3(0:line-1)
	 4: v4= v4(0:line-1)
	 5: v5= v5(0:line-1)
	 6: v6= v6(0:line-1)
	 7: v7= v7(0:line-1)
	 8: v8= v8(0:line-1)
	 9: v9= v9(0:line-1)
	10:v10=v10(0:line-1)
	11:v11=v11(0:line-1)
	12:v12=v12(0:line-1)
	13:v13=v13(0:line-1)
	14:v14=v14(0:line-1)
	15:v15=v15(0:line-1)
	16:v16=v16(0:line-1)
	17:v17=v17(0:line-1)
	18:v18=v18(0:line-1)
	19:v19=v19(0:line-1)
	20:v20=v20(0:line-1)
	21:v21=v21(0:line-1)
	22:v22=v22(0:line-1)
	23:v23=v23(0:line-1)
	24:v24=v24(0:line-1)
	25:v25=v25(0:line-1)
	26:v26=v26(0:line-1)
	27:v27=v27(0:line-1)
	28:v28=v28(0:line-1)
	29:v29=v29(0:line-1)
	30:v30=v30(0:line-1)
	31:v31=v31(0:line-1)
	32:v32=v32(0:line-1)
	33:v33=v33(0:line-1)
	34:v34=v34(0:line-1)
	35:v35=v35(0:line-1)
	36:v36=v36(0:line-1)
	endcase
endfor
endif
;
free_lun,unit
;
return,0
;
end
;-------------------------------------------------------------------------------
function dc_read_tiff,file,image, $
	imagewidth=width,imagelength=length,colormap=map
;
image=read_tiff(file,r,g,b)
map=[[r],[g],[b]]
;
return,image
;
end
;************************************************************************Block 2
function unique,vector
;
return,vector(uniq(vector,sort(vector)))
;
end
;-------------------------------------------------------------------------------
function unique,vector,ui
;
si=sort(vector)
ui=uniq(vector,si)
return,vector(ui)
;
end
;-------------------------------------------------------------------------------
function avg,x,dim
;
forward_function produkt
;
if n_elements(dim) eq 0 then dim=0
;
result=size(x)
ndim=result(0)
if ndim eq 0 then return,x
if ndim eq 1 and n_elements(x) eq 1 then return,x(0)
if ndim eq 1 and dim eq 1 then return,x
if ndim eq 1 or n_params() eq 1 then return,mean(x)
;
n=result(1+dim)
if dim eq 0 then k=1 else k=produkt(result(1:dim))
l=k*n
result(dim+1)=1
result=reform(make_array(size=result))
m=n_elements(result)
for i=0,m-1 do begin
	index=indgen(n)*k+(i mod k)+(i/k)*l
	result(i)=mean(x(index))
endfor
;
return,result
;
end
;-------------------------------------------------------------------------------
function nint,x,long=long
;
result=size(x) & n=n_elements(result)
;
if keyword_set(long) or result(n-2) eq 5 then return,long(x+0.5*((x gt 0)*2-1)) $
		     			 else return,fix(x+0.5*((x gt 0)*2-1))
;
end
;-------------------------------------------------------------------------------
function linknload,shared_library,function_name, $
	p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	p31,p32,p33,p34,p35,p36,p37,p38,p39,p40, $
	p41,p42,p43,p44,p45,p46,p47,p48,p49,p50
;
case n_params() of
	 2:status=call_external(shared_library,function_name)
	 3:status=call_external(shared_library,function_name, $
	   p1)
	 4:status=call_external(shared_library,function_name, $
	   p1,p2)
	 5:status=call_external(shared_library,function_name, $
	   p1,p2,p3)
	 6:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4)
	 7:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5)
	 8:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6)
	 9:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7)
	10:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8)
	11:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9)
	12:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10)
	13:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11)
	14:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12)
	15:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13)
	16:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14)
	17:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15)
	18:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16)
	19:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17)
	20:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18)
	21:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19)
	22:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20)
	23:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21)
	24:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22)
	25:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23)
	26:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24)
	27:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25)
	28:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26)
	29:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27)
	30:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28)
	31:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29)
	32:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30)
	33:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31)
	34:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32)
	35:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33)
	36:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34)
	37:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35)
	38:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36)
	39:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37)
	40:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37,p38)
	41:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37,p38,p39)
	42:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37,p38,p39,p40)
	43:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37,p38,p39,p40, $
	   p41)
	44:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37,p38,p39,p40, $
	   p41,p42)
	45:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37,p38,p39,p40, $
	   p41,p42,p43)
	46:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37,p38,p39,p40, $
	   p41,p42,p43,p44)
	47:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37,p38,p39,p40, $
	   p41,p42,p43,p44,p45)
	48:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37,p38,p39,p40, $
	   p41,p42,p43,p44,p45,p46)
	49:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37,p38,p39,p40, $
	   p41,p42,p43,p44,p45,p46,p47)
	50:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37,p38,p39,p40, $
	   p41,p42,p43,p44,p45,p46,p47,p48)
	51:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37,p38,p39,p40, $
	   p41,p42,p43,p44,p45,p46,p47,p48,p49)
	52:status=call_external(shared_library,function_name, $
	   p1,p2,p3,p4,p5,p6,p7,p8,p9,p10, $
	   p11,p12,p13,p14,p15,p16,p17,p18,p19,p20, $
	   p21,p22,p23,p24,p25,p26,p27,p28,p29,p30, $
	   p31,p32,p33,p34,p35,p36,p37,p38,p39,p40, $
	   p41,p42,p43,p44,p45,p46,p47,p48,p49,p50)
endcase
;
; Workaround for gconfd error when accessing HDS files
; if strpos(function_name,'cmp_') ge 0 $
; or strpos(function_name,'dat_') ge 0 then wait,0.01
;
return,status
;
end
;************************************************************************Block 3
pro dt_print,dt
;
print,string(dt.month,format='(i2.2)')+'/' $
     +string(dt.day,format='(i2.2)')+'/' $
     +string(dt.year,format='(i4.4)')+'   ' $
     +string(dt.hour,format='(i2.2)')+':' $
     +string(dt.minute,format='(i2.2)')+':' $
     +string(dt.second,format='(f6.3)')
;
end
;-------------------------------------------------------------------------------
pro hak,mesg=message
;
if not keyword_set(mesg) then message='Hit any key to continue...'
;
repeat begin
	c=get_kbrd(0)
endrep until strlen(c) eq 0
;
print,message
r=get_kbrd(1)
;
end
;-------------------------------------------------------------------------------
