;-------------------------------------------------------------------------------
pro npoipipe,con_file
;
; Perform some of the NPOI data reduction, i.e. processing of CONSTRICTOR
; files, in an automatic fashion.
;
common Hds,path,file
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SelDirs,nt_dir,nt_sel,st_dir,st_sel,x_dir,y_dir,z_dir,x_sel,y_sel,z_sel
common PlotDataInfo,plotscans,plotdata_x,plotdata_y,plotdata_y_bck
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common CalInfo,cal_entries
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
pi_circle=!pi
;
; Attempt to calibrate the data
initcal
cal_options.v=0	; Vissq
cal_options.l=1
sel_indct(0)='Time'
sel_funcn(0)='S_80'
;
index=where(startable.bflag eq 'C',count)
if count gt 0 then begin
	cal_stars=startable(index).starid
	print,'Found',count,' listed calibrators:',format='(a,i3,a)'
	print,cal_stars
endif else begin
	print,'Warning: no calibrators listed in startable! No cal. possible'
	return
endelse
;
; Make sure no false coherent scans are present
index=where(total(scantable.station(0:genconfig.numsid-1,*),1) eq 0,count)
if count gt 0 then scantable(index).code=0
;
if init_plot('scan','pt') ne 0 then return
st_dir='All'
; st_sel=startable(k).starid
ds_y.item=25
for ob=0,genconfig.numoutbeam-1 do begin
	ds_y.ob=ob
	ds_y.ch=indgen(genconfig.numspecchan(ob))
	ds_y.bl=indgen(genconfig.numbaseline(ob))
	configs=scanconfig(/coh)
	for i=0,n_elements(configs)-1 do begin
		y_dir.pt=configs(i)
		set_plotsel
		print,'Calibrating configuration ',configs(i)
		calcoeffs,reason
		if strlen(reason) ne 0 then begin
			calibrate,reason
;			wait,1
		endif
	endfor
endfor
index=where(scans.starid eq 'FKV0521' and scantable.code eq 1)
print,reform(scans(index).vissqc(0,*,0))
;
end
