/* Diagonalizes the variance matrix, F, returning the relevant Orthogonal
   matrix, Oth,  and the Eigenvalue vector, W. */

#include <stddef.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#include <fstream>

#include "npoi.h"

int DiagonalCov(double * apCov[], int ndim, int IW, double * apOth[], 
	      double * apW) {

  /* save Covariance Matrix in case you want to check inversion */
  double addum[ndim][ndim];
  for (int i = 0; i < ndim; i++) {
    for (int j = 0; j < ndim; j++) {
      addum[i][j] = apCov[i][j];
    }
  }

  /* more hoops for NR routines */
  double **apdum;
  apdum=(double **) malloc((unsigned) ndim*sizeof(double*)) ;
  for (int i=0; i < ndim; i++) apdum[i] = apCov[i]-1; // offset row for NR
  double **apDOth; 
  apDOth=(double **) malloc((unsigned) ndim*sizeof(double*));
  for (int i=0; i < ndim; i++) apDOth[i] = apOth[i]-1; // offset row for NR
  /* */

  int nrot ; 
  jacobi(apdum-1, ndim, apW-1, apDOth-1, &nrot) ;
  
  return EXIT_SUCCESS;
} 

