/* This takes the Orthogonal matrix, Oth, and Eigenvalue vector, W,
   derived from diagonalizing the original full covarience matrix and
   the dimensions for the subpartitioning and derives the FIxEt matrix
   for the offsets, F - the inverse of the covariance matrix for the new
   points, FO - the orthogonal transformation matrix for F, and FW - the
   eigenvalue vector for F.

   These are used to take statistically independent unit gaussian random
   deviates and transform them into correlated gaussian random variables
   consistent with previously derived members of the distribution. */

#include <stddef.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#include <fstream>

#include "npoi.h"

int FIxEt(double * apOth[], double * W, int ndim, int nshort, int IW, double 
	      * apF[], double * apFOth[], double * apEt[], double * apFW) {

  /* Oth[ndim][ndim], W[ndim], F[M], FO[M], Et[M][nshort], FW[M] */
  int M = ndim - nshort;
  double addum[M][M], addum2[M][nshort], daccum; 

  /* Calculate F and Et*/

  for (int i = nshort; i < ndim; i++) {
    int m = i - nshort ;
    for (int j = 0; j < ndim; j++) {
      int n = j - nshort ;
      daccum=0. ;
      for (int k = 0; k < ndim; k++) {
	daccum += apOth[i][k] * apOth[j][k] / W[k] ;
      }
      if (n >= 0) {
	addum[m][n] = daccum; // F
	apF[m][n] = daccum ; // F
      }
      else {
	addum2[m][j] = daccum ; // Et
      }
    }
  }
  
  /* Diagonalize F */
  /* hoops for NR routines */
  double **apdum, **bpFOth; int nrot ;
  apdum=(double **) malloc((unsigned) M*sizeof(double*)) ;
  for (int i=0; i < M; i++) apdum[i] = addum[i]-1; // offset for NR
  bpFOth=(double **) malloc((unsigned) M*sizeof(double*));
  for (int i=0; i < M; i++) bpFOth[i] = apFOth[i]-1;
  /* */
  
  jacobi(apdum-1, M, apFW-1, bpFOth-1, &nrot) ;
  
  /* Invert F */
  double addum3[M][M];
  for (int i = 0; i < M; i++) {
    for (int j = 0; j < M; j++) {
      addum3[i][j]=0. ;
      for (int k = 0; k < M; k++) {
	addum3[i][j] += apFOth[i][k] * apFOth[j][k] / apFW[k] ; // =F^-1
      }
    }
  }
  
  /* [1/F]*[Et] */
  for (int i = 0; i < M; i++) {
    for (int j = 0; j < nshort; j++) {
      apEt[i][j] = 0. ;
      for (int k = 0; k < M; k++) {
	apEt[i][j] += addum3[i][k]*addum2[k][j] ;
      }
    }
  }
  return EXIT_SUCCESS;
}
