/* For the moment, this is just to shake down the Multi-Ro wavefront
   calculation.  */

#include <stddef.h>
#include <stdlib.h>
#include <fstream.h>
#include <math.h>

#include "npoi.h"

extern PhScreen PS;
extern Array A; 
extern Aperture AP;

int GetMultiRoData(int iT) {

  /* While debugging Multi-Ro, leave most of this in place.*/

  // various things to define where in the dither you are and where in the 
  // Ro interval.
  float fTOff, foff; int i1, i2, ip; 
  int iNA = A.iNArray, iA;
  int iNxy = AP.iNxy;
  float afWF[iNA][AP.iNxy], afDWFX[iNA][AP.iNxy], afDWFY[iNA][AP.iNxy];

  /* This allows the subroutines to initialize the arrays. */
  if (iT == 0) {
    if (GetWaveFront(0, 0., iT, afWF[0], afDWFX[0], afDWFY[0]) 
	== EXIT_FAILURE) return (EXIT_FAILURE);
    return (EXIT_SUCCESS);
  }

  int IfWrite = 0;
  if ((iT/1000)*1000 == iT) IfWrite = 1;

  if ((iT/100)*100 == iT) cout << "iT=" << iT << endl;
  /* Forget the fancy stuff, let's just debug the routines! */
  fTOff = 0.;
  //for (int iTOff = 0; iTOff < 2; iTOff++) {
  //fTOff = -0.5 + iTOff * 0.5;
    for (iA = 0; iA < iNA; iA++) {
      if (GetWaveFront(iA, fTOff, iT, afWF[iA], afDWFX[iA], afDWFY[iA])
	  == EXIT_FAILURE) return EXIT_FAILURE;

      if (IfWrite) {
	cout << "For Array Member=" << iA << endl;
	for (int iap = 0; iap < iNxy; iap++) {
	  cout << iap << " DelX=" << AP.afXYOffset[iap][0]
	       << " DelY=" << AP.afXYOffset[iap][1] << " Z(mu)=" 
	       << afWF[iA][iap] << " DZ/DX(mu/m)=" << afDWFX[iA][iap] 
	       << " DZ/DY(mu/m)=" << afDWFY[iA][iap] << endl;
	}
      } // end IfWrite

    }
    //} // for iTOff
  return(EXIT_SUCCESS) ;
}
