/* This Initializes the respective structures.*/

#include <stddef.h>
#include <stdlib.h>
#include <time.h>

#include <fstream>
#include <complex>

#include "npoi.h"

Seed S;

extern PhScreen PS;
extern Seed S;

int Init (long int LS) {

  if (InitGeometry () == EXIT_FAILURE) return (EXIT_FAILURE) ;
  if (InitPhaseScreen () == EXIT_FAILURE) return (EXIT_FAILURE) ;
  if (InitAperture () == EXIT_FAILURE) return (EXIT_FAILURE) ;
  if (InitArray () == EXIT_FAILURE) return (EXIT_FAILURE) ;
  /* Will need splines eventually */
  //  if (InitSpline() == EXIT_FAILURE) return (EXIT_FAILURE) ;

  S.lseed = LS ;
  S.lidum = -LS ;
  if (LS == 0) {
    // Use system clock to set seed
    time_t tp ; 
    tp = time(NULL) ; 
    S.lseed= tp ;
    S.lidum=-tp ;
  }
  cout << "Seed: " << S.lseed << endl ; // Leave a message
  ofstream fouts("seedfile") ;
  if (fouts.is_open()) fouts << S.lseed << endl ;
  fouts.close() ;
  
  // prime the random number generator
  ran1(&(S.lidum)) ;
  
  return(EXIT_SUCCESS) ;
}
