/* Initializes the matrices that will generate the correlated random
   variables for the initial window, the matrices to step the window
   along, one mirror diameter (actually AP.iNR0*PS.fRo) at a time, the
   matricies to subdivide the mirror diameter steps down to the Ro level
   for each mirror's wavefront train individually and the matrices that
   will subdivide the Ro steps down to Ro/8 (as currently wired).

   Unlike the zero diameter mirror case before, we no longer store the
   whole cardinal Ro step array, only just those needed to generate the
   next mirror diameter step. */

#include <stddef.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#include <fstream>

#include "npoi.h"
extern PhScreen PS;
extern Array A;
extern Seed S;
extern Aperture AP;

int InitArray() {

  int IfWrite = 0; // For diagnostic writes
  PS.fDelTRo = PS.fRo / 
    sqrt(PS.fWVelX * PS.fWVelX + PS.fWVelY * PS.fWVelY) ;

  /* For the moment, send back values interpolated from the 1Ro grid */
  PS.iNSubdivide = 1;

  /*  if (fabs(PS.fDelTRo - PS.fDelT)/(PS.fDelTRo + PS.fDelT) <= 1.e-6) 
      PS.iIfInterp = 0; */

  //PS.iInterpOffset = 3; // How far ahead you have to keep Ro step
  PS.iNAdvance = 3; // Similiar to ^, but for subdividing larger than Ro

  /* Next, calculate the coarse grid window index and Ro spacing. */
  PS.iNDiam = (int) (AP.fDiameter / PS.fRo + 0.01) + 2;
  if ((PS.iNDiam/2)*2 == PS.iNDiam) PS.iNDiam++ ; // force iNDiam to be odd
  if (AP.fDiameter <= 0.) PS.iNDiam = 1; // for zero diameter case
  
  /* Distance between the two sets of coarse points bracketing the
     mirrors. */
  PS.fOutline = PS.fRo * (PS.iNDiam - 1) ; 
  
  /* Windows for various step levels.  This is the first point where you
     need to know which is larger, iNDiam or iNWindow.  */
  int iND1 = PS.iNDiam - 1;
  if (PS.iNDiam > 1) {
    PS.iNSubDWindowI = 2 + PS.iNAdvance;
    PS.iNSubDWindow = 1 + PS.iNAdvance;
    PS.iNEffWindow = (PS.iNDiam > PS.iNWindow) ? PS.iNDiam : PS.iNWindow; 
    PS.iNEffWindow = ((PS.iNEffWindow+1)/2)*2; // an even number
    PS.iNEffWindowI = ((PS.iNEffWindow + PS.iNAdvance)/2)*2 ; // For 1Ro
    PS.iN2RoNWindow = PS.iNEffWindow/2 ; // For N: No lead interval
    PS.iN2RoIWindow = PS.iNEffWindowI/2 + PS.iNAdvance ; // first interval
    PS.iNSteps = ((PS.iN2RoIWindow - 1)* 2) / iND1 + 1 + PS.iNAdvance;
    if (PS.iNAdvance * 2 < PS.iNEffWindow) 
      PS.iNEffWindow = PS.iNAdvance * 2; // Keep Ro window size reasonable
  }
  else {
    PS.iNEffWindow = PS.iNWindow;
    PS.iNEffWindowI = 0;
    PS.iN2RoNWindow = 0;
    PS.iN2RoIWindow = 0;
    PS.iNSteps = PS.iNWindow + PS.iNAdvance;
  }
  if (PS.iNSteps < 5) PS.iNSteps = 5;

  /* First set up the coarse steps about a mirror diameter per step,
     with tracks bracketing the mirror diameter.  This is essentially
     the same problem as the 1-Ro subdivision, below, but does the whole
     array and is careful of the wind angle in defining relative
     locations. */

  cout << "Coarse Initialization " << endl;
  if (InitCoarseArray() == EXIT_FAILURE) return EXIT_FAILURE;

  /* Next do the division from the Coarse Step (1 mirror diameter) spacing
     down to the 2-Ro spacing.  This can be a "divide by 6" step and is not
     particularly optimal. */

  cout << "2Ro Initialization " << endl;
  if (Init2RoArray() == EXIT_FAILURE) return EXIT_FAILURE;

  /* Next do the division from 2Ro resolution down to the Ro.  This does
     two whole columns at a time and is also not particularly optimal. */

  cout << "Ro Initialization " << endl;
  if (InitRoArray() == EXIT_FAILURE) return EXIT_FAILURE;


  return (EXIT_SUCCESS) ;
}
