/* ---------------------------------------------------------------------
   Initializes the matrices that will generate the correlated random
   variables for the initial window spaced at one mirror diameter and
   the matrices to step the window along, one mirror diameter (actually
   (PS.iNDiam-1)*PS.fRo) at a time. 

   This is the only resolution level that needs to know where the other
   elements are and which directions are really x and y.
   --------------------------------------------------------------------- */

#include <stddef.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#include <fstream>

#include "npoi.h"
extern PhScreen PS;
extern Array A;
extern Aperture AP;

int InitCoarseArray() {

  int IfWrite = 0; // for diagnostic output
  /* Set up the phase screen, diagonalize the variance matrix,
     etc. for the width of the coarse step window. */
  
  /* Then, set up the Covariance matrix for the window. */
  
  /* Note index mapping: we run through the array at one time step and 
     then up the time and run through the array again, etc.  
     This allows us to use the same matrix to first, generate the first 
     N time steps for the full array, and subsequently to use derivatives 
     of that matrix to evolve the phase screen, one time step at a time. */
  
  double vwind = sqrt(PS.fWVelX*PS.fWVelX+PS.fWVelY*PS.fWVelY);
  double dxwind = PS.fWVelX * PS.fDelTRo * (float) (PS.iNDiam - 1) ;
  double dywind = PS.fWVelY * PS.fDelTRo * (float) (PS.iNDiam - 1) ;
  int iNB = 2; // Bracket either side of the mirrors
  double radius = PS.fOutline / 2. ;
  double fOffx = PS.fWVelY / vwind * radius ;
  double fOffy = - PS.fWVelX / vwind * radius ; 
  if (PS.iNDiam == 1) {
    iNB = 1; // Unless the zero diameter case
    fOffy = 0;
    fOffx = 0;
  }
  double afx[6][2], afy[6][2];
  int iNS = PS.iNSteps, iNA = A.iNArray, ndim = iNS * iNA * iNB - 1 ; 
  for (int ia = 0; ia < iNA; ia++) {
    afx[ia][0] = A.afx[ia] + fOffx ;
    afx[ia][1] = A.afx[ia] - fOffx ;
    afy[ia][0] = A.afy[ia] + fOffy ;
    afy[ia][1] = A.afy[ia] - fOffy ;
  }
  double addum[ndim][ndim], afxdt, afydt;
  /* */
  for (int ks = 0; ks < iNS; ks++) { // = diameter time Steps
    for (int mb = 0; mb < iNB; mb++) { // = Bracket mirror
      for (int ia = 0; ia < iNA; ia++) { // = Array element
	int imk = ia + mb * iNA + ks * iNA * iNB ;
	double dxn = afx[ia][mb] + dxwind * ks - afx[0][0] ;
	double dyn = afy[ia][mb] + dywind * ks - afy[0][0] ;
	double dxn2yn2p = StructFn(dxn,dyn) ;
	for (int ls = 0; ls < iNS; ls++) {
	  for (int nb = 0; nb < iNB; nb++) { 
	    for (int ja = 0; ja < iNA; ja++) {
	      int jnl = ja + nb * iNA + ls * iNB * iNA ; 
	      if (jnl > 0 && imk > 0) {
		if (imk == jnl)  {
		  PS.adCSCov[imk-1][imk-1] = dxn2yn2p ;
		  addum[imk-1][imk-1] = dxn2yn2p ;
		}
		else {
		  double dxm = afx[ja][nb] + dxwind * ls - afx[0][0] ;
		  double dym = afy[ja][nb] + dywind * ls - afy[0][0] ;
		  double dxm2ym2p = StructFn(dxm,dym) ;
		  double dxnm = dxn - dxm ;
		  double dynm = dyn - dym ;
		  double dxnm2ynm2p = StructFn(dxnm,dynm) ;
		  PS.adCSCov[imk-1][jnl-1] = (dxn2yn2p+dxm2ym2p-dxnm2ynm2p)/2.;
		  addum[imk-1][jnl-1] = PS.adCSCov[imk-1][jnl-1] ;
		}
	      }
	    }
	  }
	}
      }
    }
  }
  
  /* Now, diagonalize the matrix.  We use the Jacobi Transformation method, 
     which is not the fastest but reliable. */

  { double ** apCSCov, ** apCSOth;
  apCSCov=(double **) malloc((unsigned) ndim*sizeof(double*)) ;
  for (int i=0; i < ndim; i++) apCSCov[i] = addum[i]; // Set pointers for call
  apCSOth=(double **) malloc((unsigned) ndim*sizeof(double*)) ;
  for (int i=0; i < ndim; i++) apCSOth[i] = PS.adCSOth[i]; // and for return

  if (DiagonalCov(apCSCov, ndim, IfWrite, apCSOth, PS.adCSW) 
      == EXIT_FAILURE) return EXIT_FAILURE;
  } // storage scoping
  
  /* Calculate the "E" and "F" matricies needed to single step the 
     screen after the initial "NWindow" steps. */
  
  /* Make sure there's a calculation to do */
  if (iNS > 1) { 
    int iNAB = iNA * iNB, nshort = iNAB * (iNS - 1) - 1, M = ndim-nshort ; 
    
    /* Set pointers for matrices going in and coming back. */
    {double **apOth, **apFOth, **apF, **apEt; 
    apOth=(double **) malloc((unsigned) ndim*sizeof(double*));
    for (int i=0; i < ndim; i++) apOth[i] = PS.adCSOth[i]; // Orthogonal in
    apFOth=(double **) malloc((unsigned) M*sizeof(double*));
    for (int i=0; i < M; i++) apFOth[i] = PS.adCSFOth[i]; // Orthogonal in
    apF=(double **) malloc((unsigned) M*sizeof(double*));
    for (int i=0; i < M; i++) apF[i] = PS.adCSF[i]; // Orthogonal in
    apEt=(double **) malloc((unsigned) M*sizeof(double*));
    for (int i=0; i < M; i++) apEt[i] = PS.adCSEt[i]; // Orthogonal in
    
    if (FIxEt(apOth, PS.adCSW, ndim, nshort, IfWrite, apF, apFOth, apEt, 
	      PS.adCSFW) == EXIT_FAILURE) return (EXIT_FAILURE);
    } // storage scoping
  } // iNS > 1

  return EXIT_SUCCESS;
}
