/* Initializes the Array Geometry. */

#include <stddef.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#include <fstream>

#include "npoi.h"
Array A; extern Array A;

int InitGeometry() {

  char cdum[100];

  /* See if there's an Array Geometry file */
  ifstream fin("geometry") ; 
  if (fin.is_open()) {
    int k;
    fin >> cdum >> A.iNArray ;
    for (int i =0; i < A.iNArray; i++) {
      fin >> k
	  >> cdum >> A.afx[i] 
	  >> cdum >> A.afy[i] ; // Physical Layout (meters) ;
      if (fin.eof()) { 
	cout << "GEOMETRY: array dimension not correct!!"
	     << endl ;
	return (EXIT_FAILURE) ;
      }
      if (i != k) { 
	cout << "GEOMETRY: array indices are out of sequence!"
	     << endl ;
	return (EXIT_FAILURE) ;
      }
    }
    fin.close() ;
  } 
  else {  // Initialize to some test value
    A.iNArray=6 ; // Number of array telescopes
    A.afx[0]=-.8660254;     A.afy[0]=1.; //(x,y)'s of telescopes
    A.afx[1]=-1.7320508;    A.afy[1]=2.;
    A.afx[2]=-3.4641016;    A.afy[2]=4.;
    A.afx[3]=0.8660254;    A.afy[3]=1.;
    A.afx[4]=1.7320508;    A.afy[4]=2.;
    A.afx[5]=3.4641016;    A.afy[5]=4.; // meters

    /* In this case, write out what we've used. */
    ofstream fout("geometry") ;
    if (fout.is_open()) {
      fout << "NumInArray " << A.iNArray << endl ;
      for (int i = 0; i < A.iNArray; i++) {
	fout << i ;
	fout << " x " << A.afx[i] 
	     << " y " << A.afy[i] << endl ;
      } 
    }
    fout.close() ;
  }
  return (EXIT_SUCCESS);
}
