/* Initializes the Phase Screen calculation. */

#include <stddef.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#include <fstream>

#include "npoi.h"
PhScreen PS; extern PhScreen PS;

int InitPhaseScreen() {

  char cdum[100];

  /* Initialize Phase Screen information. */

  /* Look for a Phase Screen file */
  ifstream finS("screen"); 
  if (finS.is_open()) {
    finS >> cdum >> PS.iNWindow 
	 >> cdum >> PS.fWVelX 
	 >> cdum >> PS.fWVelY 
	 >> cdum >> PS.fDelT 
	 >> cdum >> PS.fRo ;
    //	 >> cdum >> PS.iIfDither ;
    finS.close() ;
  }
  else {
    PS.iNWindow = 10; // one shot, no shifting
    PS.fWVelX = 0.; // m/s in X
    PS.fWVelY = 10.; // m/s in Y
    PS.fDelT = 0.01; // 10 milliseconds
    PS.fRo = 0.1; // 10 cm at 550 nm
    //PS.iIfDither = 1; // Sample wavefront differently at diff wavelengths

    /* In this case, write out what we're going to use */
    ofstream foutS("screen") ;
    if (foutS.is_open()) {
      foutS << " NWindow " << PS.iNWindow
	    << " WindVelX " << PS.fWVelX 
	    << " WindVelY " << PS.fWVelY 
	    << " DelTime " << PS.fDelT 
	    << " Ro " << PS.fRo ;
      //    << " If-Dither " << PS.iIfDither << endl ;
    }
    foutS.close() ;
  }

  /* Some useful related numbers. */
  PS.fWVel = sqrt(PS.fWVelX*PS.fWVelX+PS.fWVelY*PS.fWVelY);
  PS.fDelR = PS.fDelT * PS.fWVel;

  /* Maximum X dimensions for intermediate storage. */
  PS.iCSZMaxX = 20; // in iNDiam-1 units
  PS.i2RoZMaxX = 20; // in 2-Ro units
  PS.iRoZMaxX = 50; // in Ro
  PS.iSubDZMaxX = 120; // Currently held at highest level of resolution

  return (EXIT_SUCCESS) ;
}
