/* Initializes the Spline Derivative/Interpolation routines. 
   Requires Ro be available (ie, Phase Screen already initialized). */

#include <stddef.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#include <fstream>

#include "npoi.h"

Spline SpInit, Sp; 

//int InitSpline(PhScreen * PS, Spline * Sp, Spline * SpInit) {
extern Spline SpInit, Sp;
extern PhScreen PS;
int InitSpline() {

  if (PS.fRo) {
    cout << "Phase Screen Initialization must be done before Spline!" << endl;
    return(EXIT_FAILURE);
  }

  /* Defines: SpInit->afDM[], afDP[], afW[], afUI[], afB[] */

  /* Spline coefficients for first interval. */
  //SpInit.iNSpline = PS.i1NIPoints; // Index for first interval
  SpInit.iNSpline = 8; // Index for first interval
  //SpInit.fH = PS.fRo / PS.iNSubdivide; // Already subdivided by iNS
  SpInit.fH = PS.fRo / 8; // Already subdivided by iNS
  if (sderup(&SpInit) == EXIT_FAILURE) {
    cout << "SDERUP failed for SpInit!" << endl;
    return(EXIT_FAILURE);
    }

  //Sp.iNSpline = PS.inNIPoints; // Index for other intervals
  //Sp.fH = PS.fRo / PS.iNSubdivide; // Already subdivided this much
  Sp.iNSpline = 11; // Index for other intervals
  Sp.fH = PS.fRo / 8; // Already subdivided this much
  if (sderup(&Sp) == EXIT_FAILURE) {
    cout << "SDERUP failed for Sp!" << endl;
    return(EXIT_FAILURE);
  }

  return(EXIT_SUCCESS);
}
