/* -----------------------------------------------------------------------
   This resets the critical indicies, preparing a calculation for a new 
   "realization".  Note, this worries only about dynamic issues.  In 
   particular, it assumes all the geometry-dependent matricies, etc, are 
   defined only once at the beginning and not every realization.
   ---------------------------------------------------------------------*/

#include <stddef.h>
#include <stdlib.h>

#include <fstream>

#include "npoi.h"

int Reset(PhScreen * PS, Array * A) {

  /* Zeros the handshaking indices. */
  PS->iWFNeededRo = 1; // This primes the Subdivide calculation 
  PS->iSubDNeededRo = 0;
  PS->iRoNeededRo = 0;
  PS->i2RoNeededRo = 0;
  PS->iSubDLastCalcRo = 0;
  PS->iRoLastCalcRo = 0;
  PS->i2RoLastCalcRo = 0; 
  PS->iCSLastCalcRo = 0;
  PS->iWFFirstRo = 0; 
  PS->iSubDFirstRo = 0;
  PS->iRoFirstRo = 0;
  PS->i2RoFirstRo = 0;
  PS->iCSFirstRo = 0;
  PS->iSubDLastTakenRo = 0;
  PS->iRoLastTakenRo = 0;
  PS->i2RoLastTakenRo = 0;
  PS->iCSLastTakenRo = 0;
  
  /* Cleans up the spline integration storage. 
  for (int i = 0; i < A->iNArray; i++) {
    for (int j = 0; j < PS->inNIPoints; j++) {
      PS->afIZ[i][j] = 0.;
      PS->afIDZ[i][j] = 0.;
    }
    }*/
  return(EXIT_SUCCESS); // that should do it!
}

