/* Calculates the atmospheric "Structure Function".  Currently written
   to do the pure Kolmogorov spectrum.  But any legit Structure Function
   could go here.  

   This assumes Ro is given for 550 nm.  Returns the variance in units
   of mu^2 (! - This is a change from the zero-Ro code). */

#include <stddef.h>
#include <stdlib.h>
#include <math.h>
#include <fstream>

#include "npoi.h"
extern PhScreen PS;

/* This version works in general (x,y) coordinates (units: meters). */
double StructFn(double dx, double dy) {

  static double alpha; const double FiveSixths = 5./6.;
  static int iFinit = 1;
  /* The scaling factor is alpha = 6.88/(k^(6/5) * Ro)^(5/3) 
     where k = 2pi / lambda */
  
  //cout << "StructFn: ";
  if (iFinit) {
    alpha = 6.88 / (TWOPI/550.e-9*TWOPI/550.e-9 * pow(PS.fRo, 5./3.));
    alpha *= 1.e12 ; // Convert from m^2 to mu^2
    //cout << "alpha " << alpha << endl;
    iFinit = 0;
  }
  //double var = alpha * pow((dx * dx + dy * dy), FiveSixths);
  //cout << "alpha " << alpha << " var " << var << endl;
  //return (var);
  return (alpha * pow((dx * dx + dy * dy), FiveSixths));
}


/* This version works in units of Ro, but returns covariances in mu^2.

   Convenient when you know the distance rather than the coordinates. */
double StructFnRo(double r) {

  static double alpha; const double FiveThirds = 5./3.;
  static int iFinit = 1;
  /* The scaling factor is alpha = 6.88/(k^(6/5) * Ro)^(5/3)
     (= 6.88/k^2 when Ro = 1), where k = 2pi / lambda */
  
  //cout << "StructFnRo: ";
  if (iFinit) {
    alpha = 6.88 / (TWOPI/.550*TWOPI/.550); // units of mu^2
    iFinit = 0;
  }
  //double var = alpha * pow(r, FiveThirds);
  //cout << "alpha " << alpha << " var " << var << endl;
  //return (var);
  return (alpha * pow(r, FiveThirds));
}
