/* ---------------------------------------------------------------------
   Steps along the time series for the array phase screen realization.
   This divides the Ro, steps down fairly rigorously.  Cubic spline
   interpolation provides the X,Y derivatives at the tabulated points.
   SOME DAY!

   For the moment, just dividing by 1. 

   Note we are now passing most of the structures as external variables
   *except* the PhaseScreen.  If we decide to do multi-layer Phase
   Screens, this will make it easy.
   -------------------------------------------------------------------*/

#include <stddef.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#include <fstream>

#include "npoi.h"

extern Spline SP, SPINIT; 
//extern PhScreen PS;
extern Array A;
extern Seed S; // Needed to pass around the RNG seed.
extern Aperture AP;

int SubdivideRo(PhScreen * PS) {

  int iNA = A.iNArray, iND = PS->iNDiam, iND1 = iND-1, 
    iNDSD1 = iND1 * PS->iNSubdivide;

  int IfWrite = 0;
  if (IfWrite) {
    cout << "In Subdivide - HandShaking Summary: " 
	 << " iSubDLastCalcRo: " << PS->iSubDLastCalcRo << endl;
    cout << "iSubDLastTakenRo: " << PS->iSubDLastTakenRo 
	 << " iSubDFirstRo: " << PS->iSubDFirstRo 
	 << " iWFNeededRo: " << PS->iWFNeededRo 
	 << " iRoLastCalcRo: " << PS->iRoLastCalcRo << endl << endl;
  } // end IfWrite

  /* Eventually, when we implement a real division and use spline
     interpolation again, we will want to be one full interpolated Ro
     cycle ahead of where we're getting values.  And in general we will
     add a new Ro column for interpolating only when we have iNAdvance
     (=3) full columns out in front to tie to.  So, our minimum (and
     initial) "Need" is 1 (current) + 1 (interpolated but ahead of where
     we are) + 3 (to tie to) Ro columns = 5.  After that we need to be 4
     columns ahead of where we're working. */

  PS->iSubDNeededRo = PS->iNSubDWindow + PS->iWFNeededRo;
  if (PS->iSubDLastCalcRo == 0 && PS->iNSubDWindowI > PS->iSubDNeededRo) 
    PS->iSubDNeededRo = PS->iNSubDWindowI;

  /* Send it up to make sure it's ready. */
  if (PS->iSubDNeededRo > PS->iRoLastCalcRo || PS->iRoLastCalcRo == 0) {
    if (GetRoStep(PS) == EXIT_FAILURE) return (EXIT_FAILURE);
    if (IfWrite) {
      cout << "Back from GetRoStep - HandShaking Summary: " << endl;
      cout << "iSubDLastCalcRo: " << PS->iSubDLastCalcRo 
	   << " iSubDLastTakenRo: " << PS->iSubDLastTakenRo << endl;
      cout << "iSubDFirstRo: " << PS->iSubDFirstRo 
	   << " iWFNeededRo: " << PS->iWFNeededRo 
	   << " iRoLastTakenRo: " << PS->iRoLastTakenRo << endl << endl;
    } // end IfWrite
  }

  /* Bring in new data if needed */
  if (!PS->iSubDLastCalcRo) PS->iSubDLastCalcRo--; // force n=0 calculation
  while ( PS->iSubDLastCalcRo < PS->iWFNeededRo) {
    int iSDLC = PS->iSubDLastCalcRo + 1;
    if (iSDLC > PS->iRoLastCalcRo) {
      cout << "iSDLC > PS->iRoLastCalcRo " << iSDLC << " "
	   << PS->iRoLastCalcRo << endl;
      return EXIT_FAILURE;
    }
    int iRLCx = iSDLC - PS->iRoFirstRo; // data window
    int iSDLCx = (iSDLC - PS->iSubDFirstRo) * PS->iNSubdivide;
      for (int iA = 0; iA < iNA; iA++) {
	for (int iy = 0; iy < iND; iy++) {
	  int iY = iy * PS->iNSubdivide;
	  PS->afSubDZayx[iA][iY][iSDLCx] = PS->afRoZayx[iA][iy][iRLCx];
	}
	
	IfWrite = 0;
	if (IfWrite) {
	  /* Write out filled Subdivided grid */
	  cout << "iA=" << iA << " Subdivide Grid" << endl
	  << "iSubDFirstRo=" << PS->iSubDFirstRo 
	  << " iSubDLastCalcRo=" << iSDLC << endl
	  << "ix N(iy afSubDZayx)" << endl;
	  for (int ix = 0; ix <= iSDLCx + 5; ix++) {
	    cout << ix ;
	    for (int iy = 0; iy < iNDSD1 + 1 ; iy++) {
	      cout << " " << iy << " "<< PS->afSubDZayx[iA][iy][ix];
	    }
	    cout << endl;
	  }
	} // end IfWrite
	
      }
    PS->iRoLastTakenRo = iSDLC;
    PS->iSubDLastCalcRo = iSDLC; // Change this when interpolating
  }

  /* HouseKeeping */
  /* Check if we can shed some stored data */
  if (PS->iSubDLastTakenRo - PS->iSubDFirstRo > iND1) { 
    /* Apparently we should! */
    //cout << "*** Subdivide Housekeeping! ***" << endl;
    for (int ia = 0; ia < iNA; ia++) {
      for (int iy = 0; iy < iNDSD1 + 1; iy++) {
	for (int is = iNDSD1; is < PS->iSubDZMaxX; is++) {
	  PS->afSubDZayx[ia][iy][is-iNDSD1] = PS->afSubDZayx[ia][iy][is];
	}
	for (int is = 0; is < iNDSD1; is++) {
	PS->afSubDZayx[ia][iy][PS->iSubDZMaxX-is] = 0.; // Keep things clean
	}
      }
    }
    PS->iSubDFirstRo += iND1;
  }

  IfWrite = 0;
  if (IfWrite) {
    cout << "Leaving: Subdivide - HandShaking Summary: " 
	 << " iSubDLastCalcRo: " << PS->iSubDLastCalcRo << endl;
    cout << "iSubDLastTakenRo: " << PS->iSubDLastTakenRo 
	 << " iSubDFirstRo: " << PS->iSubDFirstRo 
	 << " iWFNeededRo: " << PS->iWFNeededRo << endl << endl;
  }
  
  return (EXIT_SUCCESS) ;
}
