/* This tests the main simulation function for the Multi-Ro NPOI
   simulations.*/

#include <stddef.h>
#include <stdlib.h>
#include <time.h>

#include <fstream>
#include <complex>

#include "npoi.h"

extern PhScreen PS ; 
extern Array A ; 

int main(int iargc, char *acargv[]) { 
/* Command line arguments:
   0: is the program name
   1: random number generator seed.  NULL or =0 if want a new one 
*/

  long int lseed ; 
  lseed=0l ;
  if (iargc > 1 ) lseed = atoi(acargv[1]) ;
  //cout << "Arguments: " << iargc << "lseed: " << lseed << endl ;
  
  if (Init(lseed) == EXIT_FAILURE) {
    cout << "Init failed to Initialize - Exiting" << endl;
    return (EXIT_FAILURE) ;
  }
  int nrealz = 10001, in = -1 ;

  /* Now, run the array "nrealz" times */

  time_t tp1; 
  //    time(&tp1) ; // This works
  tp1 = time(NULL) ; // measure time involved
  
  for (int n = 0; n < nrealz; n++){
    if (GetMultiRoData (n) == EXIT_FAILURE) return EXIT_FAILURE ;
  }
  
  cout << "Elapsed time: "<< time(NULL)-tp1 << endl ;  
  return(EXIT_SUCCESS) ; 
}

