/*

  atmosphere.cpp

  This is a wrapper for Deane's atmosphere code.
  ========================================================*/

class atmosphere
{
public:

  atmosphere (  config *pConfig ) ;
  float piston( int iStation, double fTime ) ;
  void getWF( int iStation, double fTime, float *pfWF ) ;
  void testAtmos( void) ;

private:
  int iOff ;         /* set if the atmosphere should be turned off */
  int iNumPts ;     /* number of points in the aperture */
  int iStations ;   /* number of stations */
  float fLastTime ; /* The last (latest) time requested from the atmosphere. */
  double fDeltaT ;  /* Time interval between samples */
  long int lseed ;  /* Seed for random number generator */

  float **pfWF, **pfDWFx, **pfDWFy ;  /* data area for wavefront and derivatives */

} ;
