/*=========================================================
  combiner.hpp

  Simulatior for the beam combiner.

  This is a multi-wavelength, multi-bin, time modulated fringe
  detection algorithm.

  The default unit of length is microns.
  The default unit of time is milliseconds.
  ====================================================*/

class combiner
{
public :
  combiner (  config *pConfig, fdl **pFdl, atmosphere *pA,
	      int *piStationList ) ;
  int **getData( float fTime, int **piData ) ;
  void getWavelengths ( float *pfWave, int *piNumWaves ) ;
  void showData ( int **piData ) ;
  void plotBins ( int **piData ) ;
  void combiner::showBinMap ( void ) ;

private :
  void getI(float fTime, float **pfData ) ;
  void setBinMap(float fStroke) ;
  void setBinDurations(float fStroke) ;

  /* configuration variables.  */

  int iNumApPoints ; /* number of integration points across aperture */
  int iNumStations ; /* stations contributing light to this output */
  int iNumTicks ;    /* number of clock ticks per sample time */
  int iNumBins ;     /* Number of bins */
  int iNumWaves ;    /* Number of Wavelengths in spectrograph */
  float fSTime ;     /* Sample time -- over which binning is done */
  float fClock ;     /*  time per clock tick */

  float fTimeDelay ; /* Delay between the start of the data accumulation period
			and the time the data is delivered to the system */
  float *pfWave ;    /* wavelength for each bin */
  int **piBinMap ;   /* Map of which bins are turned on at which times */
  int *piStn ;       /* list of stations that contribute to this combiner */
  float ***pfBin ;   /* Start and end times of bins on up and down stroke */
  float **pfD    ;   /* temp storage for delay line values */
  float ***pfWF ;    /* temp storage for wavefront delays */

  /* Access to other parts of the instrument */

  fdl **pFDL ;
  atmosphere *pAtm ;

  /* Source/atmosphere stuff */

  float *pfDark ;  /* dark counts at each wavelength */
  float **pfI0 ;   /* Counts per wavelength, aperture */
  float ***pfVis ; /* Raw visibility amplitude at each baseline, waveln */

  /* temp storage so it doesn't have to be continually allocated and
     deallocated. */

  float **pfData ;
  float *pfDelay ; 

} ;
