/*=========================================================
  config.hpp

  Configuration class for the npoi data simulator

  ====================================================*/

typedef enum configType { NONE, NPOI, MRO, TEST } ;



class config
{
public :
  config ( configType  eType ) ;
  void getWavelengths ( float *pfWaves ) ;
  int getBins( void) ;
  int getWaves( void) ;
  int getStations( void) ;
  void getStationList ( float *pfX, float *pfY ) ;
  float getApSize( void) ;
  int getNumApPts( void) ;
  void getApPtList( float *pfX, float *pfY ) ;
  float getStroke( void) ;
  void getModAmps ( int *piAmps ) ;
  void getStarInfo( float **pfI0, float ***pfVis ) ;
  void getAtmos( float *pfVelX, float *pfVelY, float *pfR0) ;

private :

  /* configuration variables.  */

  configType eConfigType ;  /* configuration type */
  int iNumBins  ; 
  int iNumWaves ;
  int iNumApPts ;
  int *piModAmp ;
  int iNumStations ;
  float fApDia  ;
  float fStroke ;
  float *pfWave ;

} ;
