/** ===============================================================
    file display.hpp

    header file for display/plotting  with pgplot

    ===============================================================*/
#include "memory.h"
extern "C" {
#include "cpgplot.h"
} ;

typedef enum plotType { GRAY_SCALE, XY, CHART } ;

class display
{
public :

  display ( plotType ePlot, int iX, int iY ) ;
  display ( plotType ePlot ) ;
  display ( plotType ePlot, int iLines, float fXmin, float fXmax, float fYmin, float fYmax ) ;
  void displayFrame(  int **piData ) ;
  void chart( int i, float fX, float fY ) ;

  void range( float fXmin, float fXmax, float fYmin, float fYmax ) ;
  void plotXY ( int iPoints, float *pfX, float *pfY ) ;
  void setTitles( char *pcX, char *pcY, char *pcTop ) ;

private :

  int iFirst ;
  plotType eType ;
  int iSelect ;
  float fWhite ; 
  float fBlack ;
  float *pfData ;
  int iFrame ;
  int *piPoint ;
  int iBuffSize ;
  int iNumLines ;
  int iAutoRange ;
  float **pfX, **pfY ;

  char pcXLabel[120] ;
  char pcYLabel[120] ;
  char pcTitle[120] ;

  /* tr sets the transformation between pixels and real space */
  
  float tr[6] ;


} ;
