
#if !defined ( DMMATH_H )

#define  DMMATH_H


/*------------------------------------------------
  file dmMath.h

  header file for math functions
----------------------------------------------------*/
#define PI 3.14159265358979323
#define SWAP(a,b) {temp=(a);(a)=(b);(b)=temp;}
#define NORM(a,b) sqrt((a)*(a)+(b)*(b))
#define NORMSQ(a,b) ((a)*(a)+(b)*(b))
#define MAX(a,b) (((a)>(b)) ? (a) : (b))
#define MIN(a,b) (((a)>(b)) ? (b) : (a))
#define ABS(a)   (((a)> 0.) ? (a) : (-(a)))
#define SQR(a)   ((a)*(a))


/* structure definitions */


/*  Forward Function Definitions */

void gaussj(float **a, int n, float **b, int m ) ;
void dgaussj(double **a, int n, double **b, int m ) ;

void fourn ( float *data, int *nn , int ndim, int iSign ) ;
void dfourn ( double *data, int *nn , int ndim, int iSign ) ;

float sinc ( float fX ) ;
float n_dryAir( float fWave ) ;

/* --- end dmMath.h ------ */


#endif
