/**   ===================================================================
      fdl.cpp -- class for fdl simulations.

      Simulation of the FDL performance

      fdl  -- constructor.  sets stroke amplitude and initial delay

      readMetrology -- returnd the FDL position (microns) for the
      specified time (seconds)

      move -- Change the FDLs velocity by fDeltaVelocity at time fTime.

  ===================================================================*/


class fdl
{
public :

  fdl ( float fStroke, float fDelay0, float fServoTimeDelay ) ;
  float readMetrology ( double dfTime ) ;
  void move( float fTime, float fDeltaVelocity ) ;
  float servo ( float fTime, float fDelay ) ;

private :

  int iLast ;
  int iBufferSize ;
  float fStrokeTime ;
  float fStrokeAmp ;

  float *pfTime ;
  float *pfDelay ;
  float fTime0, fDeltaTime ;

  float fVelocity ;
  float fLastTime ;
  float fTimeDelay ;

} ;
